/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.apps.protective;

import cn.smarthse.modules.datacentre.enums.apps.ProtectClassifyEnum;
import cn.smarthse.modules.datacentre.model.apps.protective.HearingProtectionModel;
import cn.smarthse.modules.datacentre.model.apps.protective.ProtectProductModel;
import cn.smarthse.modules.datacentre.model.entity.protect.ProtectList;
import cn.smarthse.modules.datacentre.provider.apps.protective.IProtectByPlatformService;
import cn.smarthse.modules.datacentre.provider.apps.protective.IProtectListService;
import java.util.ArrayList;
import java.util.List;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService(version="3.2.0")
@Transactional(readOnly=true)
public class ProtectByPlatformServiceImpl
implements IProtectByPlatformService {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    IProtectListService plistService;

    public HearingProtectionModel getResult(Double noiseStrength, Integer valType) {
        this.logger.info("\u542c\u529b\u9632\u62a4,noiseStrength\uff1a{}\uff0cvalType\uff1a{}", (Object)noiseStrength, (Object)valType);
        if (noiseStrength == null || valType == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef!");
        }
        HearingProtectionModel model = new HearingProtectionModel();
        if (noiseStrength < 80.0) {
            model.setDesc(this.getDesc(noiseStrength));
            return model;
        }
        Double highValue = null;
        Double lowValue = null;
        if (valType == 1) {
            lowValue = 70.0;
            highValue = 75.0;
        } else if (valType == 2) {
            lowValue = 75.0;
            highValue = 80.0;
        }
        Integer classId = ProtectClassifyEnum.Noise_Protect.getId();
        List list = this.plistService.getByClassId(Long.valueOf(classId.longValue()));
        ArrayList<ProtectProductModel> modelList = new ArrayList<ProtectProductModel>();
        Double d1 = (noiseStrength - highValue) / 0.6;
        int A1 = d1.intValue();
        Double d2 = (noiseStrength - lowValue) / 0.6;
        int A2 = d2.intValue();
        Double d3 = noiseStrength - highValue + 7.0;
        int B1 = d3.intValue();
        Double d4 = noiseStrength - lowValue + 7.0;
        int B2 = d4.intValue();
        String downNoiseVal = "SNR\uff1a" + A1 + "-" + A2 + "/NRR\uff1a" + B1 + "-" + B2;
        this.logger.info("\u8ba1\u7b97\u964d\u566a\u6bd4,downNoiseVal={}", (Object)downNoiseVal);
        for (ProtectList p : list) {
            if (p == null) continue;
            ProtectProductModel productModel = this.toProtectProductModel(p);
            productModel.setDownNoiseVal(downNoiseVal);
            productModel.setRecommonedProduct("3M 2258\uff1b\u970d\u5c3c\u97e6\u5c14 2156");
            modelList.add(productModel);
        }
        model.setProducts(modelList);
        model.setDesc(this.getDesc(noiseStrength));
        model.setNotes(this.getNotes(highValue, lowValue, A1));
        return model;
    }

    private String getNotes(Double highValue, Double lowValue, Integer a) {
        if (a < 35) {
            return "\u60a8\u53ef\u4ee5\u54a8\u8be2\u5382\u5546\u6216\u7ecf\u9500\u5546\u8d2d\u4e70SNR/NRR\u5728\u6b64\u8303\u56f4\u5185\u7684\u8033\u585e\u6216\u8033\u7f69\u3002";
        }
        if (a >= 35 && a < 38) {
            if (lowValue == 70.0 && highValue == 75.0) {
                return "\u6b64\u4fdd\u62a4\u6c34\u5e73\u4e0b\uff0c\u6240\u9700\u62a4\u542c\u5668\u7684SNR\u503c\u8d85\u8fc7\u4e8635dB\uff0c\u8033\u7f69\u5f88\u5c11\u6709\u5982\u6b64\u9ad8\u7684SNR\u503c\uff0c\u53ef\u9009\u8033\u585e\u6216\u8005\u8033\u585e+\u8033\u7f69\u7684\u7ec4\u5408\u65b9\u5f0f\u9632\u62a4\uff08\u4e00\u822c\u7ec4\u5408\u65b9\u5f0f\u53ef\u4ee5\u589e\u52a05dB (A)\u7684\u9632\u62a4\u80fd\u529b\uff09\uff0c\u4e5f\u53ef\u9009\u62e975-80dB(A)\u7684\u4fdd\u62a4\u6c34\u5e73\u3002";
            }
            if (lowValue == 75.0 && highValue == 80.0) {
                return "\u6b64\u4fdd\u62a4\u6c34\u5e73\u4e0b\uff0c\u6240\u9700\u62a4\u542c\u5668\u7684SNR\u503c\u8d85\u8fc7\u4e8635dB\uff0c\u8033\u7f69\u5f88\u5c11\u6709\u5982\u6b64\u9ad8\u7684SNR\u503c\uff0c\u53ef\u9009\u8033\u585e\u6216\u8005\u8033\u585e+\u8033\u7f69\u7684\u7ec4\u5408\u65b9\u5f0f\u9632\u62a4\uff08\u4e00\u822c\u7ec4\u5408\u65b9\u5f0f\u53ef\u4ee5\u589e\u52a05dB (A)\u7684\u9632\u62a4\u80fd\u529b\uff09\u3002";
            }
        } else if (a >= 38) {
            if (lowValue == 70.0 && highValue == 75.0) {
                return "\u6b64\u4fdd\u62a4\u6c34\u5e73\u4e0b\uff0c\u6240\u9700\u62a4\u542c\u5668\u7684SNR\u503c\u8d85\u8fc7\u4e8638dB\uff0c\u5355\u4e00\u62a4\u542c\u5668\u5f88\u5c11\u6709\u5982\u6b64\u9ad8\u7684SNR\u503c\uff0c\u53ef\u9009\u8033\u585e+\u8033\u7f69\u7684\u7ec4\u5408\u65b9\u5f0f\u9632\u62a4\uff08\u4e00\u822c\u7ec4\u5408\u65b9\u5f0f\u53ef\u4ee5\u589e\u52a05dB (A)\u7684\u9632\u62a4\u80fd\u529b\uff09\uff0c\u4e5f\u53ef\u9009\u62e975-80dB(A)\u7684\u4fdd\u62a4\u6c34\u5e73\u3002\u82e5\u4ecd\u4e0d\u80fd\u6ee1\u8db3\u4fdd\u62a4\u8981\u6c42\u65f6\uff0c\u5efa\u8bae\u91c7\u53d6\u5de5\u7a0b\u63a7\u5236\u63aa\u65bd\u964d\u4f4e\u73af\u5883\u566a\u58f0\u3002\u5728\u5de5\u7a0b\u63a7\u5236\u548c\u4e2a\u4eba\u9632\u62a4\u90fd\u4e0d\u80fd\u594f\u6548\u65f6\uff0c\u5efa\u8bae\u91c7\u53d6\u7ba1\u7406\u63a7\u5236\u63aa\u65bd\uff0c\u964d\u4f4e\u4eba\u5458\u7684\u66b4\u9732\u65f6\u95f4\uff0c\u5177\u4f53\u8bf7\u54a8\u8be2\u4e13\u4e1a\u4eba\u58eb\uff01";
            }
            if (lowValue == 75.0 && highValue == 80.0) {
                return "\u6b64\u4fdd\u62a4\u6c34\u5e73\u4e0b\uff0c\u6240\u9700\u62a4\u542c\u5668\u7684SNR\u503c\u8d85\u8fc7\u4e8638dB\uff0c\u5355\u4e00\u62a4\u542c\u5668\u5f88\u5c11\u6709\u5982\u6b64\u9ad8\u7684SNR\u503c\uff0c\u53ef\u9009\u8033\u585e+\u8033\u7f69\u7684\u7ec4\u5408\u65b9\u5f0f\u9632\u62a4\uff08\u4e00\u822c\u7ec4\u5408\u65b9\u5f0f\u53ef\u4ee5\u589e\u52a05dB (A)\u7684\u9632\u62a4\u80fd\u529b\uff09\u3002\u82e5\u4ecd\u4e0d\u80fd\u6ee1\u8db3\u4fdd\u62a4\u8981\u6c42\u65f6\uff0c\u5efa\u8bae\u91c7\u53d6\u5de5\u7a0b\u63a7\u5236\u63aa\u65bd\u964d\u4f4e\u73af\u5883\u566a\u58f0\u3002\u5728\u5de5\u7a0b\u63a7\u5236\u548c\u4e2a\u4eba\u9632\u62a4\u90fd\u4e0d\u80fd\u594f\u6548\u65f6\uff0c\u5efa\u8bae\u91c7\u53d6\u7ba1\u7406\u63a7\u5236\u63aa\u65bd\uff0c\u964d\u4f4e\u4eba\u5458\u7684\u66b4\u9732\u65f6\u95f4\uff0c\u5177\u4f53\u8bf7\u54a8\u8be2\u4e13\u4e1a\u4eba\u58eb\uff01";
            }
        }
        return null;
    }

    private String getDesc(Double noiseStrength) {
        if (noiseStrength < 80.0) {
            return "\u60a8\u6240\u8f93\u5165\u76848/40\u5c0f\u65f6\u7b49\u6548A\u8ba1\u6743\u58f0\u7ea7\u503c\u5c0f\u4e8e80\u5206\u8d1d\uff0c\u6839\u636eGB/T23466-2009\u7684\u8981\u6c42\uff0c\u53ef\u4e0d\u4f69\u6234\u62a4\u542c\u5668\uff1b\u82e5\u5de5\u4f5c\u573a\u6240\u53ef\u80fd\u51fa\u73b0\u77ed\u6682\u7684\u9ad8\u5f3a\u5ea6\u566a\u58f0\uff0c\u5efa\u8bae\u914d\u5907\u5907\u7528\u7684\u62a4\u542c\u5668\uff0c\u5728\u9ad8\u566a\u58f0\u73af\u5883\u4e0b\u4f7f\u7528\u3002";
        }
        if (noiseStrength >= 80.0 && noiseStrength < 85.0) {
            return "\u60a8\u6240\u8f93\u5165\u76848/40\u5c0f\u65f6\u7b49\u6548A\u8ba1\u6743\u58f0\u7ea7\u503c\u5c0f\u4e8e85\u5206\u8d1d\uff0c\u6839\u636eGB/T23466-2009\u7684\u8981\u6c42\uff0c\u4e0d\u5f3a\u5236\u4f69\u6234\uff0c\u82e5\u4f5c\u4e1a\u4eba\u5458\u6709\u4f69\u6234\u62a4\u542c\u5668\u7684\u8981\u6c42\u65f6\uff0c\u5b9c\u4e3a\u5176\u63d0\u4f9b\u5408\u9002\u7684\u62a4\u542c\u5668\u3002";
        }
        if (noiseStrength >= 85.0) {
            return "\u60a8\u6240\u8f93\u5165\u76848/40\u5c0f\u65f6\u7b49\u6548A\u8ba1\u6743\u58f0\u7ea7\u503c\u5927\u4e8e85\u5206\u8d1d\uff0c\u6839\u636eGB/T23466-2009\u8981\u6c42\uff0c\u7528\u4eba\u5355\u4f4d\u5e94\u5f53\u4e3a\u4f5c\u4e1a\u4eba\u5458\u914d\u5907\u62a4\u542c\u5668";
        }
        return null;
    }

    private ProtectProductModel toProtectProductModel(ProtectList p) {
        ProtectProductModel model = new ProtectProductModel();
        model.setProName(p.getProName());
        model.setRemake(p.getRemake());
        return model;
    }
}

