/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.apps.occupational;

import cn.smarthse.modules.datacentre.dao.system.riskFactors.OccupationalRiskFactorsMapper;
import cn.smarthse.modules.datacentre.entity.system.riskFactors.OccupationalRiskFactors;
import cn.smarthse.modules.datacentre.model.apps.protective.HighTempModel;
import cn.smarthse.modules.datacentre.model.apps.protective.LaserModel;
import cn.smarthse.modules.datacentre.model.apps.protective.NoiseModel;
import cn.smarthse.modules.datacentre.model.entity.limit.LimitFreqPowerField;
import cn.smarthse.modules.datacentre.model.entity.limit.LimitHighFreq;
import cn.smarthse.modules.datacentre.model.entity.limit.LimitLitteWave;
import cn.smarthse.modules.datacentre.model.entity.limit.LimitSuperHighFreq;
import cn.smarthse.modules.datacentre.model.entity.limit.LimitUltravioletRay;
import cn.smarthse.modules.datacentre.model.entity.limit.LimitVibration;
import cn.smarthse.modules.datacentre.model.entity.limit.LimitWorkInPit;
import cn.smarthse.modules.datacentre.model.platform.riskFactors.HarmModel;
import cn.smarthse.modules.datacentre.model.platform.riskFactors.HarmSeachModel;
import cn.smarthse.modules.datacentre.provider.apps.occupational.IOccupationalRiskFactorsService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.util.common.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.smarthse.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService(version="3.2.0")
@Transactional(readOnly=true)
public class OccupationalRiskFactorsProviderServiceImpl
extends ZYJBaseServiceImpl<OccupationalRiskFactorsMapper, OccupationalRiskFactors>
implements IOccupationalRiskFactorsService {
    public PageInfo<HarmModel> getHazardListByHXFC(HarmSeachModel seach) {
        PageHelper.startPage((int)seach.getPage(), (int)seach.getPageSize());
        List<HarmModel> list = ((OccupationalRiskFactorsMapper)this.dao).selectHazardListByHXFC(seach.getKeyword(), seach.getInitials());
        PageInfo info = new PageInfo(list);
        return info;
    }

    public List<HarmModel> getListByType(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            throw new ServiceException("\u7c7b\u578b\u4e3a\u7a7a!");
        }
        return ((OccupationalRiskFactorsMapper)this.dao).seelectListByType(type);
    }

    public List<HarmModel> getListByInitials(String initials, String type, String keyword) {
        return ((OccupationalRiskFactorsMapper)this.dao).selectListByInitials(initials, type, keyword);
    }

    public HarmModel getModelById(Long id) {
        if (id == null) {
            throw new ServiceException("id\u4e3a\u7a7a!");
        }
        return ((OccupationalRiskFactorsMapper)this.dao).selectModelById(id);
    }

    public List<HarmModel> getListByGBZ(String type, String keyword) {
        return ((OccupationalRiskFactorsMapper)this.dao).selectListByGBZ(type, keyword);
    }

    public List<LimitFreqPowerField> getFreqPowerField() {
        return ((OccupationalRiskFactorsMapper)this.dao).selectFreqPowerField();
    }

    public List<LimitHighFreq> getHighFreq() {
        return ((OccupationalRiskFactorsMapper)this.dao).selectHighFreq();
    }

    public HighTempModel getHighTemp() {
        HighTempModel model = new HighTempModel();
        model.setLevel(((OccupationalRiskFactorsMapper)this.dao).selectHighTempLevel());
        model.setWBGT(((OccupationalRiskFactorsMapper)this.dao).selectHighTempWbgt());
        return model;
    }

    public LaserModel getLaser() {
        LaserModel model = new LaserModel();
        model.setEasy(((OccupationalRiskFactorsMapper)this.dao).selectLaserEasy());
        model.setSkin(((OccupationalRiskFactorsMapper)this.dao).selectLaserSkin());
        return model;
    }

    public List<LimitLitteWave> getLitteWave() {
        return ((OccupationalRiskFactorsMapper)this.dao).selectLitteWave();
    }

    public NoiseModel getNoise() {
        NoiseModel model = new NoiseModel();
        model.setNoise(((OccupationalRiskFactorsMapper)this.dao).selectNoise());
        model.setNoisePulse(((OccupationalRiskFactorsMapper)this.dao).selectNoisePulse());
        return model;
    }

    public List<LimitSuperHighFreq> getSuperHighFreq() {
        return ((OccupationalRiskFactorsMapper)this.dao).selectSuperHighFreq();
    }

    public List<LimitUltravioletRay> getUltravioletRay() {
        return ((OccupationalRiskFactorsMapper)this.dao).selectUltravioletRay();
    }

    public List<LimitVibration> getVibration() {
        return ((OccupationalRiskFactorsMapper)this.dao).selectVibration();
    }

    public List<LimitWorkInPit> getWorkInPit() {
        return ((OccupationalRiskFactorsMapper)this.dao).selectWorkInPit();
    }

    public cn.smarthse.modules.datacentre.model.entity.occupational.OccupationalRiskFactors getByBlendName(String name) {
        Example example = new Example(OccupationalRiskFactors.class);
        example.createCriteria().andEqualTo("isValid", (Object)true).andEqualTo("blendName", (Object)name.trim());
        cn.smarthse.modules.datacentre.model.entity.occupational.OccupationalRiskFactors occu = new cn.smarthse.modules.datacentre.model.entity.occupational.OccupationalRiskFactors();
        BeanUtils.copyProperties(this.getOneByExample(example), (Object)occu);
        return occu;
    }

    @Override
    public cn.smarthse.modules.datacentre.model.entity.occupational.OccupationalRiskFactors add(cn.smarthse.modules.datacentre.model.entity.occupational.OccupationalRiskFactors factor, Long adminId) {
        return this.add(factor, adminId);
    }
}

