/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.modules.datacentre.dao.DesensitizationFieldMapper;
import cn.smarthse.modules.datacentre.dao.DesensitizationShowClickRecordMapper;
import cn.smarthse.modules.datacentre.service.DesensitizationFieldService;
import cn.smarthse.modules.sys.entity.DesensitizationField;
import cn.smarthse.modules.sys.entity.DesensitizationShowClickRecord;
import cn.smarthse.modules.sys.model.DesensitizationShowClickRecordListParam;
import cn.smarthse.modules.sys.model.DesensitizationShowClickRecordParam;
import cn.smarthse.modules.sys.model.DesensitizationShowClickRecordVo;
import cn.smarthse.modules.sys.provider.IDesensitizationFieldProviderService;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class DesensitizationFieldProviderServiceImpl
implements IDesensitizationFieldProviderService {
    private final IdWorker idWorker;
    private final DesensitizationShowClickRecordMapper desensitizationShowClickRecordMapper;
    private final DesensitizationFieldMapper desensitizationFieldMapper;
    private final DesensitizationFieldService desensitizationFieldService;

    public String executeQuery(Long id, DesensitizationShowClickRecordParam param) {
        if (StrUtil.isBlank((CharSequence)param.getCode())) {
            throw new HealthException("\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(id)) {
            throw new HealthException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(param.getSystemWideEnum())) {
            throw new HealthException("UserSystemWideEnum\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DesensitizationField field = this.desensitizationFieldMapper.getByCodeAndSystemWide(param.getCode(), param.getSystemWideEnum().getCode());
        if (Objects.isNull(field)) {
            throw new HealthException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u677f: " + param.getCode());
        }
        String s = this.desensitizationFieldService.executeSafeQuery(param.getCode(), id, param.getSystemWideEnum());
        try {
            DesensitizationShowClickRecord record = new DesensitizationShowClickRecord();
            record.setId(Long.valueOf(this.idWorker.nextId()));
            record.setSystemWide(param.getSystemWideEnum().getCode());
            record.setCode(param.getCode());
            record.setOid(param.getOid());
            record.setUserId(param.getUserId());
            record.setUsername(param.getUsername());
            record.setIpAddress(param.getIpAddress());
            record.setClickTime(new Date());
            this.desensitizationShowClickRecordMapper.insertSelective(record);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public PageInfo<DesensitizationShowClickRecordVo> selectRecordLogList(DesensitizationShowClickRecordListParam param) {
        if (StrUtil.isBlank((CharSequence)param.getCode())) {
            throw new HealthException("\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(param.getSystemWide())) {
            throw new HealthException("systemWide\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<DesensitizationShowClickRecordVo> list = this.desensitizationShowClickRecordMapper.selectRecordLogList(param);
        return new PageInfo(list);
    }

    @Generated
    public DesensitizationFieldProviderServiceImpl(IdWorker idWorker, DesensitizationShowClickRecordMapper desensitizationShowClickRecordMapper, DesensitizationFieldMapper desensitizationFieldMapper, DesensitizationFieldService desensitizationFieldService) {
        this.idWorker = idWorker;
        this.desensitizationShowClickRecordMapper = desensitizationShowClickRecordMapper;
        this.desensitizationFieldMapper = desensitizationFieldMapper;
        this.desensitizationFieldService = desensitizationFieldService;
    }
}

