/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider;

import cn.smarthse.modules.datacentre.dao.CompanySuperviseViewMapper;
import cn.smarthse.modules.datacentre.model.ComSuperviseAreaModel;
import cn.smarthse.modules.datacentre.provider.ICompanySuperviseViewService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
public class CompanySuperviseViewServiceImp
implements ICompanySuperviseViewService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CompanySuperviseViewMapper companySuperviseViewMapper;
    private Cache<Long, List<ComSuperviseAreaModel>> commonCache = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.HOURS).maximumSize(Integer.MAX_VALUE).build();
    private final Long key = 1L;

    public void init() {
        this.logger.info("CompanySuperviseViewServiceImp::\u83b7\u53d6\u6240\u6709\u4f01\u4e1a\u7684\u533a\u57df\u4fe1\u606f...");
        this.getAll();
        this.logger.info("CompanySuperviseViewServiceImp::\u83b7\u53d6\u6240\u6709\u4f01\u4e1a\u7684\u533a\u57df\u4fe1\u606f\u5b8c\u6210");
    }

    public List<ComSuperviseAreaModel> queryComArea(Long areaId, Byte level) {
        return this.getAllComAreaModel(areaId, level);
    }

    private synchronized List<ComSuperviseAreaModel> getAll() {
        List<ComSuperviseAreaModel> list = (List<ComSuperviseAreaModel>)this.commonCache.getIfPresent((Object)this.key);
        if (list == null) {
            list = this.companySuperviseViewMapper.queryComArea(0L, null);
            this.commonCache.put((Object)this.key, list);
        }
        return list;
    }

    protected List<ComSuperviseAreaModel> getAllComAreaModel(Long areaId, Byte level) {
        List<ComSuperviseAreaModel> all = this.getAll();
        if (areaId == null || areaId.equals(0L) || level == null || level.equals((byte)0)) {
            return all;
        }
        LinkedList<ComSuperviseAreaModel> rList = new LinkedList<ComSuperviseAreaModel>();
        for (ComSuperviseAreaModel model : all) {
            Long targetAreaId = this.getTargetAreaId(level, model);
            if (!areaId.equals(targetAreaId)) continue;
            rList.add(model);
        }
        return rList;
    }

    private Long getTargetAreaId(byte level, ComSuperviseAreaModel model) {
        switch (level) {
            case 1: {
                return model.getProvinceId();
            }
            case 2: {
                return model.getCityId();
            }
            case 3: {
                return model.getAreaId();
            }
            case 4: {
                return model.getStreetId();
            }
        }
        return null;
    }
}

