/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider;

import cn.smarthse.modules.datacentre.dao.CompanyMapper;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanyGradeModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanyGradeModelV3;
import cn.smarthse.modules.datacentre.model.supervise.CompanySelfReportModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.datacentre.service.ICompanyService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService(version="1.0.0")
@Transactional(readOnly=true)
public class CompanyProvideServiceImpl
implements ICompanyProvideService {
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private CompanyMapper companyMapper;

    public List<CompanyGradeModel> listComapnyGradeInfo(List<Long> cidList) {
        return this.companyService.listComapnyGradeInfo(cidList);
    }

    public List<CompanyGradeModel> listComapnyGradeInfo2() {
        return this.companyService.listComapnyGradeInfo2();
    }

    public List<CompanyGradeModelV3> listComapnyGradeInfoV3(List<Long> cidList) {
        return this.companyService.listComapnyGradeInfoV3(cidList);
    }

    public List<CompanySelfReportModel> listSelfReportCompany() {
        return this.companyService.listSelfReportCompany();
    }

    public List<CompanyBaseInfoModel> getCompanyBaseInfoList(List<Long> cidList, Map<String, Object> param) {
        return this.companyService.getCompanyBaseInfoList(cidList, param);
    }

    @Transactional(readOnly=false)
    public void updateProductionTime(Long cid, Date productionTime) {
        Company company = new Company();
        company.setId(cid);
        company.setProductionTime(productionTime);
        this.companyService.update(company);
    }

    public Map<String, CompanyBaseInfoModel> getCompanyUnifiedSocialCcIdMap(List<String> companyNameList, List<String> unifiedSocialCcList) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(companyNameList)) {
            param.put("companyNameList", companyNameList);
        }
        if (CollectionUtils.isNotEmpty(unifiedSocialCcList)) {
            param.put("unifiedSocialCcList", unifiedSocialCcList);
        }
        List<CompanyBaseInfoModel> companyList = this.companyService.getCompanyBaseInfoList(null, param);
        return companyList.stream().collect(Collectors.toMap(CompanyBaseInfoModel::getUnifiedSocialCc, v -> v, (v1, v2) -> v1));
    }

    public Long judgeCompanyTrainingBaseByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        return this.companyMapper.getCompanyTrainingBaseByCid(cid);
    }

    public Long judgeNewCompanyBetaByCid(Long cid) {
        if (cid == null) {
            return null;
        }
        return this.companyMapper.getNewCompanyBetaByCid(cid);
    }
}

