/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.entity.CompanyDy;
import cn.smarthse.modules.datacentre.entity.CompanySupervise;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyBusinessState;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.enums.CompanyIsBestEnum;
import cn.smarthse.modules.datacentre.enums.CompanyIsDecCurrentYearEnum;
import cn.smarthse.modules.datacentre.enums.CompanyIsDecEnum;
import cn.smarthse.modules.datacentre.enums.CompanyIsExistRadioactivityEnum;
import cn.smarthse.modules.datacentre.enums.CompanyIsReportEnum;
import cn.smarthse.modules.datacentre.enums.CompanyIsSuperviseEnum;
import cn.smarthse.modules.datacentre.enums.CompanyTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanyinspectionClassificationEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.CompanyListModel;
import cn.smarthse.modules.datacentre.model.CompanyLoginModel;
import cn.smarthse.modules.datacentre.model.CompanyRefUpdateVo;
import cn.smarthse.modules.datacentre.model.CompanySearchModel;
import cn.smarthse.modules.datacentre.model.companyoutpack.CompanyAndOutpackModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseVerifyVo;
import cn.smarthse.modules.datacentre.model.supervise.ImportCompanySuperviseResultModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.service.ICompanyDyService;
import cn.smarthse.modules.datacentre.service.ICompanyRemarksService;
import cn.smarthse.modules.datacentre.service.ICompanyService;
import cn.smarthse.modules.datacentre.service.ICompanySuperviseService;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.datacentre.util.CompanySuperviseModelUtil;
import cn.smarthse.radiationTraining.modules.sys.entity.hse.HseBackCompany;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageInfo;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService(version="1.0.0")
@Transactional
public class CompanyProvideBySuperviseServiceImpl
implements ICompanyProvideBySuperviseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompanyProvideBySuperviseServiceImpl.class);
    @Autowired
    private IdWorker idworker;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private ICompanySuperviseService companySuperviseService;
    @Autowired
    private ICompanyDyService companyDyService;
    @Autowired
    private ISysAreaService sysAreaService;
    @Autowired
    private ICompanyRemarksService companyRemarksService;
    @Autowired
    private CompanySuperviseModelUtil superviseModelUtil;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;

    public PageInfo<CompanySuperviseModel> getAllOptionalEnterprisesBySystemDeploymentSourceEnum(CompanySuperviseSearchModel companySearchVo, int pageNum, int pageSize, Boolean count) {
        return this.companySuperviseService.getAllOptionalEnterprisesBySystemDeploymentSourceEnum(companySearchVo, pageNum, pageSize, count);
    }

    public PageInfo<CompanyAndOutpackModel> pageCompanyAndOutpack(CompanySuperviseSearchModel companySearchVo, int pageNum, int pageSize) {
        JqGridParam param = new JqGridParam();
        param.setPage(pageNum);
        param.setRows(pageSize);
        return this.companySuperviseService.pageCompanyAndOutpack(param, companySearchVo);
    }

    public List<CompanySuperviseModel> listCompanyInfo(CompanySuperviseSearchModel companySearchVo, boolean getBaseInfo, Boolean isOwnLevel) {
        return this.companySuperviseService.listCompanyInfo(companySearchVo, getBaseInfo, isOwnLevel);
    }

    public CompanySuperviseModel getCompanyInfoById(Long id) {
        if (id == null) {
            return null;
        }
        Company company = (Company)this.companyService.getById(id);
        return this.superviseModelUtil.company2model(company);
    }

    public CompanySuperviseModel saveImportCompany(CompanySuperviseModel companySuperviseModel, Long loginStaffId) {
        log.debug("\u5f00\u59cb\u5904\u7406\u3010{}\u3011\u4f01\u4e1a\u7684\u6570\u636e", (Object)companySuperviseModel.getName());
        if (companySuperviseModel.getId() != null) {
            this.companySuperviseService.undoDelCompanySuperviseByIds("" + companySuperviseModel.getId());
            this.updateCompanyOldIsNullField(companySuperviseModel, loginStaffId);
        } else {
            Company company = this.companySuperviseService.addCompanyInfo(companySuperviseModel, loginStaffId);
            if (Objects.nonNull(company)) {
                companySuperviseModel.setId(company.getId());
                companySuperviseModel.setCid(company.getId());
            }
        }
        log.debug("\u5904\u7406\u8be5\u4f01\u4e1a\u7684\u6570\u636e\u7ed3\u675f");
        return companySuperviseModel;
    }

    public CompanySuperviseModel getByCompanyName(String name, Integer companyType) {
        return this.superviseModelUtil.company2model(this.companyService.getCompanyByName(name, companyType));
    }

    public Map<String, Object> addCompany(CompanySuperviseModel company, Integer state, Long loginStaffId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (state == null) {
            Map<String, Object> checkInfo = this.checkAddCompanyInfo(company);
            if (checkInfo.containsKey("state")) {
                return checkInfo;
            }
            Company company1 = this.companySuperviseService.addCompanyInfo(company, loginStaffId);
            result.put("state", 0);
            result.put("msg", "\u6dfb\u52a0\u6210\u529f\uff01");
            result.put("cid", company1.getId());
            this.addHseBackCompany(company1);
        } else {
            switch (state) {
                case 2: {
                    this.updateCompanyOldIsNullField(company, loginStaffId);
                    result.put("state", 0);
                    result.put("msg", "\u66f4\u65b0\u6210\u529f\uff01");
                    break;
                }
                case 3: {
                    int i = this.companySuperviseService.undoDelCompanySuperviseByIds(String.valueOf(company.getId()));
                    this.updateCompanyOldIsNullField(company, loginStaffId);
                    result.put("state", 0);
                    result.put("msg", i > 0 ? "\u6062\u590d\u6210\u529f\uff01" : "\u6062\u590d\u5931\u8d25\uff01");
                    break;
                }
                case 4: {
                    Company company1 = this.companySuperviseService.addCompanyInfo(company, loginStaffId);
                    result.put("state", 0);
                    result.put("msg", "\u6dfb\u52a0\u6210\u529f\uff01");
                    result.put("cid", company1.getId());
                    break;
                }
                case 5: {
                    result.put("state", 1);
                    result.put("msg", "\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\uff0c\u5982\u6709\u95ee\u9898\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u7ba1\u7406\u4eba\u5458\uff01");
                }
            }
        }
        return result;
    }

    private void addHseBackCompany(Company c) {
        try {
            HseBackCompany hseBackCompany = new HseBackCompany();
            ArrayList<HseBackCompany> list = new ArrayList<HseBackCompany>(1);
            hseBackCompany.setId(c.getId());
            hseBackCompany.setName(c.getName());
            hseBackCompany.setCompanyType(c.getCompanyType());
            hseBackCompany.setIsTest(c.getIsTest());
            hseBackCompany.setIsExistRadioactivity(c.getIsExistRadioactivity());
            hseBackCompany.setShortName(c.getShortName());
            hseBackCompany.setFatherDept(c.getFatherDept());
            hseBackCompany.setSettingTime(c.getSettingTime());
            hseBackCompany.setUnifiedSocialCc(c.getUnifiedSocialCc());
            hseBackCompany.setSeq(c.getSeq());
            hseBackCompany.setSocialCcState(c.getSocialCcState());
            hseBackCompany.setCompanyContactTel(c.getCompanyContactTel());
            hseBackCompany.setCompanyContactEmail(c.getCompanyContactEmail());
            hseBackCompany.setCompanyContactFax(c.getCompanyContactFax());
            hseBackCompany.setAreaId(c.getAreaId());
            hseBackCompany.setSupervisionUnit(c.getSupervisionUnit());
            hseBackCompany.setSupervisionAreaId(c.getSupervisionAreaId());
            hseBackCompany.setRegisterAddress(c.getRegisterAddress());
            hseBackCompany.setRegisterPost(c.getRegisterPost());
            hseBackCompany.setCompanyPostalAdress(c.getCompanyPostalAdress());
            hseBackCompany.setWorkAddress(c.getWorkAddress());
            hseBackCompany.setRegisterType(c.getRegisterType());
            hseBackCompany.setIndustryCategory(c.getIndustryCategory());
            hseBackCompany.setOccupationalRiskClassify(c.getOccupationalRiskClassify());
            hseBackCompany.setStaffCount(c.getStaffCount());
            hseBackCompany.setPickupCount(c.getPickupCount());
            hseBackCompany.setMainOperaIncome(c.getMainOperaIncome());
            hseBackCompany.setRegisterCapital(c.getRegisterCapital());
            hseBackCompany.setScale(c.getScale());
            hseBackCompany.setYearAssets(c.getYearAssets());
            hseBackCompany.setTotalAssets(c.getTotalAssets());
            hseBackCompany.setLegalName(c.getLegalName());
            hseBackCompany.setLegalTel(c.getLegalTel());
            hseBackCompany.setChemicalEmergencyPhone(c.getChemicalEmergencyPhone());
            hseBackCompany.setOccLeaderSid(c.getOccLeaderSid());
            hseBackCompany.setOccLeaderTel(c.getOccLeaderTel());
            hseBackCompany.setOccManagerName(c.getOccManagerName());
            hseBackCompany.setOccManagerTel(c.getOccManagerTel());
            hseBackCompany.setMainLeaderName(c.getMainLeaderName());
            hseBackCompany.setMainLeaderTel(c.getMainLeaderTel());
            hseBackCompany.setIsValid(Boolean.valueOf(true));
            hseBackCompany.setDataSource(c.getDataSource());
            hseBackCompany.setDataSourceId(c.getDataSourceId());
            hseBackCompany.setLogoFileUrl(c.getLogoFileUrl());
            hseBackCompany.setCorpCcExtend(c.getCorpCcExtend());
            hseBackCompany.setLng(c.getLng());
            hseBackCompany.setLat(c.getLat());
            hseBackCompany.setPunishNum(c.getPunishNum());
            hseBackCompany.setIsDec(c.getIsDec());
            hseBackCompany.setIsReport(c.getIsReport());
            hseBackCompany.setBelongToRegion(c.getBelongToRegion());
            hseBackCompany.setIsReliable(c.getIsReliable());
            hseBackCompany.setCreateDate(new Date());
            hseBackCompany.setUpdateDate(new Date());
            list.add(hseBackCompany);
            this.hseCompanyProviderService.saveOrUpdateNoLogic(list);
        }
        catch (Exception e) {
            log.error("\u65b0\u589eHseBackCompany", (Throwable)e);
        }
    }

    public Map<String, Object> addCompanyForTraining(CompanySuperviseModel company, Integer state, Long loginStaffId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (state == null) {
            Map<String, Object> checkInfo = this.checkAddCompanyInfoForTraining(company);
            if (checkInfo.containsKey("state")) {
                return checkInfo;
            }
            Company company1 = this.companySuperviseService.addCompanyInfo(company, loginStaffId);
            result.put("state", 0);
            result.put("msg", "\u6dfb\u52a0\u6210\u529f\uff01");
            result.put("cid", company1.getId());
            this.addHseBackCompany(company1);
        } else {
            switch (state) {
                case 4: {
                    Company company1 = this.companySuperviseService.addCompanyInfo(company, loginStaffId);
                    result.put("state", 0);
                    result.put("msg", "\u6dfb\u52a0\u6210\u529f\uff01");
                    result.put("cid", company1.getId());
                }
            }
        }
        return result;
    }

    public CompanySuperviseModel addCompanyInfo(CompanySuperviseModel company, Long loginStaffId) {
        this.companySuperviseService.addCompanyInfo(company, loginStaffId);
        return company;
    }

    public void updateCompanyOldIsNullField(CompanySuperviseModel companySuperviseModel, Long loginStaffId) {
        Company oldCompany;
        Company newComapny = new Company();
        BeanUtils.copyProperties((Object)companySuperviseModel, (Object)newComapny);
        if (newComapny.getId() != null && (oldCompany = (Company)this.companyService.getById(newComapny.getId())) != null) {
            BeanUtils.copyProperties((Object)newComapny, (Object)oldCompany, (String[])this.getBlankField(newComapny));
            if (StringUtils.isNotBlank((CharSequence)oldCompany.getUnifiedSocialCc())) {
                oldCompany.setUnifiedSocialCc(oldCompany.getUnifiedSocialCc().toUpperCase());
            }
            this.companyService.updateByPrimaryKey(oldCompany, loginStaffId);
            CompanySupervise newComapnySupervise = new CompanySupervise();
            BeanUtils.copyProperties((Object)companySuperviseModel, (Object)newComapnySupervise);
            CompanySupervise oldComapnySupervise = this.companySuperviseService.getCompanySuperviseByCid(companySuperviseModel.getId());
            if (oldComapnySupervise != null && oldComapnySupervise.getId() != null) {
                Long id = oldComapnySupervise.getId();
                BeanUtils.copyProperties((Object)newComapnySupervise, (Object)oldComapnySupervise, (String[])this.getBlankField(newComapnySupervise));
                oldComapnySupervise.setId(id);
                this.companySuperviseService.updateSuperViseById(oldComapnySupervise, loginStaffId);
            }
        }
    }

    private String[] getBlankField(Object o) {
        BeanWrapperImpl src = new BeanWrapperImpl(o);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> EmptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            EmptyNames.add(pd.getName());
        }
        return EmptyNames.toArray(new String[EmptyNames.size()]);
    }

    public Map<String, Object> checkAddCompanyInfo(CompanySuperviseModel company) {
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        CompanySuperviseSearchModel searchVo = new CompanySuperviseSearchModel();
        searchVo.setName(company.getName());
        searchVo.setCompanyType(company.getCompanyType());
        CompanySearchModel searchModel = new CompanySearchModel();
        searchModel.setEqualsName(company.getName());
        searchModel.setCompanyType(company.getCompanyType());
        searchModel.setAllIsValid(Boolean.valueOf(true));
        List<Company> companyList = this.companyService.getCompanyList(searchModel);
        if (CollectionUtils.isNotEmpty(companyList)) {
            for (Company dbCompany : companyList) {
                if (StringUtils.isNotBlank((CharSequence)dbCompany.getUnifiedSocialCc()) && !StringUtils.equals((CharSequence)dbCompany.getUnifiedSocialCc(), (CharSequence)company.getUnifiedSocialCc())) {
                    resultData.put("state", 1);
                    resultData.put("msg", "\u65b0\u589e\u4f01\u4e1a\u4fe1\u606f\u4e0e\u76d1\u7ba1\u7cfb\u7edf\u4e2d\u5df2\u6709\u4f01\u4e1a\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\uff01");
                    return resultData;
                }
                if ((StringUtils.equals((CharSequence)dbCompany.getUnifiedSocialCc(), (CharSequence)company.getUnifiedSocialCc()) || StringUtils.isBlank((CharSequence)dbCompany.getUnifiedSocialCc())) && !StringUtils.equals((CharSequence)String.valueOf(dbCompany.getAreaId()), (CharSequence)String.valueOf(company.getAreaId()))) {
                    resultData.put("state", 1);
                    resultData.put("msg", "\u65b0\u589e\u4f01\u4e1a\u4fe1\u606f\u4e0e\u76d1\u7ba1\u7cfb\u7edf\u4e2d\u5df2\u6709\u4f01\u4e1a\u884c\u653f\u533a\u5212\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8bd5\uff01");
                    return resultData;
                }
                if (!StringUtils.equals((CharSequence)dbCompany.getUnifiedSocialCc(), (CharSequence)company.getUnifiedSocialCc()) && !StringUtils.isBlank((CharSequence)dbCompany.getUnifiedSocialCc()) || !StringUtils.equals((CharSequence)String.valueOf(dbCompany.getAreaId()), (CharSequence)String.valueOf(company.getAreaId()))) continue;
                company.setId(dbCompany.getId());
                if (dbCompany.getIsValid().equals(false)) {
                    resultData.put("state", 3);
                    resultData.put("msg", "\u65b0\u589e\u4f01\u4e1a\u4fe1\u606f\u4e0e\u76d1\u7ba1\u7cfb\u7edf\u4e2d\u88ab\u5220\u9664\u7684\u4f01\u4e1a\u4fe1\u606f\u4e00\u81f4\uff0c\u662f\u5426\u6062\u590d\u8be5\u4f01\u4e1a\u4fe1\u606f\uff1f");
                    resultData.put("result", company);
                } else {
                    resultData.put("state", 2);
                    resultData.put("msg", "\u65b0\u589e\u4f01\u4e1a\u4fe1\u606f\u4e0e\u76d1\u7ba1\u7cfb\u7edf\u4e2d\u4f01\u4e1a\u4fe1\u606f\u4e00\u81f4\uff0c\u662f\u5426\u5c06\u65b0\u6570\u636e\u586b\u5165\u5bf9\u5e94\u7684\u4f01\u4e1a\u4fe1\u606f\u4e2d\uff1f");
                    resultData.put("result", company);
                }
                return resultData;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)company.getUnifiedSocialCc())) {
            CompanySearchModel searchModelCC = new CompanySearchModel();
            searchModelCC.setUnifiedSocialCc(company.getUnifiedSocialCc());
            searchModelCC.setCompanyType(company.getCompanyType());
            List<Company> dbcompanyListByCC = this.companyService.getCompanyList(searchModelCC);
            if (CollectionUtils.isNotEmpty(dbcompanyListByCC)) {
                Integer maxSeq = dbcompanyListByCC.stream().map(Company::getSeq).max(Integer::compare).orElse(0);
                for (Company dbCompany : dbcompanyListByCC) {
                    if (StringUtils.equals((CharSequence)dbCompany.getName(), (CharSequence)company.getName())) continue;
                    resultData.put("state", 4);
                    resultData.put("msg", "\u65b0\u589e\u4f01\u4e1a\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u76d1\u7ba1\u7cfb\u7edf\u4e2d\u4f01\u4e1a\u4fe1\u606f\u4e00\u81f4\uff0c\u4f46\u4f01\u4e1a\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u662f\u5426\u521b\u5efa\u65b0\u4f01\u4e1a\uff1f");
                    company.setSeq(Integer.valueOf(maxSeq + 1));
                    company.setId(dbCompany.getId());
                    resultData.put("result", company);
                }
            }
        }
        if (company.getCompanyType() != null) {
            Integer companyTypeTemp = null;
            String tips = "";
            if (company.getCompanyType() == 1) {
                companyTypeTemp = 2;
                tips = "\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u4e8e\u5916\u5305\u5355\u4f4d\u5217\u8868\uff0c\u662f\u5426\u786e\u5b9a\u8981\u65b0\u589e\uff1f";
            } else if (company.getCompanyType() == 2) {
                companyTypeTemp = 1;
                tips = "\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728\u4e8e\u7528\u4eba\u5355\u4f4d\u5217\u8868\uff0c\u662f\u5426\u786e\u5b9a\u8981\u65b0\u589e\uff1f";
            }
            CompanySearchModel searchModelCC = new CompanySearchModel();
            searchModelCC.setUnifiedSocialCc(company.getUnifiedSocialCc());
            searchModelCC.setEqualsName(company.getName());
            searchModelCC.setCompanyType(companyTypeTemp);
            List<Company> dbcompanyListByCC = this.companyService.getCompanyList(searchModelCC);
            if (CollectionUtils.isNotEmpty(dbcompanyListByCC)) {
                resultData.put("state", 5);
                resultData.put("msg", tips);
                resultData.put("result", company);
            }
        }
        return resultData;
    }

    public Map<String, Object> checkAddCompanyInfoForTraining(CompanySuperviseModel company) {
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)company.getUnifiedSocialCc())) {
            CompanySearchModel searchModelCC = new CompanySearchModel();
            searchModelCC.setUnifiedSocialCc(company.getUnifiedSocialCc().toUpperCase());
            List<Company> dbcompanyListByCC = this.companyService.getCompanyList(searchModelCC);
            if (CollectionUtils.isNotEmpty(dbcompanyListByCC)) {
                Integer maxSeq = dbcompanyListByCC.stream().map(Company::getSeq).max(Integer::compare).orElse(0);
                for (Company dbCompany : dbcompanyListByCC) {
                    if (StringUtils.equals((CharSequence)dbCompany.getName(), (CharSequence)company.getName())) continue;
                    resultData.put("state", 4);
                    resultData.put("msg", "\u65b0\u589e\u4f01\u4e1a\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0e\u76d1\u7ba1\u7cfb\u7edf\u4e2d\u4f01\u4e1a\u4fe1\u606f\u4e00\u81f4\uff0c\u4f46\u4f01\u4e1a\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u662f\u5426\u521b\u5efa\u65b0\u4f01\u4e1a\uff1f");
                    company.setSeq(Integer.valueOf(maxSeq + 1));
                    company.setId(dbCompany.getId());
                    resultData.put("result", company);
                }
            }
        }
        return resultData;
    }

    public CompanySuperviseModel getByCompanyNameOrUnifiedSocialCode(String name, String unifiedSocialCode, Integer companyType) {
        Company company = this.companyService.getByCompanyNameOrUnifiedSocialCode(name, unifiedSocialCode, companyType);
        if (company != null) {
            CompanySuperviseModel model = new CompanySuperviseModel();
            BeanUtils.copyProperties((Object)company, (Object)model);
            return model;
        }
        return new CompanySuperviseModel();
    }

    public CompanySuperviseModel getModelByNameOrSocialCode(String name, String unifiedSocialCode, Integer companyType) {
        if (StringUtils.isBlank((CharSequence)name) && StringUtils.isBlank((CharSequence)unifiedSocialCode)) {
            return null;
        }
        Company company = this.companyService.getByCases(unifiedSocialCode, null, name, null);
        if (company != null) {
            CompanySuperviseModel model = new CompanySuperviseModel();
            BeanUtils.copyProperties((Object)company, (Object)model);
            return model;
        }
        return null;
    }

    public CompanySuperviseModel updateCompanyBaseInfo(CompanySuperviseModel c, Long loginStaffId) {
        if (c != null && c.getId() != null) {
            Company company = new Company();
            BeanUtils.copyProperties((Object)c, (Object)company);
            company.setAreaId(c.getAreaDetailId());
            if (c.getIsBest() == null) {
                c.setIsBest(Boolean.valueOf(false));
            }
            this.companyService.update(company, loginStaffId);
            this.updateCompanySupervise(c, loginStaffId);
        }
        return c;
    }

    public CompanySuperviseModel updateCompanyBaseInfoGrade(CompanySuperviseModel c, Long loginStaffId) {
        if (c != null && c.getId() != null) {
            Company company = new Company();
            BeanUtils.copyProperties((Object)c, (Object)company);
            if (c.getIsBest() == null) {
                c.setIsBest(Boolean.valueOf(false));
            }
            this.companyService.update(company, loginStaffId);
            CompanySupervise companySupervise = this.companySuperviseService.getCompanySuperviseByCid(c.getId());
            if (companySupervise == null) {
                companySupervise = new CompanySupervise();
                companySupervise.setCid(c.getId());
            }
            if (c.getIsBest() == null) {
                companySupervise.setIsBest(Boolean.valueOf(false));
            } else {
                companySupervise.setIsBest(c.getIsBest());
            }
            if (c.getIsBest() != null && c.getIsBest().booleanValue()) {
                companySupervise.setBestUpdateTime(new Date());
            }
            companySupervise.setUpdateDate(new Date());
            companySupervise.setUpdateBy(loginStaffId);
            companySupervise.setBusinessState(c.getBusinessState());
            companySupervise.setBusinessUpdateTime(c.getBusinessUpdateTime());
            companySupervise.setNameListTotal(c.getNameListTotal());
            companySupervise.setExternalTotal(c.getExternalTotal());
            companySupervise.setOccTotal(c.getOccTotal());
            companySupervise.setContactDustNum(c.getContactDustNum());
            companySupervise.setContactChemistryNum(c.getContactChemistryNum());
            companySupervise.setContactPhysicsNum(c.getContactPhysicsNum());
            companySupervise.setContactRadiationNum(c.getContactRadiationNum());
            companySupervise.setContactBiologyNum(c.getContactBiologyNum());
            companySupervise.setContactOtherNum(c.getContactOtherNum());
            companySupervise.setHasHazardFactors(c.getHasHazardFactors());
            companySupervise.setGradeReason(c.getGradeReason());
            companySupervise.setGradeCreateDate(c.getGradeCreateDate());
            companySupervise.setGovern(c.getGovern());
            companySupervise.setGovernTime(new Date());
            companySupervise.setBelongType(c.getBelongType());
            if (companySupervise.getId() != null) {
                this.companySuperviseService.updateByPrimaryKey(companySupervise, loginStaffId);
            } else {
                this.companySuperviseService.addSuperviseData(companySupervise, loginStaffId);
            }
        }
        return c;
    }

    private void updateCompanySupervise(CompanySuperviseModel c, Long loginStaffId) {
        CompanySupervise companySupervise = this.companySuperviseService.getCompanySuperviseByCid(c.getId());
        if (companySupervise == null) {
            companySupervise = new CompanySupervise();
            companySupervise.setCid(c.getId());
        }
        if (c.getIsBest() == null) {
            companySupervise.setIsBest(Boolean.valueOf(false));
        } else {
            companySupervise.setIsBest(c.getIsBest());
        }
        if (c.getIsBest() != null && c.getIsBest().booleanValue()) {
            companySupervise.setBestUpdateTime(new Date());
        }
        companySupervise.setUpdateDate(new Date());
        companySupervise.setUpdateBy(loginStaffId);
        companySupervise.setBusinessState(c.getBusinessState());
        companySupervise.setBusinessUpdateTime(c.getBusinessUpdateTime());
        companySupervise.setNameListTotal(c.getNameListTotal());
        companySupervise.setExternalTotal(c.getExternalTotal());
        companySupervise.setOccTotal(c.getOccTotal());
        companySupervise.setContactDustNum(c.getContactDustNum());
        companySupervise.setContactChemistryNum(c.getContactChemistryNum());
        companySupervise.setContactPhysicsNum(c.getContactPhysicsNum());
        companySupervise.setContactRadiationNum(c.getContactRadiationNum());
        companySupervise.setContactBiologyNum(c.getContactBiologyNum());
        companySupervise.setContactOtherNum(c.getContactOtherNum());
        companySupervise.setHasHazardFactors(c.getHasHazardFactors());
        companySupervise.setGovern(c.getGovern());
        companySupervise.setGovernTime(new Date());
        companySupervise.setBelongType(c.getBelongType());
        if (companySupervise.getId() != null) {
            this.companySuperviseService.updateByPrimaryKey(companySupervise, loginStaffId);
        } else {
            this.companySuperviseService.addSuperviseData(companySupervise, loginStaffId);
        }
    }

    public int delCompanyByIds(String ids) {
        return this.delCompanyByIds(ids, null, null);
    }

    public int delCompanyByIds(String ids, Integer delReasonItem, String delReason) {
        return this.companySuperviseService.delCompanySuperviseByIds(ids, delReasonItem, delReason);
    }

    public int bestCompanyByIds(String ids, Long loginUser) {
        return this.companySuperviseService.bestCompanyByIds(ids, loginUser);
    }

    public int cancelBestCompany(Long cid, Long loginUser) {
        CompanySupervise c = new CompanySupervise();
        c.setIsBest(Boolean.valueOf(false));
        c.setUpdateBy(loginUser);
        c.setUpdateDate(new Date());
        c.setBestUpdateTime(new Date());
        return this.companySuperviseService.updateSuperViseByCid(c, cid);
    }

    public int businessStateByIds(String ids, Byte flag, Long loginUser) {
        return this.companySuperviseService.businessStateByIds(ids, flag, loginUser);
    }

    public List<CompanyAndOutpackModel> listCompanyAndOutpack(CompanySuperviseSearchModel searchVo) {
        return this.companySuperviseService.listCompanyAndOutpack(searchVo);
    }

    public int countBelongCityCompanyNum(Long areaId) {
        return this.companyService.countBelongCityCompanyNum(areaId);
    }

    public void updateAreaIdBycid(Long cid, Long locationAddAreaId, Long updateBy) {
        this.companyService.updateAreaIdBycid(cid, locationAddAreaId, updateBy);
    }

    public Integer updateCompanySuperviseUnit(Long organizationId, Long organizationAreaId, List<Long> companyIdList) {
        return this.companyService.updateCompanySuperviseUnit(organizationId, organizationAreaId, companyIdList);
    }

    public List<Long> getAllDecCompanyIds() {
        return this.companyService.getAllDecCompanyIds();
    }

    public void updateVictimsIdentifyIds(List<Long> cidList, Integer victimsIdentify) {
        this.companyService.updateVictimsIdentifyIds(cidList, victimsIdentify);
    }

    public int batchUpdateCompanyRef(List<CompanyRefUpdateVo> updateVoList) {
        int affectRows = 0;
        if (CollectionUtils.isNotEmpty(updateVoList)) {
            affectRows = this.companyService.batchUpdateCompanyRef(updateVoList);
        }
        return affectRows;
    }

    public List<CompanySuperviseModel> allCompanyId(CompanySuperviseSearchModel searchVo) {
        return this.companySuperviseService.allCompanyId(searchVo);
    }

    public List<CompanySuperviseModel> allCompanyIdName(CompanySuperviseSearchModel searchVo) {
        return this.companyService.allCompanyIdName(searchVo);
    }

    public List<CompanySuperviseModel> selectIdName(CompanySuperviseSearchModel searchVo) {
        return this.companyService.selectIdName(searchVo);
    }

    public List<CompanySuperviseModel> listInvalidCid() {
        return this.companyService.listInvalidCid();
    }

    public List<Long> listCityLevelCid(Long areaId, Byte areaLevel) {
        return this.companyService.listCityLevelCid(areaId, areaLevel);
    }

    public void updateRemark(CompanySuperviseSearchModel searchVo, Long loginStaffId, Integer remarkLevel) {
        this.companyRemarksService.updateRemark(searchVo, loginStaffId, remarkLevel);
    }

    public void updateComsIsExistRadioactivity(List<Long> cidList, Boolean isExistRadioactivity, Long userId) {
        if (CollectionUtils.isNotEmpty(cidList)) {
            this.companyService.updateComsIsExistRadioactivity(cidList, isExistRadioactivity, userId);
        }
    }

    public Long getCompanyNumsByAreaId(Long areaId) {
        return this.companyService.getCompanyNumsByAreaId(areaId);
    }

    public List<CompanySuperviseModel> getOnlyCompanyByCid(List<Long> cidList) {
        if (CollectionUtils.isNotEmpty(cidList)) {
            List<Company> companies = this.companyService.getOnlyCompanyByCid(cidList);
            return this.simpleConvertModel(companies, Boolean.FALSE);
        }
        return Collections.emptyList();
    }

    public Map<Long, CompanySuperviseModel> getOnlyCompanyMapByCid(List<Long> cidList) {
        return this.getOnlyCompanyByCid(cidList).stream().collect(Collectors.toMap(CompanyBaseInfoModel::getId, item -> item, (v1, v2) -> v1));
    }

    public List<CompanySuperviseModel> getOnlyCompanyByName(List<String> nameList) {
        if (CollectionUtils.isNotEmpty(nameList)) {
            List<Company> companies = this.companyService.getOnlyCompanyByName(nameList);
            return this.simpleConvertModel(companies, Boolean.FALSE);
        }
        return Collections.emptyList();
    }

    public List<CompanySuperviseModel> getOnlyCompanyByNameExcludeDelete(List<String> nameList) {
        if (CollectionUtils.isNotEmpty(nameList)) {
            List<Company> companies = this.companyService.getOnlyCompanyByNameExcludeDelete(nameList);
            return this.simpleConvertModel(companies, Boolean.FALSE);
        }
        return Collections.emptyList();
    }

    public Map<String, CompanySuperviseModel> getOnlyCompanyMapByName(List<String> nameList) {
        return this.getOnlyCompanyByName(nameList).stream().collect(Collectors.toMap(CompanyBaseInfoModel::getName, item -> item, (v1, v2) -> v1));
    }

    public List<CompanySuperviseModel> getOnlyCompanyByUnitCode(List<String> codeList) {
        if (CollectionUtils.isNotEmpty(codeList)) {
            List<Company> companies = this.companyService.getOnlyCompanyByUnitCode(codeList);
            return this.simpleConvertModel(companies, Boolean.FALSE);
        }
        return Collections.emptyList();
    }

    public Map<String, List<CompanySuperviseModel>> getOnlyCompanyMapByUnitCode(List<String> codeList) {
        return this.getOnlyCompanyByUnitCode(codeList).stream().collect(Collectors.groupingBy(CompanyBaseInfoModel::getUnifiedSocialCc));
    }

    public List<CompanySuperviseModel> getOnlyCompanyByDataSourceIdExcludeDelete(List<String> dataSourceIdList, Integer dataSource) {
        if (CollectionUtils.isNotEmpty(dataSourceIdList)) {
            List<Company> companies = this.companyService.getOnlyCompanyByDataSourceIdExcludeDelete(dataSourceIdList, dataSource);
            return this.simpleConvertModel(companies, Boolean.FALSE);
        }
        return Collections.emptyList();
    }

    public List<CompanySuperviseModel> getOnlyCompanyByDataSourceDyIdExcludeDelete(List<String> dataSourceDyIdList) {
        if (CollectionUtils.isNotEmpty(dataSourceDyIdList)) {
            List<Company> companies = this.companyDyService.getOnlyCompanyByDataSourceIdExcludeDelete(dataSourceDyIdList);
            return this.simpleConvertModel(companies, Boolean.FALSE);
        }
        return Collections.emptyList();
    }

    public List<CompanySuperviseModel> getOnlyCompanySuperviseByCidExcludeDelete(List<Long> cidList) {
        return this.companyService.getOnlyCompanySuperviseByCidExcludeDelete(cidList);
    }

    public Map<Long, CompanySuperviseModel> getOnlyCompanySuperviseMapByCidExcludeDelete(List<Long> cidList) {
        return this.getOnlyCompanySuperviseByCidExcludeDelete(cidList).stream().collect(Collectors.toMap(CompanyBaseInfoModel::getCid, item -> item, (v1, v2) -> v1));
    }

    public List<CompanySuperviseModel> getCompanyAndCompanySuperviseByCid(List<Long> cidList) {
        if (CollectionUtils.isNotEmpty(cidList)) {
            List<Company> companies = this.companyService.getOnlyCompanyByCid(cidList);
            return this.simpleConvertModel(companies, Boolean.TRUE);
        }
        return Collections.emptyList();
    }

    public Map<Long, CompanySuperviseModel> getCompanyAndCompanySuperviseMapByCid(List<Long> cidList) {
        return this.getCompanyAndCompanySuperviseByCid(cidList).stream().collect(Collectors.toMap(CompanyBaseInfoModel::getId, item -> item, (v1, v2) -> v1));
    }

    public List<CompanySuperviseModel> getCompanyAndCompanySuperviseByCidExcludeDelete(List<Long> idList) {
        if (CollectionUtils.isNotEmpty(idList)) {
            List<Company> companies = this.companyService.getOnlyCompanyByCidExcludeDelete(idList);
            return this.simpleConvertModel(companies, Boolean.TRUE);
        }
        return Collections.emptyList();
    }

    public Map<Long, CompanySuperviseModel> getCompanyAndCompanySuperviseByCidMapExcludeDelete(List<Long> idList) {
        return this.getCompanyAndCompanySuperviseByCidExcludeDelete(idList).stream().collect(Collectors.toMap(CompanyBaseInfoModel::getId, Function.identity()));
    }

    public List<CompanySuperviseModel> getCompanyAndCompanySuperviseByNameExcludeDelete(List<String> nameList) {
        if (CollectionUtils.isNotEmpty(nameList)) {
            List<Company> companies = this.companyService.getOnlyCompanyByNameExcludeDelete(nameList);
            return this.simpleConvertModel(companies, Boolean.TRUE);
        }
        return Collections.emptyList();
    }

    public List<CompanySuperviseModel> getCompanyAndCompanySuperviseAndCompanyDyByNameExcludeDelete(List<String> nameList) {
        List<CompanySuperviseModel> rst = this.getCompanyAndCompanySuperviseByNameExcludeDelete(nameList);
        if (CollUtil.isNotEmpty(rst)) {
            List<Long> cidList = rst.stream().map(CompanyBaseInfoModel::getId).collect(Collectors.toList());
            List<CompanyDy> companyDyList = this.companyDyService.getListByIdList(cidList);
            if (CollUtil.isNotEmpty(companyDyList)) {
                CompanyDy orgnCompanyDy = new CompanyDy();
                Map<Long, CompanyDy> map = companyDyList.stream().collect(Collectors.toMap(CompanyDy::getCid, item -> item, (v1, v2) -> v1));
                rst.forEach(i -> i.setDataSourceDyId(map.getOrDefault(i.getId(), orgnCompanyDy).getDataSourceId()));
            }
            return rst;
        }
        return Collections.emptyList();
    }

    public Map<String, CompanySuperviseModel> getCompanyAndCompanySuperviseMapByNameExcludeDelete(List<String> nameList) {
        return this.getCompanyAndCompanySuperviseByNameExcludeDelete(nameList).stream().collect(Collectors.toMap(CompanyBaseInfoModel::getName, Function.identity()));
    }

    public List<CompanySuperviseModel> getCompanyAndCompanySuperviseByUnitCode(List<String> codeList) {
        if (CollectionUtils.isNotEmpty(codeList)) {
            List<Company> companies = this.companyService.getOnlyCompanyByUnitCode(codeList);
            return this.simpleConvertModel(companies, Boolean.TRUE);
        }
        return Collections.emptyList();
    }

    public Map<String, List<CompanySuperviseModel>> getCompanyAndCompanySuperviseMapByUnitCode(List<String> codeList) {
        return this.getCompanyAndCompanySuperviseByUnitCode(codeList).stream().collect(Collectors.groupingBy(CompanyBaseInfoModel::getUnifiedSocialCc));
    }

    public List<CompanySuperviseModel> getCompanyAndCompanySuperviseByUnitCodeExcludeDelete(List<String> codeList) {
        if (CollectionUtils.isNotEmpty(codeList)) {
            List<Company> companies = this.companyService.getOnlyCompanyByUnitCodeExcludeDelete(codeList);
            return this.simpleConvertModel(companies, Boolean.TRUE);
        }
        return Collections.emptyList();
    }

    public Map<String, List<CompanySuperviseModel>> getCompanyAndCompanySuperviseMapByUnitCodeExcludeDelete(List<String> codeList) {
        return this.getCompanyAndCompanySuperviseByUnitCodeExcludeDelete(codeList).stream().collect(Collectors.groupingBy(CompanyBaseInfoModel::getUnifiedSocialCc));
    }

    public void updateCompanyAndCompanySuperviseByOne(CompanySuperviseModel c, Long loginStaffId) {
        ArrayList<CompanySuperviseModel> rst = new ArrayList<CompanySuperviseModel>(1);
        rst.add(c);
        this.updateCompanyAndCompanySuperviseByList(rst, loginStaffId);
    }

    public void updateCompanyAndCompanySuperviseByList(List<CompanySuperviseModel> list, Long loginStaffId) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        try {
            this.updateCompanyByIdList(list, loginStaffId);
            this.updateCompanySuperviseByCidList(list, loginStaffId);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u4f01\u4e1a-v3 Exception\uff1a", (Throwable)e);
            throw e;
        }
    }

    public void updateCompanyByIdList(List<CompanySuperviseModel> list, Long loginStaffId) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        List<String> companyUnitCodeList = list.stream().filter(i -> StrUtil.isNotBlank((CharSequence)i.getUnifiedSocialCc())).map(i -> i.getUnifiedSocialCc().toUpperCase()).collect(Collectors.toList());
        Map<String, List<CompanySuperviseModel>> companySuperviseModelListMap = this.getCompanyAndCompanySuperviseMapByUnitCode(companyUnitCodeList);
        ArrayList protoList = new ArrayList(1);
        Date date = new Date();
        ArrayList<Company> rst = new ArrayList<Company>(list.size());
        list.forEach(i -> {
            if (Objects.nonNull(i.getId()) || Objects.nonNull(i.getCid())) {
                Company c = new Company();
                BeanUtils.copyProperties((Object)i, (Object)c);
                if (Objects.isNull(c.getId())) {
                    c.setId(i.getCid());
                }
                if (Objects.isNull(c.getAreaId())) {
                    c.setAreaId(i.getAreaDetailId());
                }
                if (StrUtil.isNotBlank((CharSequence)c.getUnifiedSocialCc())) {
                    c.setUnifiedSocialCc(c.getUnifiedSocialCc().toUpperCase());
                    List sameCodeList = companySuperviseModelListMap.getOrDefault(c.getUnifiedSocialCc(), protoList);
                    if (CollUtil.isNotEmpty((Collection)sameCodeList)) {
                        int maxSeq = sameCodeList.stream().mapToInt(CompanyBaseInfoModel::getSeq).max().orElse(0);
                        c.setSeq(Integer.valueOf(sameCodeList.stream().anyMatch(z -> Objects.equals(z.getId(), c.getId())) ? maxSeq : maxSeq + 1));
                    } else {
                        c.setSeq(Integer.valueOf(0));
                    }
                }
                c.setUpdateBy(loginStaffId);
                c.setUpdateDate(date);
                rst.add(c);
            }
        });
        if (CollUtil.isNotEmpty(rst)) {
            this.companyService.updateCompanyByIdList(rst);
        }
    }

    public void updateCompanySuperviseByCidList(List<CompanySuperviseModel> list, Long loginStaffId) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        Date date = new Date();
        ArrayList<CompanySupervise> rst = new ArrayList<CompanySupervise>(list.size());
        list.forEach(i -> {
            if (Objects.nonNull(i.getId()) || Objects.nonNull(i.getCid())) {
                CompanySupervise s = new CompanySupervise();
                BeanUtils.copyProperties((Object)i, (Object)s);
                if (Objects.isNull(s.getCid())) {
                    s.setCid(i.getId());
                }
                s.setId(null);
                s.setUpdateBy(loginStaffId);
                s.setUpdateDate(date);
                rst.add(s);
            }
        });
        if (CollUtil.isNotEmpty(rst)) {
            this.companySuperviseService.updateCompanySuperviseByCidList(rst);
        }
    }

    public void saveCompanyAndCompanySuperviseByOne(CompanySuperviseModel c, Long loginStaffId) {
        ArrayList<CompanySuperviseModel> rst = new ArrayList<CompanySuperviseModel>(1);
        rst.add(c);
        this.saveCompanyAndCompanySuperviseByList(rst, loginStaffId);
    }

    public void saveCompanyAndCompanySuperviseByList(List<CompanySuperviseModel> list, Long loginStaffId) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        try {
            list = this.saveCompanyByList(list, loginStaffId);
            this.saveCompanySuperviseByList(list, loginStaffId);
            try {
                ArrayList<HseBackCompany> hseBackCompanyList = new ArrayList<HseBackCompany>(list.size());
                for (CompanySuperviseModel c : list) {
                    HseBackCompany hseBackCompany = new HseBackCompany();
                    hseBackCompany.setId(c.getId());
                    hseBackCompany.setName(c.getName());
                    hseBackCompany.setCompanyType(c.getCompanyType());
                    hseBackCompany.setIsTest(c.getIsTest());
                    hseBackCompany.setIsExistRadioactivity(c.getIsExistRadioactivity());
                    hseBackCompany.setShortName(c.getShortName());
                    hseBackCompany.setFatherDept(c.getFatherDept());
                    hseBackCompany.setSettingTime(c.getSettingTime());
                    hseBackCompany.setUnifiedSocialCc(c.getUnifiedSocialCc());
                    hseBackCompany.setSeq(c.getSeq());
                    hseBackCompany.setSocialCcState(c.getSocialCcState());
                    hseBackCompany.setCompanyContactTel(c.getCompanyContactTel());
                    hseBackCompany.setCompanyContactEmail(c.getCompanyContactEmail());
                    hseBackCompany.setCompanyContactFax(c.getCompanyContactFax());
                    hseBackCompany.setAreaId(c.getAreaDetailId());
                    hseBackCompany.setSupervisionUnit(c.getSupervisionUnit());
                    hseBackCompany.setSupervisionAreaId(c.getSupervisionAreaId());
                    hseBackCompany.setRegisterAddress(c.getRegisterAddress());
                    hseBackCompany.setRegisterPost(c.getRegisterPost());
                    hseBackCompany.setCompanyPostalAdress(c.getCompanyPostalAdress());
                    hseBackCompany.setWorkAddress(c.getWorkAddress());
                    hseBackCompany.setRegisterType(c.getRegisterType());
                    hseBackCompany.setIndustryCategory(c.getIndustryCategory());
                    hseBackCompany.setOccupationalRiskClassify(c.getOccupationalRiskClassify());
                    hseBackCompany.setStaffCount(c.getStaffCount());
                    hseBackCompany.setPickupCount(c.getPickupCount());
                    hseBackCompany.setMainOperaIncome(c.getMainOperaIncome());
                    hseBackCompany.setRegisterCapital(c.getRegisterCapital());
                    hseBackCompany.setScale(c.getScale());
                    hseBackCompany.setYearAssets(c.getYearAssets());
                    hseBackCompany.setTotalAssets(c.getTotalAssets());
                    hseBackCompany.setLegalName(c.getLegalName());
                    hseBackCompany.setLegalTel(c.getLegalTel());
                    hseBackCompany.setChemicalEmergencyPhone(c.getChemicalEmergencyPhone());
                    hseBackCompany.setOccLeaderSid(c.getOccLeaderSid());
                    hseBackCompany.setOccLeaderTel(c.getOccLeaderTel());
                    hseBackCompany.setOccManagerName(c.getOccManagerName());
                    hseBackCompany.setOccManagerTel(c.getOccManagerTel());
                    hseBackCompany.setMainLeaderName(c.getMainLeaderName());
                    hseBackCompany.setMainLeaderTel(c.getMainLeaderTel());
                    hseBackCompany.setIsValid(Boolean.valueOf(true));
                    hseBackCompany.setDataSource(c.getDataSource());
                    hseBackCompany.setDataSourceId(c.getDataSourceId());
                    hseBackCompany.setLogoFileUrl(c.getLogoFileUrl());
                    hseBackCompany.setCorpCcExtend(c.getCorpCcExtend());
                    hseBackCompany.setLng(c.getLng());
                    hseBackCompany.setLat(c.getLat());
                    hseBackCompany.setPunishNum(c.getPunishNum());
                    hseBackCompany.setIsDec(c.getIsDec());
                    hseBackCompany.setIsReport(c.getIsReport());
                    hseBackCompany.setBelongToRegion(c.getBelongToRegion());
                    hseBackCompany.setIsReliable(c.getIsReliable());
                    hseBackCompany.setCreateBy(loginStaffId);
                    hseBackCompany.setUpdateBy(loginStaffId);
                    hseBackCompany.setCreateDate(new Date());
                    hseBackCompany.setUpdateDate(new Date());
                    hseBackCompanyList.add(hseBackCompany);
                }
                this.hseCompanyProviderService.saveOrUpdateNoLogic(hseBackCompanyList);
            }
            catch (Exception e) {
                log.error("\u65b0\u589eHseBackCompany", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u4f01\u4e1a-v3 Exception\uff1a", (Throwable)e);
            throw e;
        }
    }

    private List<CompanySuperviseModel> saveCompanyByList(List<CompanySuperviseModel> list, Long loginStaffId) {
        List<Company> nameModelList;
        if (CollUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        List<String> companyNameList = list.stream().filter(i -> StrUtil.isNotBlank((CharSequence)i.getName())).map(CompanyBaseInfoModel::getName).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(companyNameList) && CollUtil.isNotEmpty(nameModelList = this.companyService.getOnlyCompanyByNameExcludeDelete(companyNameList))) {
            throw new ServiceException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f01\u4e1a\u540d\u79f0");
        }
        List<String> companyUnitCodeList = list.stream().map(CompanyBaseInfoModel::getUnifiedSocialCc).collect(Collectors.toList());
        List<Company> unifiedCcModelList = this.companyService.getOnlyCompanyByUnitCode(companyUnitCodeList);
        Map<Object, Object> unifiedCcModelMap = new HashMap();
        if (CollUtil.isNotEmpty(unifiedCcModelList)) {
            unifiedCcModelMap = unifiedCcModelList.stream().collect(Collectors.groupingBy(Company::getUnifiedSocialCc, Collectors.collectingAndThen(Collectors.maxBy(Comparator.comparingInt(Company::getSeq)), optionalMax -> optionalMax.map(max -> max.getSeq() + 1).orElse(0))));
        }
        HashMap finalUnifiedCcModelMap = unifiedCcModelMap;
        Date date = new Date();
        ArrayList<Company> rst = new ArrayList<Company>(list.size());
        list.forEach(i -> {
            Company c = new Company();
            BeanUtils.copyProperties((Object)i, (Object)c);
            if (Objects.isNull(c.getId())) {
                c.setId(i.getCid());
            }
            if (Objects.isNull(c.getId())) {
                c.setId(Long.valueOf(this.idworker.nextId()));
            }
            i.setId(c.getId());
            if (StrUtil.isNotBlank((CharSequence)c.getUnifiedSocialCc())) {
                c.setUnifiedSocialCc(c.getUnifiedSocialCc().toUpperCase());
                c.setSeq(finalUnifiedCcModelMap.getOrDefault(c.getUnifiedSocialCc(), 0));
            }
            if (Objects.isNull(c.getAreaId())) {
                c.setAreaId(i.getAreaDetailId());
            }
            if (Objects.isNull(c.getCompanyType())) {
                c.setCompanyType(CompanyTypeEnum.ONE.getCode());
            }
            if (Objects.isNull(c.getShortName())) {
                c.setShortName(c.getName());
            }
            if (Objects.isNull(c.getIsTest())) {
                c.setIsTest(Boolean.FALSE);
            }
            if (Objects.isNull(c.getIsDec())) {
                c.setIsDec(CompanyIsDecEnum.FALSE.getCode());
            }
            if (Objects.isNull(c.getIsDecCurrentYear())) {
                c.setIsDecCurrentYear(CompanyIsDecCurrentYearEnum.FALSE.getCode());
            }
            if (Objects.isNull(c.getIsReport())) {
                c.setIsReport(CompanyIsReportEnum.NODECLARED.getValue());
            }
            if (Objects.isNull(c.getDataSource())) {
                c.setDataSource(CompanyDataSourceEnum.SUPERVISE.getValue());
            }
            if (Objects.isNull(c.getIsReliable())) {
                c.setIsReliable(Boolean.FALSE);
            }
            if (Objects.isNull(c.getIsExistRadioactivity())) {
                c.setIsExistRadioactivity(CompanyIsExistRadioactivityEnum.FALSE.getCode());
            }
            if (Objects.isNull(c.getIsSupervise())) {
                c.setIsSupervise(CompanyIsSuperviseEnum.FALSE.getCode());
            }
            if (Objects.isNull(c.getCreditSupervise())) {
                c.setCreditSupervise(Integer.valueOf(0));
            }
            if (Objects.isNull(c.getSocialCcState())) {
                c.setSocialCcState(Integer.valueOf(0));
            }
            if (Objects.isNull(c.getStaffCount())) {
                c.setStaffCount(Integer.valueOf(0));
            }
            if (Objects.isNull(c.getPickupCount())) {
                c.setPickupCount(null);
            }
            if (Objects.isNull(c.getVictimsIdentify())) {
                c.setVictimsIdentify(Integer.valueOf(0));
            }
            if (Objects.isNull(c.getPunishNum())) {
                c.setPunishNum(Integer.valueOf(0));
            }
            c.setIsValid(Boolean.TRUE);
            c.setCreateBy(loginStaffId);
            c.setUpdateBy(loginStaffId);
            c.setCreateDate(date);
            c.setUpdateDate(date);
            rst.add(c);
        });
        if (CollUtil.isNotEmpty(rst)) {
            this.companyService.saveCompanyByIdList(rst);
        }
        return list;
    }

    private void saveCompanySuperviseByList(List<CompanySuperviseModel> list, Long loginStaffId) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        Date date = new Date();
        ArrayList<CompanySupervise> rst = new ArrayList<CompanySupervise>(list.size());
        list.forEach(i -> {
            if (Objects.nonNull(i.getId())) {
                CompanySupervise s = new CompanySupervise();
                BeanUtils.copyProperties((Object)i, (Object)s);
                s.setId(Long.valueOf(this.idworker.nextId()));
                s.setCid(i.getId());
                if (Objects.isNull(s.getInspectionClassification())) {
                    s.setInspectionClassification(CompanyinspectionClassificationEnum.NO.getValue());
                }
                if (Objects.isNull(s.getIsBest())) {
                    s.setIsBest(CompanyIsBestEnum.FALSE.getCode());
                }
                if (Objects.isNull(s.getGovern())) {
                    s.setGovern(Boolean.FALSE);
                }
                if (Objects.isNull(s.getBelongType())) {
                    s.setBelongType(CompanyBelongTypeEnum.NO.getValue());
                }
                if (Objects.isNull(s.getSuperviseIsHide())) {
                    s.setSuperviseIsHide(Boolean.FALSE);
                }
                if (Objects.isNull(s.getSuperviseIsDel())) {
                    s.setSuperviseIsDel(Boolean.FALSE);
                }
                if (Objects.isNull(s.getBusinessState())) {
                    s.setBusinessState(Byte.valueOf(CompanyBusinessState.NORMAL.getCode().byteValue()));
                }
                s.setIsValid(Boolean.TRUE);
                s.setCreateBy(loginStaffId);
                s.setUpdateBy(loginStaffId);
                s.setCreateDate(date);
                s.setUpdateDate(date);
                rst.add(s);
            }
        });
        if (CollUtil.isNotEmpty(rst)) {
            List<CompanySuperviseModel> cidModelList;
            List<Long> companyCidList = rst.stream().filter(i -> Objects.nonNull(i.getCid())).map(CompanySupervise::getCid).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(companyCidList) && CollUtil.isNotEmpty(cidModelList = this.companyService.getOnlyCompanySuperviseByCidExcludeDelete(companyCidList))) {
                throw new ServiceException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f01\u4e1aID");
            }
            this.companySuperviseService.saveCompanySuperviseList(rst);
        }
    }

    public void rollbackImportCompanyAndCompanySuperviseData(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        this.companyService.deleteCompanyCompletely(idList);
        this.companySuperviseService.deleteCompanyCompletely(idList);
    }

    public Boolean isHaveThisName(String name, Long excludeId, Boolean isValid) {
        return this.companyService.isHaveThisName(name, excludeId, isValid);
    }

    public Boolean isHaveThisCreditCode(String creditCode, Long excludeId, Boolean isValid) {
        return this.companyService.isHaveThisCreditCode(creditCode, excludeId, isValid);
    }

    private List<CompanySuperviseModel> simpleConvertModel(List<Company> companies, Boolean addSubTable) {
        if (Objects.isNull(addSubTable)) {
            addSubTable = Boolean.FALSE;
        }
        if (CollUtil.isNotEmpty(companies)) {
            Map<Object, Object> map = Collections.emptyMap();
            if (addSubTable.booleanValue()) {
                map = this.getOnlyCompanySuperviseMapByCidExcludeDelete(companies.stream().map(Company::getId).distinct().collect(Collectors.toList()));
            }
            ArrayList<CompanySuperviseModel> rst = new ArrayList<CompanySuperviseModel>(companies.size());
            for (Company company : companies) {
                CompanySuperviseModel companySupervise;
                CompanySuperviseModel companyInfo = new CompanySuperviseModel();
                BeanUtils.copyProperties((Object)company, (Object)companyInfo);
                companyInfo.setCid(company.getId());
                companyInfo.setAreaDetailId(company.getAreaId());
                if (addSubTable.booleanValue() && Objects.nonNull(companySupervise = (CompanySuperviseModel)map.get(companyInfo.getId()))) {
                    companyInfo.setInspectionClassification(companySupervise.getInspectionClassification());
                    companyInfo.setIsBest(companySupervise.getIsBest());
                    companyInfo.setBestUpdateTime(companySupervise.getBestUpdateTime());
                    companyInfo.setGovern(companySupervise.getGovern());
                    companyInfo.setGovernTime(companySupervise.getGovernTime());
                    companyInfo.setOperationStatus(companySupervise.getOperationStatus());
                    companyInfo.setReportCompanyName(companySupervise.getReportCompanyName());
                    companyInfo.setReportDate(companySupervise.getReportDate());
                    companyInfo.setReportType(companySupervise.getReportType());
                    companyInfo.setBelongType(companySupervise.getBelongType());
                    companyInfo.setSuperviseIsHide(companySupervise.getSuperviseIsHide());
                    companyInfo.setSuperviseIsDel(companySupervise.getSuperviseIsDel());
                    companyInfo.setSuperviseDelTime(companySupervise.getSuperviseDelTime());
                    companyInfo.setDelReasonItem(companySupervise.getDelReasonItem());
                    companyInfo.setDelReason(companySupervise.getDelReason());
                    companyInfo.setRecoverTime(companySupervise.getRecoverTime());
                    companyInfo.setBusinessState(companySupervise.getBusinessState());
                    companyInfo.setIrsBusinessState(companySupervise.getIrsBusinessState());
                    companyInfo.setBusinessUpdateTime(companySupervise.getBusinessUpdateTime());
                    companyInfo.setNameListTotal(companySupervise.getNameListTotal());
                    companyInfo.setExternalTotal(companySupervise.getExternalTotal());
                    companyInfo.setOccTotal(companySupervise.getOccTotal());
                    companyInfo.setContactDustNum(companySupervise.getContactDustNum());
                    companyInfo.setContactChemistryNum(companySupervise.getContactChemistryNum());
                    companyInfo.setContactPhysicsNum(companySupervise.getContactPhysicsNum());
                    companyInfo.setContactRadiationNum(companySupervise.getContactRadiationNum());
                    companyInfo.setContactBiologyNum(companySupervise.getContactBiologyNum());
                    companyInfo.setContactOtherNum(companySupervise.getContactOtherNum());
                    companyInfo.setHasHazardFactors(companySupervise.getHasHazardFactors());
                    companyInfo.setIrsBusinessState(companySupervise.getIrsBusinessState());
                    companyInfo.setGradeCreateDate(companySupervise.getGradeCreateDate());
                }
                rst.add(companyInfo);
            }
            return rst;
        }
        return Collections.emptyList();
    }

    public List<CompanyLoginModel> getLoginModelByUnifiedSocialCc(String unifiedSocialCc) {
        List<Company> companies = this.companyService.getByUnifiedSocialCc(unifiedSocialCc);
        if (CollectionUtils.isNotEmpty(companies)) {
            return companies.stream().map(item -> {
                CompanyLoginModel model = new CompanyLoginModel();
                model.setCid(item.getId());
                model.setCompanyName(item.getName());
                return model;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<CompanyListModel> getByUnifiedSocialCc(List<String> unifiedSocialCodes) {
        List<Company> list = this.companyService.getByUnifiedSocialCc(unifiedSocialCodes);
        return list.stream().map(company -> {
            CompanyListModel model = new CompanyListModel();
            model.setAreaId(company.getAreaId());
            model.setUnifiedSocialCc(company.getUnifiedSocialCc());
            model.setId(company.getId());
            model.setName(company.getName());
            model.setShortName(company.getShortName());
            model.setSocialCcState(company.getSocialCcState());
            return model;
        }).collect(Collectors.toList());
    }

    public CompanySuperviseModel updateCompanyOnlyBaseInfo(CompanySuperviseModel c, Long loginStaffId) {
        if (c != null && c.getId() != null) {
            Company company = new Company();
            BeanUtils.copyProperties((Object)c, (Object)company);
            this.companyService.update(company, loginStaffId);
        }
        return c;
    }

    public List<String> getAllImportBatchNo() {
        return this.companyService.getAllImportBatchNo();
    }

    public PageInfo<CompanySuperviseVerifyVo> getVerify2025Company(CompanySuperviseSearchModel model, int page, int rows) {
        return this.companySuperviseService.getVerify2025Company(model, page, rows);
    }

    public void updateCompanyGradeReason(Long cid, Integer gradeReason, Date gradeCreateDate, Long userId) {
        this.companySuperviseService.updateCompanyGradeReason(cid, gradeReason, gradeCreateDate, userId);
    }

    public List<Long> updateCompanyCase(List<Long> cidList, Integer type) {
        return this.companyService.updateCompanyCase(cidList, type);
    }

    public ImportCompanySuperviseResultModel batchAddCompany(List<CompanySuperviseModel> companyList, Boolean hasErrorAbort) {
        if (CollectionUtils.isEmpty(companyList)) {
            return null;
        }
        ImportCompanySuperviseResultModel importCompanySuperviseModels = this.companySuperviseService.batchAddCompany(companyList, hasErrorAbort);
        return importCompanySuperviseModels;
    }
}

