/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.smarthse.modules.datacentre.dao.CompanyProposedChangeMapper;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.enums.StopStatusEnums;
import cn.smarthse.modules.datacentre.enums.StopTypeEnums;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeStatusForIdParam;
import cn.smarthse.modules.datacentre.model.CompanyProposedChangeVo;
import cn.smarthse.modules.datacentre.model.CompanySearchModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProposedChangeProviderService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.service.ICompanyService;
import cn.smarthse.modules.datacentre.service.ICompanySuperviseService;
import cn.smarthse.modules.datacentre.service.childtable.IAddData2ChildTableService;
import cn.smarthse.modules.datacentre.util.CompanyBaseInfoModelUtil;
import cn.smarthse.modules.datacentre.util.StringUtils;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService(version="1.0.0")
public class CompanyProvideByHSEServiceImpl
implements ICompanyProvideByHSEService,
IAddData2ChildTableService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private Cache<String, Map<String, Long>> commonCache = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.HOURS).maximumSize(Integer.MAX_VALUE).build();
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private ICompanySuperviseService superviseService;
    @Autowired
    private CompanyBaseInfoModelUtil companyBaseInfoModelUtil;
    @Autowired
    private ISysAreaProvideService sysAreaProvideService;
    @Autowired
    private ICompanyProposedChangeProviderService companyProposedChangeProviderService;
    @Autowired
    private CompanyProposedChangeMapper companyProposedChangeMapper;

    @Transactional
    public CompanyBaseInfoModel getCompanyById(Long id) {
        if (id == null) {
            return new CompanyBaseInfoModel();
        }
        Company company = (Company)this.companyService.getById(id);
        if (company != null) {
            CompanyBaseInfoModel companyBaseInfoModel = this.companyBaseInfoModelUtil.company2model(company);
            return companyBaseInfoModel;
        }
        return new CompanyBaseInfoModel();
    }

    public List<Company> getCompanyByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Company>();
        }
        String idsString = ids.stream().map(String::valueOf).collect(Collectors.joining(","));
        List<Company> listByIds = this.companyService.getListByIds(idsString);
        if (CollectionUtil.isNotEmpty(listByIds)) {
            return listByIds;
        }
        return new ArrayList<Company>();
    }

    @Transactional
    public String getCompanyNameById(Long id) {
        if (id == null) {
            return "";
        }
        Company company = (Company)this.companyService.getById(id);
        if (company != null) {
            return company.getName();
        }
        return "";
    }

    @Transactional(readOnly=false)
    public int updateOccType(Long cid, Integer occType) {
        Company company = new Company();
        company.setId(cid);
        company.setOccupationalRiskClassify(occType);
        return this.companyService.update(company);
    }

    public int batchUpdateOccType(List<CompanySuperviseModel> superviseModelList) {
        if (CollectionUtils.isNotEmpty(superviseModelList)) {
            for (List companySuperviseModels : ListUtil.partition(superviseModelList, (int)1000)) {
                this.superviseService.batchUpdateOccType(companySuperviseModels);
            }
            return 1;
        }
        return 0;
    }

    public int batchUpdatePickupCount(List<CompanySuperviseModel> superviseModelList) {
        if (CollectionUtils.isNotEmpty(superviseModelList)) {
            this.logger.info("\u66f4\u65b0\u6570\u636e\u91cf\uff1a{}", (Object)superviseModelList.size());
            Set<Long> cidSet = superviseModelList.stream().map(CompanyBaseInfoModel::getId).collect(Collectors.toSet());
            List<CompanySuperviseModel> oldDbCompanySuperviseModels = null;
            oldDbCompanySuperviseModels = cidSet.size() == 1 ? this.companyService.listCompanyPickCount(cidSet) : this.companyService.listCompanyPickCount(null);
            try {
                List superviseModelListList = ListUtil.partition(superviseModelList, (int)1000);
                for (List companySuperviseModels : superviseModelListList) {
                    this.superviseService.batchUpdatePickupCount(companySuperviseModels, oldDbCompanySuperviseModels);
                }
            }
            catch (Exception e) {
                this.logger.error("\u66f4\u65b0\u63a5\u5bb3\u4eba\u6570\u9519\u8bef\uff1a", (Throwable)e);
            }
            this.logger.info("\u66f4\u65b0\u4f01\u4e1a\u8868\u6570\u636e\u63a5\u5bb3\u4eba\u6570\u5b8c\u6210...");
            return 1;
        }
        return 0;
    }

    @Transactional(readOnly=false)
    public int batchUpdateSupervise(List<Long> cidSet) {
        if (CollectionUtils.isNotEmpty(cidSet)) {
            this.logger.info("\u66f4\u65b0\u6570\u636e\u91cf\uff1a{}", (Object)cidSet.size());
            int updater = this.handBatch(cidSet, l -> {
                this.superviseService.batchUpdateSupervise(new HashSet<Long>((Collection<Long>)l));
                return 1;
            });
            this.logger.info("\u66f4\u65b0\u4f01\u4e1a\u8868\u6570\u636e\u63a5\u5bb3\u4eba\u6570\u5b8c\u6210...");
            return updater;
        }
        return 0;
    }

    private int handBatch(List dataList, Function<List, Integer> consumer) {
        int pointsDataLimit = 1000;
        int listSize = dataList.size();
        int maxSize = listSize - 1;
        int n = 0;
        ArrayList newList = new ArrayList();
        for (int i = 0; i < dataList.size(); ++i) {
            newList.add(dataList.get(i));
            if (pointsDataLimit != newList.size() && i != maxSize) continue;
            int count = consumer.apply(newList);
            n += count;
            newList.clear();
        }
        return n;
    }

    @Transactional(readOnly=false)
    public CompanyBaseInfoModel saveOrUpdateCompany(CompanyBaseInfoModel companyModel, Long loginStaffId, Long cid) throws Exception {
        if (companyModel == null) {
            throw new Exception("companyModel \u4e0d\u80fd\u4e3a\u7a7a");
        }
        Company company = (Company)this.companyService.getById(companyModel.getCid());
        company.setId(companyModel.getCid());
        company.setName(companyModel.getName());
        company.setShortName(companyModel.getShortName());
        company.setFatherDept(companyModel.getFatherDept());
        company.setSettingTime(companyModel.getSettingTime());
        company.setUnifiedSocialCc(companyModel.getUnifiedSocialCc());
        company.setCompanyContactTel(companyModel.getCompanyContactTel());
        company.setCompanyContactEmail(companyModel.getCompanyContactEmail());
        company.setCompanyContactFax(companyModel.getCompanyContactFax());
        company.setAreaId(companyModel.getAreaId());
        company.setRegisterAddress(companyModel.getRegisterAddress());
        company.setRegisterPost(companyModel.getRegisterPost());
        company.setCompanyPostalAdress(companyModel.getCompanyPostalAdress());
        company.setRegisterAddressRegionId(companyModel.getRegisterAddressRegionId());
        company.setWorkAddress(companyModel.getWorkAddress());
        company.setRegisterType(companyModel.getRegisterType());
        company.setIndustryCategory(companyModel.getIndustryCategory());
        company.setOccupationalRiskClassify(companyModel.getOccupationalRiskClassify());
        company.setStaffCount(companyModel.getStaffCount());
        company.setPickupCount(companyModel.getPickupCount());
        company.setMainOperaIncome(companyModel.getMainOperaIncome());
        company.setRegisterCapital(companyModel.getRegisterCapital());
        company.setOccManagerName(companyModel.getOccManagerName());
        company.setOccManagerTel(companyModel.getOccManagerTel());
        company.setMainLeaderName(companyModel.getMainLeaderName());
        company.setMainLeaderTel(companyModel.getMainLeaderTel());
        company.setScale(companyModel.getScale());
        company.setYearAssets(companyModel.getYearAssets());
        company.setTotalAssets(companyModel.getTotalAssets());
        company.setLegalName(companyModel.getLegalName());
        company.setLegalTel(companyModel.getLegalTel());
        company.setChemicalEmergencyPhone(companyModel.getChemicalEmergencyPhone());
        company.setOccLeaderSid(companyModel.getOccLeaderSid());
        company.setOccLeaderTel(companyModel.getOccLeaderTel());
        company.setSupervisionUnit(companyModel.getSupervisionUnit());
        company.setIsDecCurrentYear(companyModel.getIsDecCurrentYear());
        CompanySearchModel searchModel = new CompanySearchModel();
        if (StringUtils.isNotBlank((String)company.getName())) {
            searchModel.setEqualsName(company.getName());
            searchModel.setCompanyType(company.getCompanyType());
            searchModel.setExcludeId(company.getId());
            List<Company> companyList = this.companyService.getCompanyList(searchModel);
            if (CollectionUtils.isNotEmpty(companyList)) {
                throw new ServiceException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f01\u4e1a\u540d\u79f0");
            }
        }
        if (company.getId() != null) {
            this.companyService.update(company, loginStaffId);
        } else {
            company.setIsValid(Boolean.valueOf(true));
            Company dbc = this.companyService.add(company, loginStaffId);
            companyModel.setCid(dbc.getId());
        }
        return companyModel;
    }

    @Transactional(readOnly=false)
    public CompanyBaseInfoModel saveOrUpdateCompanyUpdateNull(CompanyBaseInfoModel companyModel, Long loginStaffId, Long cid) throws Exception {
        if (companyModel == null) {
            throw new Exception("companyModel \u4e0d\u80fd\u4e3a\u7a7a");
        }
        Company company = (Company)this.companyService.getById(companyModel.getCid());
        if (company == null) {
            company = new Company();
        }
        company.setName(companyModel.getName());
        company.setFatherDept(companyModel.getFatherDept());
        company.setAreaId(companyModel.getAreaId());
        company.setRegisterAddressRegionId(companyModel.getRegisterAddressRegionId());
        company.setRegisterAddress(companyModel.getRegisterAddress());
        company.setWorkAddress(companyModel.getWorkAddress());
        company.setRegisterType(companyModel.getRegisterType());
        company.setIndustryCategory(companyModel.getIndustryCategory());
        company.setOccupationalRiskClassify(companyModel.getOccupationalRiskClassify());
        company.setStaffCount(companyModel.getStaffCount());
        company.setScale(companyModel.getScale());
        company.setLegalName(companyModel.getLegalName());
        company.setLegalTel(companyModel.getLegalTel());
        company.setMainLeaderName(companyModel.getMainLeaderName());
        company.setMainLeaderTel(companyModel.getMainLeaderTel());
        company.setOccManagerName(companyModel.getOccManagerName());
        company.setOccManagerTel(companyModel.getOccManagerTel());
        CompanySearchModel searchModel = new CompanySearchModel();
        if (StringUtils.isNotBlank((String)company.getName())) {
            searchModel.setEqualsName(company.getName());
            searchModel.setCompanyType(company.getCompanyType());
            searchModel.setExcludeId(company.getId());
            List<Company> companyList = this.companyService.getCompanyList(searchModel);
            if (CollectionUtils.isNotEmpty(companyList)) {
                throw new ServiceException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f01\u4e1a\u540d\u79f0");
            }
        }
        if (company.getId() != null) {
            this.companyService.updateByPrimaryKey(company, loginStaffId);
        } else {
            company.setIsValid(Boolean.valueOf(true));
            Company dbc = this.companyService.add(company, loginStaffId);
            companyModel.setCid(dbc.getId());
        }
        return companyModel;
    }

    public List<CompanySuperviseModel> listSuperviseCompanyData() {
        return this.superviseService.listSuperviseCompanyData();
    }

    public Integer countSuperviseCompanyData() {
        return this.superviseService.countSuperviseCompanyData();
    }

    public List<CompanySuperviseModel> listSuperviseCompanyData(int page, int pageSize) {
        return this.superviseService.listSuperviseCompanyData(page, pageSize);
    }

    @Override
    public boolean enable() {
        return true;
    }

    @Override
    @Transactional(readOnly=false)
    public void addData(Map<String, String> company, Long loginStaffId) {
        this.logger.debug("Hse \u5b50\u8868\u6dfb\u52a0\u6570\u636e.....");
    }

    public CompanyBaseInfoModel getByName(String name) {
        Company company = this.companyService.getCompanyByName(name);
        if (company != null) {
            CompanyBaseInfoModel companyBaseInfoModel = this.companyBaseInfoModelUtil.company2model(company);
            return companyBaseInfoModel;
        }
        return new CompanyBaseInfoModel();
    }

    @Transactional(readOnly=false)
    public void updateIndustryCategory(Long indusId, Long cid) {
        this.companyService.updateIndustryCategory(indusId, cid);
    }

    @Transactional(readOnly=false)
    public void updateCompanyBaseInfoModel(CompanyBaseInfoModel company, Long loginStaffId) {
        Company c = new Company();
        BeanUtils.copyProperties((Object)company, (Object)c);
        if (company.getAreaDetailId() != null) {
            c.setAreaId(company.getAreaDetailId());
        }
        CompanySearchModel searchModel = new CompanySearchModel();
        if (StringUtils.isNotBlank((String)c.getName())) {
            List<Company> companyList;
            searchModel.setEqualsName(c.getName());
            if (company.getId() != null) {
                searchModel.setExcludeId(company.getId());
                Company baseInfoModel = (Company)this.companyService.getById(company.getId());
                if (baseInfoModel != null) {
                    searchModel.setCompanyType(baseInfoModel.getCompanyType());
                }
            }
            if (CollectionUtils.isNotEmpty(companyList = this.companyService.getCompanyList(searchModel))) {
                throw new RuntimeException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f01\u4e1a\u540d\u79f0");
            }
        }
        if (StringUtils.isNotBlank((String)company.getUnifiedSocialCc())) {
            searchModel.setEqualsName("");
            searchModel.setUnifiedSocialCc(company.getUnifiedSocialCc());
            List<Company> dbcompanyListByCC = this.companyService.getCompanyList(searchModel);
            if (CollectionUtils.isNotEmpty(dbcompanyListByCC)) {
                Integer maxSeq = dbcompanyListByCC.stream().map(Company::getSeq).max(Integer::compare).orElse(0);
                c.setSeq(Integer.valueOf(maxSeq + 1));
            }
        }
        this.companyService.update(c, loginStaffId);
    }

    public List<CompanySuperviseModel> getNameCodeByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        List<CompanySuperviseModel> nameCodeByCodes = this.superviseService.getNameCodeByCodes(codes);
        return nameCodeByCodes;
    }

    public Long getCidByCode(String code) {
        if (StringUtils.isBlank((String)code)) {
            return null;
        }
        String cacheKey = "unifiedSocialCcCacheKey";
        Map codeMap = (Map)this.commonCache.getIfPresent((Object)cacheKey);
        if (MapUtils.isNotEmpty((Map)codeMap) && codeMap.containsKey(code)) {
            return (Long)codeMap.get(code);
        }
        Long cid = this.companyService.getCidByCode(code);
        codeMap.put(code, cid);
        this.commonCache.put((Object)cacheKey, (Object)codeMap);
        return cid;
    }

    @Transactional
    public Byte regionChangeRemoveClueCard(CompanyBaseInfoModel preCompany, AreaModel postRegion, Long loginUserId) {
        if (Objects.equals(preCompany.getAreaDetailId(), postRegion.getId())) {
            return null;
        }
        AreaModel preRegion = this.sysAreaProvideService.getAreaById(preCompany.getAreaDetailId());
        Long cid = preCompany.getId();
        Long beforeRegionId = preCompany.getAreaDetailId();
        Long afterRegionId = postRegion.getId();
        if (!Objects.equals(preRegion.getProvinceId(), postRegion.getProvinceId())) {
            return (byte)1;
        }
        if (!Objects.equals(preRegion.getCityId(), postRegion.getCityId())) {
            this.updateRegionProposedStatus(cid, beforeRegionId, afterRegionId, loginUserId, StopTypeEnums.CHANGECROSS);
            return (byte)2;
        }
        if (!Objects.equals(preRegion.getAreaId(), postRegion.getAreaId())) {
            this.updateRegionProposedStatus(cid, beforeRegionId, afterRegionId, loginUserId, StopTypeEnums.CHANGEWITHIN);
            return (byte)3;
        }
        if (!Objects.equals(preRegion.getStreetId(), postRegion.getStreetId())) {
            this.updateRegionProposedStatus(cid, beforeRegionId, afterRegionId, loginUserId, StopTypeEnums.CHANGEDISTRICTWITHIN);
            return (byte)4;
        }
        return null;
    }

    @Transactional
    public void updateRegionProposedStatus(Long cid, Long beforeRegionId, Long afterRegionId, Long loginUserId, StopTypeEnums stopType) {
        List<CompanyProposedChangeVo> changeList = this.companyProposedChangeMapper.getChangeEnterpriseList(List.of(cid), stopType.getCode());
        ArrayList<CompanyProposedChangeVo> confirmList = new ArrayList<CompanyProposedChangeVo>();
        ArrayList<CompanyProposedChangeVo> rejectList = new ArrayList<CompanyProposedChangeVo>();
        changeList.stream().filter(c -> Objects.equals(c.getStatus(), StopStatusEnums.PENDING_CONFIRMATION.getCode())).forEach(c -> {
            boolean isSameChange = Objects.equals(beforeRegionId, c.getBeforeAreaId()) && Objects.equals(afterRegionId, c.getStopAreaId());
            (isSameChange ? confirmList : rejectList).add(c);
        });
        this.doStatusChange(confirmList, rejectList, loginUserId);
    }

    @Transactional
    public void updateBusinessStateProposedStatus(Long cid, Integer beforeBusinessState, Integer afterBusinessState, Long loginUserId, StopTypeEnums stopType) {
        List<CompanyProposedChangeVo> changeList = this.companyProposedChangeMapper.getChangeEnterpriseList(List.of(cid), stopType.getCode());
        ArrayList<CompanyProposedChangeVo> confirmList = new ArrayList<CompanyProposedChangeVo>();
        ArrayList<CompanyProposedChangeVo> rejectList = new ArrayList<CompanyProposedChangeVo>();
        changeList.stream().filter(c -> Objects.equals(c.getStatus(), StopStatusEnums.PENDING_CONFIRMATION.getCode())).forEach(c -> {
            boolean isSameChange = Objects.equals(beforeBusinessState, c.getBeforeBusinessState()) && Objects.equals(afterBusinessState, c.getStopBusinessState());
            (isSameChange ? confirmList : rejectList).add(c);
        });
        this.doStatusChange(confirmList, rejectList, loginUserId);
    }

    private void doStatusChange(List<CompanyProposedChangeVo> confirmList, List<CompanyProposedChangeVo> rejectList, Long loginUserId) {
        CompanyProposedChangeStatusForIdParam param;
        List<Long> idList;
        if (CollUtil.isNotEmpty(confirmList)) {
            idList = confirmList.stream().map(CompanyProposedChangeVo::getId).toList();
            param = new CompanyProposedChangeStatusForIdParam();
            param.setIdList(idList);
            param.setStatus(StopStatusEnums.CONFIRMED.getCode());
            param.setConfirmTime(LocalDateTime.now());
            param.setUserId(loginUserId);
            this.companyProposedChangeProviderService.updateStatusForId(param);
        }
        if (CollUtil.isNotEmpty(rejectList)) {
            idList = rejectList.stream().map(CompanyProposedChangeVo::getId).toList();
            param = new CompanyProposedChangeStatusForIdParam();
            param.setIdList(idList);
            param.setStatus(StopStatusEnums.RETURNED.getCode());
            param.setConfirmTime(LocalDateTime.now());
            param.setUserId(loginUserId);
            this.companyProposedChangeProviderService.updateStatusForId(param);
        }
    }
}

