/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.bootstrap;

import cn.smarthse.modules.datacentre.bootstrap.properties.CacheProperties;
import lombok.Generated;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;

@org.springframework.context.annotation.Configuration
@EnableCaching
@EnableConfigurationProperties(value={CacheProperties.class})
public class EhcacheConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EhcacheConfig.class);
    @Autowired
    private CacheProperties cacheProperties;

    @Bean(name={"ADMINCacheManager"})
    public CacheManager cacheManager() {
        log.info("ADMINCacheManager Init");
        CacheConfiguration defaultCacheConfiguration = new CacheConfiguration();
        defaultCacheConfiguration.setMemoryStoreEvictionPolicy("LRU");
        defaultCacheConfiguration.setMaxEntriesLocalHeap(1000L);
        log.info("ADMINCacheManager Init  Add Cache : {}", (Object)this.cacheProperties.getSysparamCache());
        CacheConfiguration sysParamCache = new CacheConfiguration();
        sysParamCache.setName(this.cacheProperties.getSysparamCache());
        sysParamCache.setMemoryStoreEvictionPolicy("LRU");
        sysParamCache.setMaxEntriesLocalHeap(1000L);
        sysParamCache.setTimeToIdleSeconds((long)this.cacheProperties.getSysparamCacheTimeToIdleSeconds().intValue());
        log.info("ADMINCacheManager Init  Add Cache : {}", (Object)this.cacheProperties.getSysareaCache());
        CacheConfiguration sysAreaCache = new CacheConfiguration();
        sysAreaCache.setName(this.cacheProperties.getSysareaCache());
        sysAreaCache.setMemoryStoreEvictionPolicy("LRU");
        sysAreaCache.setMaxEntriesLocalHeap(1000L);
        sysAreaCache.setTimeToIdleSeconds((long)this.cacheProperties.getSysareaCacheTimeToIdleSeconds().intValue());
        Configuration config = new Configuration();
        config.setDefaultCacheConfiguration(defaultCacheConfiguration);
        config.addCache(sysParamCache);
        config.addCache(sysAreaCache);
        return CacheManager.newInstance((Configuration)config);
    }
}

