/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.bootstrap;

import cn.hutool.core.thread.ThreadFactoryBuilder;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.modules.datacentre.bootstrap.properties.EmailProperties;
import cn.smarthse.modules.datacentre.bootstrap.properties.MasSmsProperties;
import cn.smarthse.modules.datacentre.bootstrap.properties.SmtDaHanProperties;
import cn.smarthse.modules.datacentre.bootstrap.properties.SmtProperties;
import cn.smarthse.modules.datacentre.bootstrap.properties.SysconfigProperties;
import cn.smarthse.modules.datacentre.bootstrap.properties.TaskExecutorProperties;
import cn.smarthse.modules.datacentre.bootstrap.properties.WeixinTemplateProperties;
import cn.smarthse.modules.datacentre.bootstrap.properties.ZwddProperties;
import cn.smarthse.modules.datacentre.bootstrap.properties.sms.WelinkProperties;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactoryBean;

@Configuration
@EnableAsync
@ComponentScan(basePackages={"cn.smarthse.modules.datacentre", "cn.smarthse.framework.encrypt", "cn.smarthse.common"})
@EnableConfigurationProperties(value={TaskExecutorProperties.class, EmailProperties.class, WeixinTemplateProperties.class, SmtProperties.class, MasSmsProperties.class, WelinkProperties.class, SysconfigProperties.class, SmtDaHanProperties.class, ZwddProperties.class})
public class ContentConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContentConfiguration.class);

    @Bean
    public IAcsClient DysmsapiClient(SmtProperties smtProperties) {
        log.info("\u914d\u7f6e \u963f\u91cc\u4e91\u77ed\u4fe1");
        return new DefaultAcsClient((IClientProfile)DefaultProfile.getProfile((String)smtProperties.getDysmsapi().getRegionid(), (String)smtProperties.getDysmsapi().getAccesskeyid(), (String)smtProperties.getDysmsapi().getAccesskeysecret()));
    }

    @Bean(value={"emailTemplate"})
    public JavaMailSenderImpl getJavaMailSenderImpl(EmailProperties emailProperties) {
        log.info("\u914d\u7f6e JavaMailSenderImpl {}", (Object)emailProperties);
        JavaMailSenderImpl emailTemplate = new JavaMailSenderImpl();
        emailTemplate.setDefaultEncoding(emailProperties.getDefaultEncoding());
        emailTemplate.setHost(emailProperties.getHost());
        emailTemplate.setPort(emailProperties.getPort());
        emailTemplate.setUsername(emailProperties.getUsername());
        emailTemplate.setPassword(emailProperties.getPassword());
        Properties javaMailProperties = new Properties();
        javaMailProperties.setProperty("mail.smtp.auth", "true");
        javaMailProperties.setProperty("mail.smtp.timeout", "25000");
        javaMailProperties.put("mail.smtp.starttls.enable", (Object)true);
        javaMailProperties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        emailTemplate.setJavaMailProperties(javaMailProperties);
        return emailTemplate;
    }

    @Bean(value={"commonThreadPoolExecutor"})
    public ThreadPoolExecutor commonThreadPoolExecutor() {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(4, 8, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(500), new ThreadFactoryBuilder().setNamePrefix("\u5171\u7528\u4efb\u52a1\u7ebf\u7a0b\u6c60-").setUncaughtExceptionHandler((thread, throwable) -> log.error("\u5171\u7528\u4efb\u52a1\u7ebf\u7a0b\u6c60\uff1a{}\uff0c \u5171\u7528\u4efb\u52a1\u7ebf\u7a0b\u6c60\u53d1\u751f\u5f02\u5e38\uff0c {}", (Object)thread, (Object)throwable)).build(), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!executor.isShutdown()) {
                    try {
                        executor.getQueue().put(r);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
        return executorService;
    }

    @Bean
    public AsyncTaskExecutor taskExecutor(TaskExecutorProperties taskExecutorProperties) {
        log.info("\u914d\u7f6eAsyncTaskExecutor");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("PlatformService-Executor");
        executor.setCorePoolSize(taskExecutorProperties.getCore_pool_size());
        executor.setMaxPoolSize(taskExecutorProperties.getMax_pool_size());
        executor.setQueueCapacity(taskExecutorProperties.getQueue_capacity());
        executor.setKeepAliveSeconds(taskExecutorProperties.getKeep_alive_seconds());
        executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            }
        });
        executor.initialize();
        return executor;
    }

    @Bean(value={"freeMarkerConfiguration"})
    public FreeMarkerConfigurationFactoryBean getFreeMarkerConfiguration() {
        FreeMarkerConfigurationFactoryBean freeMarkerConfiguration = new FreeMarkerConfigurationFactoryBean();
        freeMarkerConfiguration.setPreferFileSystemAccess(false);
        freeMarkerConfiguration.setDefaultEncoding("UTF-8");
        freeMarkerConfiguration.setTemplateLoaderPath("classpath:templates/email");
        Properties freemarkerSettings = new Properties();
        freemarkerSettings.setProperty("localized_lookup", "false");
        freemarkerSettings.setProperty("template_update_delay", "5");
        freemarkerSettings.setProperty("cache_storage", "strong:20, soft:20");
        freemarkerSettings.setProperty("url_escaping_charset", "UTF-8");
        freemarkerSettings.setProperty("output_encoding", "UTF-8");
        return freeMarkerConfiguration;
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }
}

