-- 1.0.5初始版本
-- 创建企业运营后台表
CREATE TABLE `company_platform_admin` (
  `id` bigint(20) unsigned NOT NULL COMMENT 'ID',
  `cid` bigint(20) NOT NULL COMMENT '企业基础Id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` bigint(20) unsigned DEFAULT NULL COMMENT '创建人',
  `update_date` datetime DEFAULT NULL COMMENT '最后修改时间',
  `update_by` bigint(20) unsigned DEFAULT NULL COMMENT '最后修改人ID',
  `is_valid` bit(1) DEFAULT b'1' COMMENT '是否有效（0-无效，1-有效）',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注（限制200个字符或中文）',
  `is_admin_add` bit(1) DEFAULT b'0' COMMENT '标签1：是否是内部人员添加，默认为否（1：是；0：否）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8

-- 在company表上添加触发器
	-- insert company 后会自动insert company_platform_admin 一条数据
DELIMITER $$
CREATE TRIGGER COMPANY_PLATFORM_ADMIN_INSERT_TRIGGER AFTER INSERT ON COMPANY
FOR EACH ROW
BEGIN
	INSERT INTO company_platform_admin(id, cid, create_date, create_by)
	VALUES(UUID_SHORT(), NEW.id, NOW(), NEW.create_by);
END;
$$

-- index
-- comany_govern表
CREATE INDEX govern_cid_index ON company_govern(cid);
-- comany_platform表
CREATE INDEX platform_cid_index ON company_platform(cid);
-- comany_platform_admin表
CREATE INDEX admin_cid_index ON company_platform_admin(cid);
-- comany_supervise表
CREATE INDEX supervise_cid_index ON company_supervise(cid);

-- 更新数据
-- 补齐company_platform_admin数据，该sql只能执行一次，先注释掉，以免多次执行
-- INSERT INTO `company_platform_admin`(id, cid, create_date, create_by)
-- SELECT UUID_SHORT() id, id cid, NOW() create_date, '97136595878047477' create_by FROM company;

-- 行业数据添加level 和 is_leaf
ALTER TABLE sys_param 
ADD COLUMN level tinyint(4) DEFAULT '0' COMMENT '行业等级' AFTER `description`;
ALTER TABLE sys_param 
ADD COLUMN is_leaf bit(1) DEFAULT b'0' COMMENT '是否是叶子节点(行业)' AFTER `level`;
-- is_leaf
UPDATE sys_param c
SET c.`is_leaf` = 1
WHERE c.param_group = 'industrial_classification' AND c.is_valid = 1
AND c.id NOT IN(
SELECT DISTINCT id FROM (
SELECT a.id, a.pid, a.param_code, a.param_value FROM `sys_param` a 
INNER JOIN sys_param b ON b.pid = a.id AND b.is_valid = 1
WHERE a.is_valid = 1
AND a.param_group = 'industrial_classification') AS t);

-- level = 0（国民经济分类类别）
UPDATE `sys_param` SET LEVEL = 0
WHERE id = 2478;
-- levle = 1  (20)
UPDATE `sys_param` SET LEVEL = 1 
WHERE pid = 2478;
-- level = 2  (97)
UPDATE `sys_param` SET LEVEL = 2
WHERE pid IN (SELECT * FROM (SELECT id FROM sys_param WHERE pid = 2478) AS t);
-- level = 3  (480)
UPDATE `sys_param` SET LEVEL = 3
WHERE pid IN (SELECT * FROM (SELECT id FROM sys_param WHERE LEVEL = 2 AND param_group = 'industrial_classification') AS t);
-- level = 4  (1174)
UPDATE `sys_param` SET LEVEL = 4
WHERE pid IN (SELECT * FROM (SELECT id FROM sys_param WHERE LEVEL = 3 AND param_group = 'industrial_classification') AS t);

SELECT * FROM sys_param WHERE param_group = 'industrial_classification' AND is_valid = 1;
SELECT COUNT(*) FROM sys_param WHERE LEVEL =1 AND is_valid = 1

