-- 1.0.4初始版本
drop table if exists company_platform;
CREATE TABLE `company_platform` (
  `id` bigint(20) unsigned NOT NULL COMMENT 'ID',
  `cid` bigint(20) unsigned NOT NULL COMMENT '企业基础Id',
  
  `is_valid` bit(1) DEFAULT b'1' COMMENT '是否有效（0-无效，1-有效）',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` bigint(20) unsigned DEFAULT NULL COMMENT '创建人',
  `update_date` datetime DEFAULT NULL COMMENT '最后修改时间',
  `update_by` bigint(20) unsigned DEFAULT NULL COMMENT '最后修改人ID',

  `reg_type` tinyint(4) DEFAULT '1' COMMENT '平台字段）注册类型(1-企业注册,2-医疗机构注册,3-其他组织机构',
  `corp_email_check` tinyint(4) DEFAULT '0' COMMENT '平台字段）企业邮箱绑定状态(0-未绑定,1-已发送绑定信息,2-已绑定,3-超时)',
  `check_state` tinyint(4) DEFAULT '0' COMMENT '平台字段）审核结果(0-草稿,1-待审核,2-审核通过,3-审核不通过)',
  `check_date` datetime DEFAULT NULL COMMENT '平台字段）审核时间',
  `corp_apply_name` varchar(45) DEFAULT NULL COMMENT '平台字段）申请人',
  `corp_apply_mobile` varchar(100) DEFAULT NULL COMMENT '平台字段）申请人手机号',
  `corp_file_url` varchar(255) DEFAULT NULL COMMENT '平台字段）证照照片',
  `logo_file_id` bigint(20) DEFAULT NULL COMMENT '平台字段）头像id',
  `corp_file_id` bigint(20) DEFAULT NULL COMMENT '平台字段）证照照片Id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业平台信息';

只执行一次
INSERT into company_platform(id, cid, is_valid, create_date, create_by, update_date, update_by, reg_type, corp_email_check, check_state, check_date, corp_apply_name, corp_apply_mobile, corp_file_url, logo_file_id, corp_file_id)
SELECT uuid_short() as id, id as cid, is_valid, create_date, create_by, update_date, update_by, reg_type, corp_email_check, check_state, check_date, corp_apply_name, corp_apply_mobile, corp_file_url, logo_file_id, corp_file_id 
	FROM db_bigdata_center.company
	where is_valid=1

-- 移除平台字段 
ALTER TABLE `bigdata_test`.`company` 
DROP COLUMN `corp_file_id`,
DROP COLUMN `logo_file_id`,
DROP COLUMN `corp_file_url`,
DROP COLUMN `corp_apply_mobile`,
DROP COLUMN `corp_apply_name`,
DROP COLUMN `check_date`,
DROP COLUMN `check_state`,
DROP COLUMN `corp_email_check`,
DROP COLUMN `reg_type`;




