-- 1.0.00初始版本
drop table if exists company_govern;

/*==============================================================*/
/* Table: company_govern                                        */
/*==============================================================*/
create table company_govern
(
   id                   bigint(20) unsigned not null comment 'ID',
   is_valid             bit default 1 comment '是否有效',
   create_by            bigint(20) unsigned default NULL comment '创建人',
   create_date          datetime default CURRENT_TIMESTAMP comment '创建时间',
   update_by            bigint(20) unsigned default NULL comment '最后修改人ID',
   update_date          datetime default CURRENT_TIMESTAMP comment '最后修改时间',
   cid                  bigint(20) unsigned comment '企业id',
   govern_year          int comment '治理年份',
   dust_harms_count     int comment '接触尘毒危害人数',
   is_odi_declare_report bit comment '是否进行职业病危害项目申报',
   is_odi_declare_check bit comment '是否进行职业病危害定期检测',
   dust_fc_harms_count  int comment '接触尘毒危害劳动者职业健康检查人数',
   is_hr_manager        bit comment '是否接受职业健康培训： 是否主要负责人',
   is_hr_staff          bit comment '是否接受职业健康培训：是否职业健康管理人员',
   is_hr_worker         bit comment '是否接受职业健康培训：劳动者',
   report_name          varchar(100) comment '填报人姓名：',
   report_mobile        varchar(100) comment '填报人手机号码：',
   name                 varchar(100) comment '用人单位名称(冗余)',
   province_id          bigint(20) comment '省Id(冗余)',
   city_id              bigint(20) comment '市Id(冗余)',
   area_id              bigint(20) comment '区/县Id(冗余)',
   street_id            bigint(20) comment '街道Id(冗余)',
   work_address         varchar(100) comment '工作场所地址(冗余)',
   scale                varchar(100) comment '企业规模(冗余)',
   register_type        bigint(20) comment '注册类型Id(冗余)',
   register_type_code   varchar(100) comment '注册类型Code(冗余)',
   industry_category    bigint(20) comment '所属行业Id(冗余)',
   industry_category_parent_code varchar(100) comment '所属行业parent_code(冗余)',
   industry_category_code varchar(100) comment '所属行业Code(隐藏,若是B类,则B类code后面增加_01:地上/_02地下',
   is_industry_category_b bit comment '所属行业Code地上/地下(冗余)',
   staff_count          int comment '从业人员总数(冗余)',
   primary key (id)
)
ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用人单位基本情况治理登记表';


ALTER TABLE `db_bigdata_center`.`company` 
ADD COLUMN `corp_file_url` VARCHAR(255) NULL COMMENT '平台字段）证照照片',
ADD COLUMN `logo_file_id` BIGINT(20) NULL COMMENT '平台字段）头像id',
ADD COLUMN `corp_file_id` BIGINT(20) NULL COMMENT '平台字段）证照照片Id';



-- zlj 2019-7-30
ALTER TABLE `db_bigdata_center`.`company`
ADD COLUMN `is_best` bit(1) NULL DEFAULT b'0' COMMENT '是否是 示范企业（1是）' AFTER `supervise_is_del`;

ALTER TABLE `db_bigdata_center`.`company`
ADD COLUMN `best_update_time` datetime(0) NULL COMMENT '示范企业更新时间' AFTER `is_best`;