
-- zlj 2019-8-21 拆分监管系统字段
drop table if exists company_supervise;
CREATE TABLE `company_supervise` (
  `id` bigint(20) unsigned NOT NULL COMMENT 'ID',
  `cid` bigint(20) unsigned DEFAULT NULL COMMENT '企业id',
  `is_best` bit(1) DEFAULT b'0' COMMENT '是否是 示范企业（1是）',
  `best_update_time` datetime DEFAULT NULL COMMENT '示范企业更新时间',
  `operation_status` varchar(32) DEFAULT NULL COMMENT '经营状态：存续，吊销',
  `report_company_name` varchar(128) DEFAULT NULL COMMENT '申报系统名称',
  `report_date` datetime DEFAULT NULL COMMENT '申报日期',
  `report_type` varchar(128) DEFAULT NULL COMMENT '申报类型',
  `supervise_is_hide` bit(1) DEFAULT b'0' COMMENT '用于演示环境可隐藏哪些部分的测试数据',
  `supervise_is_del` bit(1) DEFAULT b'0' COMMENT '监管系统删除标志',

	`create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` bigint(20) unsigned DEFAULT NULL COMMENT '创建人',
  `update_date` datetime DEFAULT NULL COMMENT '最后修改时间',
  `update_by` bigint(20) unsigned DEFAULT NULL COMMENT '最后修改人ID',
	`is_valid` bit(1) DEFAULT b'1' COMMENT '是否有效（0-无效，1-有效）',
	  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业信息-监管系统子表';
-- zhoulj 复制数据到子表
insert into  company_supervise(id,cid,is_best, best_update_time, operation_status, report_company_name,report_date , report_type, supervise_is_hide,
create_date,create_by,update_date,update_by,is_valid)
select UUID_SHORT(),id,is_best, best_update_time, operation_status, report_company_name,report_date , report_type, supervise_is_hide, now(),0,now(),0,1
from company ;
-- 删除 company 基础表中 监管的属性
ALTER TABLE  `company`
DROP COLUMN `is_best`,
DROP COLUMN `best_update_time`,
DROP COLUMN `operation_status`,
DROP COLUMN `report_company_name`,
DROP COLUMN `report_date`,
DROP COLUMN `supervise_is_hide`,
DROP COLUMN `supervise_is_del`,
DROP COLUMN `report_type`;
-- company 主表 添加数据来源
ALTER TABLE `db_bigdata_center`.`company`
ADD COLUMN `data_source` tinyint(4) NULL COMMENT '数据来源,CompanyDataSourceEnum约定' AFTER `is_valid`;