/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.util;

import cn.smarthse.modules.datacentre.entity.system.SysArea;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.model.platform.CompanyPlatformModel;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.datacentre.service.system.ISysParamService;
import cn.smarthse.modules.platform.core.framework.utils.NumberUtil;
import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompanyPlatformModelUtil {
    @Autowired
    private ISysAreaService areaService;
    @Autowired
    private ISysParamService paramService;

    public CompanyPlatformModel company2model(CompanyPlatformModel companyInfo) {
        if (companyInfo == null) {
            return null;
        }
        SysArea area = this.areaService.getAreaById(companyInfo.getAreaId());
        if (area != null) {
            companyInfo.setAreaId(area.getAreaId());
            companyInfo.setAreaName(area.getAreaName());
            companyInfo.setCityId(area.getCityId());
            companyInfo.setCityName(area.getCityName());
            companyInfo.setStreetId(area.getStreetId());
            companyInfo.setStreetName(area.getStreetName());
            companyInfo.setProvinceId(area.getProvinceId());
            companyInfo.setProvinceName(area.getProvinceName());
            companyInfo.setAreaLevel(area.getLevel());
            companyInfo.setAreaDetailName(area.getAreaDetailName());
        }
        companyInfo.setAreaDetailId(companyInfo.getAreaId());
        if (companyInfo.getIndustryCategory() != null && companyInfo.getIndustryCategory() > 0L) {
            String industryCategory = this.paramService.getParamValue(companyInfo.getIndustryCategory());
            companyInfo.setIndustryCategoryName(industryCategory);
        }
        if (companyInfo.getRegisterType() != null && companyInfo.getRegisterType() > 0L) {
            String registerType = this.paramService.getParamValue(companyInfo.getRegisterType());
            companyInfo.setRegisterTypeName(registerType);
        }
        if (StringUtils.isNotEmpty((String)companyInfo.getScale()) && NumberUtil.isNumber((String)companyInfo.getScale())) {
            Integer scale = NumberUtil.toInt((String)companyInfo.getScale());
            String scaleName = CompanySizeEnum.getName((Integer)scale);
            companyInfo.setScaleName(scaleName);
        }
        return companyInfo;
    }
}

