/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.util;

import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.entity.system.SysArea;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.datacentre.service.system.ISysParamService;
import cn.smarthse.modules.platform.core.framework.utils.NumberUtil;
import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompanyBaseInfoModelUtil {
    @Autowired
    private ISysAreaService areaService;
    @Autowired
    private ISysParamService paramService;

    public CompanyBaseInfoModel company2model(Company company) {
        if (company == null) {
            return null;
        }
        CompanyBaseInfoModel companyInfo = new CompanyBaseInfoModel();
        companyInfo.setId(company.getId());
        companyInfo.setCid(company.getId());
        companyInfo.setName(company.getName());
        companyInfo.setShortName(company.getShortName());
        companyInfo.setCreateDate(company.getCreateDate());
        SysArea area = this.areaService.getAreaById(company.getAreaId());
        if (area != null) {
            companyInfo.setAreaId(area.getAreaId());
            companyInfo.setAreaName(area.getAreaName());
            companyInfo.setCityId(area.getCityId());
            companyInfo.setCityName(area.getCityName());
            companyInfo.setStreetId(area.getStreetId());
            companyInfo.setStreetName(area.getStreetName());
            companyInfo.setProvinceId(area.getProvinceId());
            companyInfo.setProvinceName(area.getProvinceName());
            companyInfo.setAreaLevel(area.getLevel());
            companyInfo.setAreaDetailName(area.getAreaDetailName());
        }
        companyInfo.setAreaDetailId(company.getAreaId());
        companyInfo.setIndustryCategory(company.getIndustryCategory());
        if (company.getIndustryCategory() != null && company.getIndustryCategory() > 0L) {
            String industryCategory = this.paramService.getParamValue(company.getIndustryCategory());
            companyInfo.setIndustryCategoryName(industryCategory);
        }
        companyInfo.setRegisterType(company.getRegisterType());
        if (company.getRegisterType() != null && company.getRegisterType() > 0L) {
            String registerType = this.paramService.getParamValue(company.getRegisterType());
            companyInfo.setRegisterTypeName(registerType);
        }
        companyInfo.setChemicalEmergencyPhone(company.getChemicalEmergencyPhone());
        companyInfo.setCompanyContactEmail(company.getCompanyContactEmail());
        companyInfo.setCompanyContactFax(company.getCompanyContactFax());
        companyInfo.setCompanyContactTel(company.getCompanyContactTel());
        companyInfo.setCompanyPostalAdress(company.getCompanyPostalAdress());
        companyInfo.setFatherDept(company.getFatherDept());
        companyInfo.setLegalName(company.getLegalName());
        companyInfo.setLegalTel(company.getLegalTel());
        companyInfo.setLogoFileUrl(company.getLogoFileUrl());
        companyInfo.setMainOperaIncome(company.getMainOperaIncome());
        companyInfo.setOccLeaderSid(company.getOccLeaderSid());
        companyInfo.setOccLeaderTel(company.getOccLeaderTel());
        companyInfo.setOccupationalRiskClassify(company.getOccupationalRiskClassify());
        companyInfo.setPickupCount(company.getPickupCount());
        companyInfo.setRegisterAddress(company.getRegisterAddress());
        companyInfo.setRegisterCapital(company.getRegisterCapital());
        companyInfo.setRegisterPost(company.getRegisterPost());
        companyInfo.setScale(company.getScale());
        if (StringUtils.isNotEmpty((String)company.getScale()) && NumberUtil.isNumber((String)company.getScale())) {
            Integer scale = NumberUtil.toInt((String)company.getScale());
            String scaleName = CompanySizeEnum.getName((Integer)scale);
            companyInfo.setScaleName(scaleName);
        }
        companyInfo.setSettingTime(company.getSettingTime());
        companyInfo.setStaffCount(company.getStaffCount());
        companyInfo.setTotalAssets(company.getTotalAssets());
        companyInfo.setUnifiedSocialCc(company.getUnifiedSocialCc());
        companyInfo.setWorkAddress(company.getWorkAddress());
        companyInfo.setYearAssets(company.getYearAssets());
        return companyInfo;
    }
}

