/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.system.impl;

import cn.smarthse.modules.datacentre.bootstrap.properties.CacheProperties;
import cn.smarthse.modules.datacentre.dao.system.SysParamMapper;
import cn.smarthse.modules.datacentre.entity.system.SysParam;
import cn.smarthse.modules.datacentre.enums.SysParamGroupEnum;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.system.ISysParamService;
import cn.smarthse.modules.platform.core.framework.cache.ehcache.EhCacheUtils;
import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class SysParamServiceImpl
extends ZYJBaseServiceImpl<SysParamMapper, SysParam>
implements ISysParamService {
    @Autowired
    private CacheProperties cacheProperties;

    @Override
    public String getParamValue(Long Id2) {
        SysParam param = this.getParamById(Id2);
        if (param != null) {
            return param.getParamValue();
        }
        return null;
    }

    @Override
    public String getCodeById(Long Id2) {
        SysParam param = this.getParamById(Id2);
        if (param != null) {
            return param.getParamCode();
        }
        return null;
    }

    @Override
    public SysParam getParamById(Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        String cacheName = String.valueOf(id);
        EhCacheUtils ehcacheUtil = new EhCacheUtils(this.cacheManager, this.cacheProperties.getSysparamCache());
        Object cacheObj = null;
        try {
            cacheObj = ehcacheUtil.getValue(cacheName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cacheObj != null) {
            return (SysParam)cacheObj;
        }
        SysParam param = (SysParam)this.getById(id);
        if (param != null) {
            ehcacheUtil.put((Object)cacheName, (Object)param);
        }
        return param;
    }

    @Override
    public void clearParamCacheById(Long id) {
        String cacheName = String.valueOf(id);
        EhCacheUtils ehcacheUtil = new EhCacheUtils(this.cacheManager, this.cacheProperties.getSysparamCache());
        ehcacheUtil.remove(cacheName);
    }

    @Override
    public List<SysParam> getSysParamList(String paramGroup) {
        Example example = new Example(SysParam.class);
        example.createCriteria().andEqualTo("paramGroup", (Object)paramGroup).andEqualTo("isValid", (Object)true);
        return ((SysParamMapper)this.dao).selectByExample(example);
    }

    @Override
    public List<SysParam> getListByPid(Long parentId) {
        Example example = new Example(SysParam.class);
        example.createCriteria().andEqualTo("pid", (Object)parentId).andEqualTo("isValid", (Object)true);
        return ((SysParamMapper)this.dao).selectByExample(example);
    }

    @Override
    public List<SysParam> getSysParamListByChildren(String paramGroup) {
        Example example = new Example(SysParam.class);
        example.createCriteria().andEqualTo("paramGroup", (Object)paramGroup).andNotEqualTo("pid", (Object)0).andEqualTo("isValid", (Object)true);
        return ((SysParamMapper)this.dao).selectByExample(example);
    }

    @Override
    public SysParam getSysParamByNameGroupCode(String paramValue, Long cid, SysParamGroupEnum group, String paramCode) {
        Example example = new Example(SysParam.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)true);
        if (StringUtils.isNotEmpty((String)paramValue)) {
            c.andEqualTo("paramValue", (Object)paramValue);
        }
        if (cid != null && cid > 0L) {
            StringBuffer condition = new StringBuffer();
            condition.append("(cid=0 or cid=").append(cid).append(")");
            c.andCondition(condition.toString());
        }
        if (group != null) {
            c.andEqualTo("paramGroup", (Object)group.getValue());
        }
        if (StringUtils.isNotEmpty((String)paramCode)) {
            c.andEqualTo("paramCode", (Object)paramCode);
        }
        return (SysParam)this.getOneByExample(example);
    }

    @Override
    public Integer getChildCount(Long id) {
        Example example = new Example(SysParam.class);
        example.createCriteria().andEqualTo("pid", (Object)id).andEqualTo("isValid", (Object)true);
        return this.getCountByExample(example);
    }
}

