/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.system.impl;

import cn.smarthse.modules.datacentre.bootstrap.properties.CacheProperties;
import cn.smarthse.modules.datacentre.dao.system.SysAreaMapper;
import cn.smarthse.modules.datacentre.entity.system.SysArea;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.platform.core.framework.Global;
import cn.smarthse.modules.platform.core.framework.cache.ehcache.EhCacheUtils;
import cn.smarthse.modules.platform.core.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class SysAreaServiceImpl
extends ZYJBaseServiceImpl<SysAreaMapper, SysArea>
implements ISysAreaService {
    @Autowired
    private CacheProperties cacheProperties;

    @Override
    public PageInfo<SysArea> getAllProvince(JqGridParam param) {
        if (param != null) {
            PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        }
        Example example = new Example(SysArea.class);
        example.createCriteria().andEqualTo("parentId", (Object)"0").andEqualTo("isValid", (Object)Global.TRUE);
        example.orderBy(" orderBy desc");
        PageInfo page = new PageInfo(((SysAreaMapper)this.dao).selectByExample(example));
        return page;
    }

    @Override
    public List<SysArea> getCityList(Long provinceId) {
        Example example = new Example(SysArea.class);
        example.createCriteria().andEqualTo("parentId", (Object)provinceId).andEqualTo("isValid", (Object)Global.TRUE);
        example.orderBy(" orderBy desc");
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }

    @Override
    public List<SysArea> getAreaList(Long cityId) {
        Example example = new Example(SysArea.class);
        example.createCriteria().andEqualTo("parentId", (Object)cityId).andEqualTo("isValid", (Object)Global.TRUE);
        example.orderBy(" orderBy desc");
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }

    @Override
    public List<SysArea> getStreetList(Long areaId) {
        Example example = new Example(SysArea.class);
        example.createCriteria().andEqualTo("parentId", (Object)areaId).andEqualTo("isValid", (Object)Global.TRUE);
        example.orderBy(" orderBy desc");
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }

    @Override
    public PageInfo<SysArea> getChildList(JqGridParam param, Long pid) {
        if (param != null) {
            PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        }
        List<SysArea> list = this.getChildByPid(pid);
        PageInfo page = new PageInfo(list);
        return page;
    }

    @Override
    public List<SysArea> getAllProvinceList() {
        Example example = new Example(SysArea.class);
        example.createCriteria().andEqualTo("parentId", (Object)"0").andEqualTo("isValid", (Object)Global.TRUE);
        example.orderBy(" orderBy desc");
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }

    @Override
    public List<SysArea> getChildByPid(Long pid) {
        Example example = new Example(SysArea.class);
        example.createCriteria().andEqualTo("parentId", (Object)pid).andEqualTo("isValid", (Object)Global.TRUE);
        example.orderBy(" orderBy desc");
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }

    @Override
    @Transactional
    public void deleteByIds(List<Long> ids) {
        Example example = new Example(SysArea.class);
        Example.Criteria cri = example.createCriteria();
        cri.andEqualTo("isValid", (Object)Global.TRUE).andIn("id", ids);
        SysArea record = new SysArea();
        record.setIsValid(Global.FALSE);
        ((SysAreaMapper)this.dao).updateByExampleSelective(record, example);
    }

    @Override
    public SysArea getAreaById(Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        String cacheName = String.valueOf(id);
        EhCacheUtils ehcacheUtil = new EhCacheUtils(this.cacheManager, this.cacheProperties.getSysareaCache());
        Object cacheObj = null;
        try {
            cacheObj = ehcacheUtil.getValue(cacheName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cacheObj != null) {
            return (SysArea)cacheObj;
        }
        SysArea area = (SysArea)this.getById(id);
        if (area != null) {
            ehcacheUtil.put((Object)cacheName, (Object)area);
        }
        return area;
    }

    @Override
    public void clearAreaCacheById(Long id) {
        String cacheName = String.valueOf(id);
        EhCacheUtils ehcacheUtil = new EhCacheUtils(this.cacheManager, this.cacheProperties.getSysareaCache());
        ehcacheUtil.remove(cacheName);
    }

    @Override
    public int getCountChildByPid(Long pid) {
        Example example = new Example(SysArea.class);
        example.createCriteria().andEqualTo("parentId", (Object)pid).andEqualTo("isValid", (Object)Global.TRUE);
        return ((SysAreaMapper)this.dao).selectCountByExample(example);
    }

    @Override
    @Transactional(readOnly=false)
    public SysArea add(SysArea sysArea, Long adminId) {
        if (sysArea.getParentId() != 0L) {
            SysArea psysArea = (SysArea)this.getById(sysArea.getParentId());
            sysArea.setProvinceId(psysArea.getProvinceId());
            sysArea.setProvinceName(psysArea.getProvinceName());
            sysArea.setCityId(psysArea.getCityId());
            sysArea.setCityName(psysArea.getCityName());
            sysArea.setAreaId(psysArea.getAreaId());
            sysArea.setAreaName(psysArea.getAreaName());
            sysArea.setStreetId(psysArea.getStreetId());
            sysArea.setStreetName(psysArea.getStreetName());
        }
        sysArea.setCreateBy(adminId);
        sysArea.setCreateDate(new Date());
        sysArea.setUpdateBy(adminId);
        sysArea.setUpdateDate(new Date());
        sysArea.setIsValid(true);
        sysArea = this.add(sysArea);
        if (sysArea.getLevel() == 1) {
            sysArea.setProvinceId(sysArea.getId());
            sysArea.setProvinceName(sysArea.getName());
        } else if (sysArea.getLevel() == 2) {
            sysArea.setCityId(sysArea.getId());
            sysArea.setCityName(sysArea.getName());
        } else if (sysArea.getLevel() == 3) {
            sysArea.setAreaId(sysArea.getId());
            sysArea.setAreaName(sysArea.getName());
        } else if (sysArea.getLevel() == 4) {
            sysArea.setStreetId(sysArea.getId());
            sysArea.setStreetName(sysArea.getName());
        }
        this.update(sysArea);
        return sysArea;
    }

    @Override
    @Transactional(readOnly=false)
    public void del(SysArea sysArea, Long adminId) {
        this.delete(sysArea, adminId);
        Example example = new Example(SysArea.class);
        Example.Criteria c = example.createCriteria();
        if (sysArea.getLevel() == 1) {
            c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("provinceId", (Object)sysArea.getId());
            SysArea area = new SysArea();
            area.setIsValid(Global.FALSE);
            ((SysAreaMapper)this.dao).updateByExampleSelective(area, example);
        } else if (sysArea.getLevel() == 2) {
            c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("cityId", (Object)sysArea.getId());
            SysArea area = new SysArea();
            area.setIsValid(Global.FALSE);
            ((SysAreaMapper)this.dao).updateByExampleSelective(area, example);
        } else if (sysArea.getLevel() == 3) {
            c.andEqualTo("isValid", (Object)Global.TRUE).andEqualTo("areaId", (Object)sysArea.getId());
            SysArea area = new SysArea();
            area.setIsValid(Global.FALSE);
            ((SysAreaMapper)this.dao).updateByExampleSelective(area, example);
        }
    }

    @Override
    public String getAreaDetailNameById(Long id) {
        SysArea area = this.getAreaById(id);
        if (area != null) {
            return area.getAreaDetailName();
        }
        return null;
    }

    @Override
    public String getNameById(Long Id2) {
        SysArea area = this.getAreaById(Id2);
        if (area != null) {
            return area.getName();
        }
        return null;
    }

    @Override
    public Integer getChildCount(Long id) {
        Example example = new Example(SysArea.class);
        example.createCriteria().andEqualTo("parentId", (Object)id).andEqualTo("isValid", (Object)Global.TRUE);
        return this.getCountByExample(example);
    }

    @Override
    public List<SysArea> getChildByPrefix(String prefix) {
        Example example = new Example(SysArea.class);
        example.createCriteria().andLike("id", String.valueOf(prefix) + "%").andEqualTo("isValid", (Object)Global.TRUE);
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }

    @Override
    public List<SysArea> getChildByParentId(Long parentId, String name) {
        if (parentId == null) {
            parentId = 0L;
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            parentId = null;
        }
        SysArea area = new SysArea();
        area.setIsValid(true);
        area.setParentId(parentId);
        area.setName(name);
        return ((SysAreaMapper)this.dao).listArea(area);
    }

    @Override
    public List<SysArea> selectByExample(Example example) {
        return ((SysAreaMapper)this.dao).selectByExample(example);
    }
}

