/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.impl;

import cn.smarthse.modules.datacentre.dao.CompanySuperviseMapper;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.entity.supervise.CompanySupervise;
import cn.smarthse.modules.datacentre.entity.system.SysArea;
import cn.smarthse.modules.datacentre.entity.system.SysParam;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.service.ICompanyService;
import cn.smarthse.modules.datacentre.service.ICompanySuperviseService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.childtable.IAddData2ChildTableService;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.datacentre.service.system.ISysParamService;
import cn.smarthse.modules.platform.core.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class CompanySuperviseServiceImpl
extends ZYJBaseServiceImpl<CompanySuperviseMapper, CompanySupervise>
implements ICompanySuperviseService,
IAddData2ChildTableService {
    @Autowired
    private CompanySuperviseMapper companySuperviseMapper;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private ISysParamService sysParamService;
    @Autowired
    private ISysAreaService sysAreaService;

    @Override
    public PageInfo<CompanySuperviseModel> pageCompanyInfo(JqGridParam param, CompanySuperviseSearchModel companySearchVo, boolean getBaseInfo) {
        SysParam sysParamIndustryCategory;
        if (companySearchVo.getIndustryCategory() != null && (sysParamIndustryCategory = (SysParam)this.sysParamService.getById(companySearchVo.getIndustryCategory())) != null) {
            companySearchVo.setIndustryCategoryCode(sysParamIndustryCategory.getParamCode());
            companySearchVo.setIndustryCategory(null);
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<CompanySuperviseModel> companyList = this.listCompanyInfo(companySearchVo, true);
        PageInfo page = new PageInfo(companyList);
        return page;
    }

    @Override
    public List<CompanySuperviseModel> listCompanyInfo(CompanySuperviseSearchModel companySearchVo, boolean getBaseInfo) {
        SysParam sysParamIndustryCategory;
        if (companySearchVo == null) {
            companySearchVo = new CompanySuperviseSearchModel();
        }
        if (companySearchVo.getAreaId() == null) {
            companySearchVo.setAreaId(companySearchVo.getOrgAreaId());
        }
        if (companySearchVo.getIndustryCategory() != null && (sysParamIndustryCategory = (SysParam)this.sysParamService.getById(companySearchVo.getIndustryCategory())) != null) {
            companySearchVo.setIndustryCategoryCode(sysParamIndustryCategory.getParamCode());
            companySearchVo.setIndustryCategory(null);
        }
        List<CompanySuperviseModel> companyList = this.companySuperviseMapper.listCompanyInfo(companySearchVo);
        if (getBaseInfo && companyList != null && !companyList.isEmpty()) {
            List<SysParam> registerType = this.sysParamService.getSysParamListByChildren("registration_type");
            List<SysParam> industryCategoryList = this.sysParamService.getSysParamListByChildren("industrial_classification");
            HashMap<Long, String> areaMap = new HashMap<Long, String>();
            for (CompanySuperviseModel c : companyList) {
                Long areaId = c.getAreaId();
                if (areaId != null) {
                    if (areaMap.containsKey(areaId)) {
                        c.setAreaName((String)areaMap.get(areaId));
                    } else {
                        SysArea sysArea = this.sysAreaService.getAreaById(areaId);
                        String areaFullName = sysArea.getAreaDetailName(">");
                        c.setAreaName(areaFullName);
                        areaMap.put(areaId, areaFullName);
                    }
                }
                if (c.getIndustryCategory() != null) {
                    for (SysParam s : industryCategoryList) {
                        if (!s.getId().equals((long)c.getIndustryCategory())) continue;
                        c.setIndustryCategoryName(s.getParamValue());
                    }
                }
                if (c.getRegisterType() != null) {
                    for (SysParam s : registerType) {
                        if (!s.getId().equals((long)c.getRegisterType())) continue;
                        c.setRegisterTypeName(s.getParamValue());
                    }
                }
                if (c.getScale() == null || !StringUtils.isNumeric((CharSequence)c.getScale()) || Long.parseLong(c.getScale()) >= 5L) continue;
                String scaleName = CompanySizeEnum.getName((Integer)Integer.parseInt(c.getScale()));
                c.setScaleName(scaleName);
            }
        }
        return companyList;
    }

    @Override
    @Transactional(readOnly=false)
    public int updateSuperViseByCid(CompanySupervise result, Long cid) {
        if (cid != null) {
            Example e = new Example(CompanySupervise.class);
            e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
            return this.companySuperviseMapper.updateByExampleSelective(result, e);
        }
        return 0;
    }

    @Override
    public CompanySupervise getCompanySuperviseByCid(Long cid) {
        Example e = new Example(CompanySupervise.class);
        e.createCriteria().andEqualTo("cid", (Object)cid).andEqualTo("isValid", (Object)true);
        List companySuperviseList = this.companySuperviseMapper.selectByExampleAndRowBounds(e, new RowBounds(1, 1));
        if (CollectionUtils.isNotEmpty((Collection)companySuperviseList)) {
            return (CompanySupervise)companySuperviseList.get(0);
        }
        return null;
    }

    @Override
    @Transactional(readOnly=false)
    public int delCompanySuperviseByIds(String ids) {
        String[] strings;
        List idList;
        if (org.springframework.util.StringUtils.hasText((String)ids) && CollectionUtils.isNotEmpty(idList = Arrays.stream(strings = StringUtils.splitByWholeSeparator((String)ids, (String)",")).filter(s -> StringUtils.isNumeric((CharSequence)s)).map(s -> {
            s = s.trim();
            return Long.parseLong(s);
        }).collect(Collectors.toList()))) {
            Example e = new Example(CompanySupervise.class);
            e.createCriteria().andIn("cid", idList);
            CompanySupervise result = new CompanySupervise();
            result.setSuperviseIsDel(true);
            result.setUpdateDate(new Date());
            return this.companySuperviseMapper.updateByExampleSelective(result, e);
        }
        return 0;
    }

    @Override
    @Transactional(readOnly=false)
    public int bestCompanyByIds(String ids, Long loginUser) {
        String[] strings;
        List idList;
        if (org.springframework.util.StringUtils.hasText((String)ids) && CollectionUtils.isNotEmpty(idList = Arrays.stream(strings = StringUtils.splitByWholeSeparator((String)ids, (String)",")).filter(s -> StringUtils.isNumeric((CharSequence)s)).map(s -> {
            s = s.trim();
            return Long.parseLong(s);
        }).collect(Collectors.toList()))) {
            Example e = new Example(CompanySupervise.class);
            e.createCriteria().andIn("cid", idList).andEqualTo("isValid", (Object)true);
            CompanySupervise result = new CompanySupervise();
            result.setIsBest(true);
            result.setUpdateDate(new Date());
            result.setBestUpdateTime(new Date());
            result.setUpdateBy(loginUser);
            return this.companySuperviseMapper.updateByExampleSelective(result, e);
        }
        return 0;
    }

    @Override
    public List<CompanySuperviseModel> listSuperviseCompanyData() {
        return this.companySuperviseMapper.listSuperviseCompanyData();
    }

    @Override
    public Integer countSuperviseCompanyData() {
        return this.companySuperviseMapper.countSuperviseCompanyData();
    }

    @Override
    public List<CompanySuperviseModel> listSuperviseCompanyData(int page, int pageSize) {
        int pageStart = (page - 1) * pageSize;
        return this.companySuperviseMapper.listSuperviseCompanyDataPage(pageStart, pageSize);
    }

    @Override
    public boolean enable() {
        return true;
    }

    @Override
    public void addData(Company company, Long loginStaffId) {
        Example e = new Example(CompanySupervise.class);
        e.createCriteria().andEqualTo("cid", (Object)company.getId()).andEqualTo("isValid", (Object)true);
        int count = this.companySuperviseMapper.selectCountByExample(e);
        if (count <= 0) {
            CompanySupervise supervise = new CompanySupervise();
            supervise.setCid(company.getId());
            this.add(supervise, loginStaffId);
        }
    }
}

