/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.impl;

import cn.smarthse.modules.datacentre.dao.CompanyMapper;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.CompanyListModel;
import cn.smarthse.modules.datacentre.model.CompanySearchModel;
import cn.smarthse.modules.datacentre.service.ICompanyService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.platform.core.framework.Global;
import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class CompanyServiceImpl
extends ZYJBaseServiceImpl<CompanyMapper, Company>
implements ICompanyService {
    @Autowired
    CompanyMapper companyMapper;

    @Override
    public Company getCompanyByName(String name) {
        return this.getByCases(null, null, name, null);
    }

    @Override
    public Company getByCases(String unifiedSocialCc, Long cid, String fullname, String email) {
        Example example = new Example(Company.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE);
        if (StringUtils.isNotEmpty((String)fullname)) {
            c.andEqualTo("name", (Object)fullname);
        }
        if (StringUtils.isNotEmpty((String)unifiedSocialCc)) {
            c.andEqualTo("unifiedSocialCc", (Object)unifiedSocialCc);
        }
        if (StringUtils.isNotEmpty((String)email)) {
            c.andEqualTo("companyContactEmail", (Object)email);
        }
        if (cid != null && cid > 0L) {
            c.andNotEqualTo("id", (Object)cid);
        }
        example.setOrderByClause("update_date desc");
        return (Company)this.getOneByExample(example);
    }

    @Override
    public String getCorpCcExtend(String unifiedSocialCc) {
        StringBuffer ccExtend = new StringBuffer();
        if (StringUtils.isNotEmpty((String)unifiedSocialCc)) {
            Integer maxCcExtend = ((CompanyMapper)this.dao).queryMaxCcExtend(unifiedSocialCc);
            if (maxCcExtend != null && maxCcExtend.toString().length() == 1) {
                ccExtend.append("00").append(maxCcExtend);
            } else if (maxCcExtend != null && maxCcExtend.toString().length() == 2) {
                ccExtend.append("0").append(maxCcExtend);
            } else if (maxCcExtend != null) {
                ccExtend.append(maxCcExtend);
            }
        }
        return ccExtend.toString();
    }

    @Override
    public List<Company> getCompanyList(CompanySearchModel searchModel) {
        Example example = new Example(Company.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("isValid", (Object)Global.TRUE);
        if (StringUtils.isNotEmpty((String)searchModel.getFullname())) {
            c.andLike("name", "%" + searchModel.getFullname() + "%");
        }
        if (searchModel.getRegType() != null && searchModel.getRegType() > 0) {
            c.andEqualTo("regType", (Object)searchModel.getRegType());
        }
        if (searchModel.getAreaIds() != null && searchModel.getAreaIds().size() > 0) {
            c.andIn("areaId", (Iterable)searchModel.getAreaIds());
        }
        example.setOrderByClause("update_date desc");
        return this.getListByExample(example);
    }

    @Override
    public List<CompanyListModel> searchList(String searchKey) {
        return ((CompanyMapper)this.dao).searchList(searchKey);
    }
}

