/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service.impl;

import cn.smarthse.modules.datacentre.dao.CompanyPlatformAdminMapper;
import cn.smarthse.modules.datacentre.entity.platformAdmin.CompanyPlatformAdmin;
import cn.smarthse.modules.datacentre.entity.system.SysParam;
import cn.smarthse.modules.datacentre.model.platformAdmin.CompanyBaseModel;
import cn.smarthse.modules.datacentre.model.platformAdmin.CompanyGovernModel;
import cn.smarthse.modules.datacentre.model.platformAdmin.CompanyModel;
import cn.smarthse.modules.datacentre.model.platformAdmin.CompanyPlatformAdminModel;
import cn.smarthse.modules.datacentre.model.platformAdmin.CompanyPlatformModel;
import cn.smarthse.modules.datacentre.model.platformAdmin.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.platformAdmin.search.CompanyPlatformAdminListModel;
import cn.smarthse.modules.datacentre.model.platformAdmin.search.CompanyPlatformAdminSearchModel;
import cn.smarthse.modules.datacentre.service.ICompanyPlatformAdminService;
import cn.smarthse.modules.datacentre.service.ZYJBaseServiceImpl;
import cn.smarthse.modules.datacentre.service.system.ISysParamService;
import java.util.List;
import javax.smarthse.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CompanyPlatformAdminServiceImpl
extends ZYJBaseServiceImpl<CompanyPlatformAdminMapper, CompanyPlatformAdmin>
implements ICompanyPlatformAdminService {
    @Autowired
    private CompanyPlatformAdminMapper companyPlatformAdminMapper;
    @Autowired
    private ISysParamService sysParamService;

    @Override
    public CompanyModel getCompanyPlatformAdminModel(Long cid) {
        if (cid == null) {
            throw new ServiceException("\u4f01\u4e1aid\u4e3a\u7a7a!");
        }
        CompanyModel record = new CompanyModel();
        CompanyBaseModel companyBaseModel = this.companyPlatformAdminMapper.selectCompanyBaseInfoModel(cid);
        CompanyGovernModel companyGovernModel = this.companyPlatformAdminMapper.selectCompanyGovernModel(cid);
        CompanyPlatformModel companyPlatformModel = this.companyPlatformAdminMapper.selectCompanyPlatformModel(cid);
        CompanyPlatformAdminModel companyPlatformAdminModel = this.companyPlatformAdminMapper.selectCompanyPlatformAdminModel(cid);
        CompanySuperviseModel companySuperviseModel = this.companyPlatformAdminMapper.selectCompanySuperviseModel(cid);
        record.setCompanyBaseModel(companyBaseModel);
        record.setCompanyGovernModel(companyGovernModel);
        record.setCompanyPlatformAdminModel(companyPlatformAdminModel);
        record.setCompanyPlatformModel(companyPlatformModel);
        record.setCompanySuperviseModel(companySuperviseModel);
        this.initOtherParam(record);
        return record;
    }

    @Override
    public List<CompanyPlatformAdminListModel> getCompanyList(CompanyPlatformAdminSearchModel searchModel) {
        List<CompanyPlatformAdminListModel> list = this.companyPlatformAdminMapper.selectCompanyList(searchModel);
        return list;
    }

    private void initOtherParam(CompanyModel companyModel) {
        if (companyModel == null) {
            return;
        }
        CompanyBaseModel companyBaseModel = companyModel.getCompanyBaseModel();
        if (companyBaseModel != null) {
            SysParam sysParam;
            if (companyBaseModel.getIndustryCategory() != null && companyBaseModel.getIndustryCategory() > 0L) {
                sysParam = (SysParam)this.sysParamService.getById(companyBaseModel.getIndustryCategory());
                companyBaseModel.setIndustryCategoryCode(sysParam.getParamCode());
                companyBaseModel.setIndustryCategoryValue(sysParam.getParamValue());
                this.initIndustryCategory(companyBaseModel, sysParam);
            }
            if (companyBaseModel.getRegisterType() != null) {
                sysParam = (SysParam)this.sysParamService.getById(companyBaseModel.getRegisterType());
                companyBaseModel.setRegisterTypeCode(sysParam.getParamCode());
                companyBaseModel.setRegisterTypeValue(sysParam.getParamValue());
            }
        }
    }

    private void initIndustryCategory(CompanyBaseModel companyBaseModel, SysParam currentSysParam) {
        int currentLevel = currentSysParam.getLevel();
        while (currentLevel > 0) {
            if (currentSysParam.getLevel() == 1) {
                companyBaseModel.setIndustryCategory1(currentSysParam.getId());
                companyBaseModel.setIndustryCategoryValue1(currentSysParam.getParamValue());
            } else if (currentSysParam.getLevel() == 2) {
                companyBaseModel.setIndustryCategory2(currentSysParam.getId());
                companyBaseModel.setIndustryCategoryValue2(currentSysParam.getParamValue());
                SysParam sysParam1 = (SysParam)this.sysParamService.getById(currentSysParam.getPid());
                companyBaseModel.setIndustryCategory1(sysParam1 == null ? null : sysParam1.getId());
                currentSysParam = sysParam1;
            } else if (currentSysParam.getLevel() == 3) {
                companyBaseModel.setIndustryCategory3(currentSysParam.getId());
                companyBaseModel.setIndustryCategoryValue3(currentSysParam.getParamValue());
                SysParam sysParam2 = (SysParam)this.sysParamService.getById(currentSysParam.getPid());
                companyBaseModel.setIndustryCategory2(sysParam2 == null ? null : sysParam2.getId());
                currentSysParam = sysParam2;
            } else if (currentSysParam.getLevel() == 4) {
                companyBaseModel.setIndustryCategory4(currentSysParam.getId());
                companyBaseModel.setIndustryCategoryValue4(currentSysParam.getParamValue());
                SysParam sysParam3 = (SysParam)this.sysParamService.getById(currentSysParam.getPid());
                companyBaseModel.setIndustryCategory3(sysParam3 == null ? null : sysParam3.getId());
                currentSysParam = sysParam3;
            }
            --currentLevel;
        }
    }
}

