/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.service;

import cn.smarthse.modules.platform.core.framework.Global;
import cn.smarthse.modules.platform.core.framework.mybatis.ZYJMapper;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import net.sf.ehcache.CacheManager;
import org.apache.ibatis.session.RowBounds;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
public abstract class ZYJBaseServiceImpl<D extends ZYJMapper<T>, T>
implements IBaseService<T> {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired(required=false)
    protected D dao;
    @Autowired
    protected CacheManager cacheManager;

    public T getById(Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        return (T)this.dao.selectByPrimaryKey((Object)id);
    }

    public T getById(Long id, Long createBy) {
        T entity = this.getById(id);
        if (entity != null) {
            Class<?> cls = entity.getClass();
            try {
                Method getCreateBy = cls.getDeclaredMethod("getCreateBy", new Class[0]);
                Object thisCreateBy = getCreateBy.invoke(entity, new Object[0]);
                if (thisCreateBy != null && thisCreateBy instanceof Long && thisCreateBy.equals(createBy)) {
                    return entity;
                }
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public List<T> getListByExample(Example example) {
        return this.dao.selectByExample((Object)example);
    }

    public int getCountByExample(Example example) {
        return this.dao.selectCountByExample((Object)example);
    }

    private void setUpdateInfo(T entity, Long updateBy) {
        Class<?> cls = entity.getClass();
        try {
            Method setUpdateBy;
            Method setUpdateDate = cls.getDeclaredMethod("setUpdateDate", Date.class);
            if (setUpdateDate != null) {
                setUpdateDate.invoke(entity, new Date());
            }
            if (updateBy != null && (setUpdateBy = cls.getDeclaredMethod("setUpdateBy", Long.class)) != null) {
                setUpdateBy.invoke(entity, updateBy);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void setIsValid(T entity, boolean bln) {
        Class<?> cls = entity.getClass();
        try {
            Method setIsValid = cls.getDeclaredMethod("setIsValid", Boolean.class);
            if (setIsValid != null) {
                setIsValid.invoke(entity, bln);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void setCreateInfo(T entity, Long loginStaffId) {
        Class<?> cls = entity.getClass();
        try {
            Method setCreateBy;
            Method setCreateDate = cls.getDeclaredMethod("setCreateDate", Date.class);
            if (setCreateDate != null) {
                setCreateDate.invoke(entity, new Date());
            }
            this.setIsValid(entity, Global.TRUE);
            if (loginStaffId != null && (setCreateBy = cls.getDeclaredMethod("setCreateBy", Long.class)) != null) {
                setCreateBy.invoke(entity, loginStaffId);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void setId(T entity, Long id) {
        Class<?> cls = entity.getClass();
        try {
            Method setId = cls.getDeclaredMethod("setId", Long.class);
            if (setId != null) {
                setId.invoke(entity, id);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Transactional(readOnly=false)
    public T add(T entity) {
        this.dao.insertSelective(entity);
        return entity;
    }

    @Transactional(readOnly=false)
    public T add(T entity, Long createBy) {
        this.setId(entity, null);
        this.setCreateInfo(entity, createBy);
        this.setUpdateInfo(entity, createBy);
        this.dao.insertSelective(entity);
        return entity;
    }

    @Transactional(readOnly=false)
    public Integer update(T entity) {
        Integer count = this.dao.updateByPrimaryKeySelective(entity);
        return count;
    }

    @Transactional(readOnly=false)
    public Integer update(T entity, Long updateBy) {
        this.setUpdateInfo(entity, updateBy);
        Integer count = this.dao.updateByPrimaryKeySelective(entity);
        return count;
    }

    @Transactional(readOnly=false)
    public Integer updateByPrimaryKey(T entity, Long updateBy) {
        this.setUpdateInfo(entity, updateBy);
        Integer count = this.dao.updateByPrimaryKey(entity);
        return count;
    }

    @Transactional(readOnly=false)
    public Integer delete(T entity, Long updateBy) {
        this.setUpdateInfo(entity, updateBy);
        this.setIsValid(entity, Global.FALSE);
        Integer count = this.dao.updateByPrimaryKeySelective(entity);
        return count;
    }

    @Transactional(readOnly=false)
    public Integer deleteById(Long id, Long updateBy) {
        T entity = this.getById(id);
        if (entity != null) {
            return this.delete(entity, updateBy);
        }
        return 0;
    }

    public List<T> getListByIds(String ids) {
        return this.dao.selectByIds(ids);
    }

    protected T getOneByExample(Example example) {
        List list = this.dao.selectByExampleAndRowBounds((Object)example, new RowBounds(0, 1));
        if (list.size() > 0) {
            return (T)list.get(0);
        }
        return null;
    }
}

