/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.sms;

import cn.smarthse.modules.datacentre.bootstrap.properties.SmtProperties;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderService;
import cn.smarthse.modules.platform.core.framework.mapper.JsonMapper;
import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import com.alibaba.dubbo.config.annotation.Service;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Service(version="1.0.0")
@Transactional(readOnly=true)
public class SmsProvideServiceImpl
implements ISMSProviderService {
    protected Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private SmtProperties smtProperties;

    public String sendVcode(String vcode, String mobile) {
        String text = "\u60a8\u7684\u9a8c\u8bc1\u7801\u662f:" + vcode + ",\u8bf7\u52ff\u5411\u4efb\u4f55\u4eba\u6cc4\u9732,5\u5206\u949f\u6709\u6548\u3002";
        if (!StringUtils.checkMobile((String)mobile)) {
            this.logger.error("mobile:{}, \u53d1\u9001\u9a8c\u8bc1\u7801\u77ed\u4fe1: {} \u5931\u8d25", (Object)mobile, (Object)text);
            return "fail";
        }
        this.logger.info("\u53d1\u9001\u9a8c\u8bc1\u7801\u77ed\u4fe1: {}", (Object)text);
        int tryCount = 0;
        String result = null;
        while (tryCount < this.smtProperties.getTrytime()) {
            result = this.batchSendTextSms(text, mobile);
            this.logger.info("\u53d1\u9001\u9a8c\u8bc1\u7801\u77ed\u4fe1 result:{}", (Object)result);
            if (StringUtils.isNotEmpty((String)result)) break;
            ++tryCount;
        }
        if (StringUtils.isNotEmpty(result)) {
            return "success";
        }
        tryCount = 0;
        SendSmsResponse response = null;
        try {
            while (tryCount < this.smtProperties.getTrytime()) {
                response = this.sendAliVcode(mobile, vcode);
                if (!"OK".equals(response.getCode())) {
                    ++tryCount;
                    continue;
                }
                break;
            }
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        return "success";
    }

    public String sendTextSms(String text, String mobile) {
        this.logger.info("\u53d1\u9001\u6587\u672c\u77ed\u4fe1:{}, \u77ed\u4fe1\u5185\u5bb9 :{}", (Object)mobile, (Object)(String.valueOf(text) + this.smtProperties.getMSGSIGN()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CorpID", this.smtProperties.getCORPID());
        params.put("Pwd", this.smtProperties.getPWD());
        params.put("Content", String.valueOf(text) + this.smtProperties.getMSGSIGN());
        params.put("Mobile", mobile);
        params.put("Cell", "");
        params.put("SendTime", "");
        return this.post(this.smtProperties.getURI_SEND_SMS(), params);
    }

    public String batchSendTextSms(String text, String mobiles) {
        this.logger.info("\u6279\u91cf\u53d1\u9001\u6587\u672c\u77ed\u4fe1:{}, \u77ed\u4fe1\u5185\u5bb9 :{}", (Object)mobiles, (Object)(String.valueOf(text) + this.smtProperties.getMSGSIGN()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CorpID", this.smtProperties.getCORPID());
        params.put("Pwd", this.smtProperties.getPWD());
        params.put("Content", String.valueOf(text) + this.smtProperties.getMSGSIGN());
        params.put("Mobile", mobiles);
        params.put("Cell", "");
        params.put("SendTime", "");
        String result = this.post(this.smtProperties.getURI_BATCHSEND_SMS(), params);
        this.logger.info("\u6279\u91cf\u53d1\u9001\u6587\u672c\u77ed\u4fe1:{}, \u77ed\u4fe1\u5185\u5bb9 :{},\u53d1\u9001\u7ed3\u679c:{}", (Object)mobiles, (Object)(String.valueOf(text) + this.smtProperties.getMSGSIGN()), (Object)result);
        return result;
    }

    private SendSmsResponse sendAliVcode(String phoneNumbers, String vcode) throws ClientException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("code", vcode);
        String templateParam = JsonMapper.toJsonString(resultMap);
        return this.sendAliSms(phoneNumbers, this.smtProperties.getDysmsapi().getTemplatecode(), templateParam, null, null);
    }

    private SendSmsResponse sendAliSms(String phoneNumbers, String templateCode, String templateParam, String SmsUpExtendCode, String outId) throws ClientException {
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        DefaultProfile profile = DefaultProfile.getProfile((String)this.smtProperties.getDysmsapi().getRegionid(), (String)this.smtProperties.getDysmsapi().getAccesskeyid(), (String)this.smtProperties.getDysmsapi().getAccesskeysecret());
        DefaultProfile.addEndpoint((String)this.smtProperties.getDysmsapi().getEndpointname(), (String)this.smtProperties.getDysmsapi().getRegionid(), (String)this.smtProperties.getDysmsapi().getProduct(), (String)this.smtProperties.getDysmsapi().getDomain());
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(phoneNumbers);
        request.setSignName(this.smtProperties.getDysmsapi().getSignname());
        request.setTemplateCode(templateCode);
        if (StringUtils.isNotEmpty((String)templateParam)) {
            request.setTemplateParam(templateParam);
        }
        if (StringUtils.isNotEmpty((String)SmsUpExtendCode)) {
            request.setSmsUpExtendCode(SmsUpExtendCode);
        }
        if (StringUtils.isNotEmpty((String)outId)) {
            request.setOutId(outId);
        }
        SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
        return sendSmsResponse;
    }

    private String post(String url, Map<String, String> paramsMap) {
        CloseableHttpClient client = HttpClients.createDefault();
        String responseText = "";
        CloseableHttpResponse response = null;
        try {
            try {
                HttpEntity entity;
                HttpPost method = new HttpPost(url);
                if (paramsMap != null) {
                    ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                    for (Map.Entry<String, String> param : paramsMap.entrySet()) {
                        BasicNameValuePair pair = new BasicNameValuePair(param.getKey(), param.getValue());
                        paramList.add(pair);
                    }
                    method.setEntity((HttpEntity)new UrlEncodedFormEntity(paramList, this.smtProperties.getENCODING()));
                }
                if ((entity = (response = client.execute((HttpUriRequest)method)).getEntity()) != null) {
                    responseText = EntityUtils.toString((HttpEntity)entity);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    response.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return responseText;
    }
}

