/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider.impl;

import cn.smarthse.modules.datacentre.entity.system.SysArea;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.alibaba.dubbo.config.annotation.Service;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(version="1.0.0")
@Transactional(readOnly=true)
public class SysAreaProvideServiceImpl
implements ISysAreaProvideService {
    @Autowired
    private ISysAreaService areaService;

    public AreaModel getAreaById(Long areaId) {
        if (areaId != null) {
            SysArea sysArea = (SysArea)this.areaService.getById(areaId);
            AreaModel model = new AreaModel();
            BeanUtils.copyProperties((Object)sysArea, (Object)model);
            return model;
        }
        return null;
    }

    public List<Long> getAreaIdByParent(Long parentId) {
        List<SysArea> list = this.areaService.getChildByPrefix(String.valueOf(parentId));
        ArrayList<Long> data = new ArrayList<Long>();
        list.forEach(area -> data.add(area.getId()));
        return data;
    }

    public List<AreaModel> getAllProvinceList() {
        List<SysArea> allProvinceList = this.areaService.getAllProvinceList();
        List<AreaModel> result = this.convertArea2Model(allProvinceList);
        return result;
    }

    public List<AreaModel> getCityList(Long provinceId) {
        List<SysArea> cityList = this.areaService.getCityList(provinceId);
        List<AreaModel> result = this.convertArea2Model(cityList);
        return result;
    }

    public List<AreaModel> getAreaList(Long cityId) {
        List<SysArea> areaList = this.areaService.getAreaList(cityId);
        List<AreaModel> result = this.convertArea2Model(areaList);
        return result;
    }

    public List<AreaModel> getStreetList(Long areaId) {
        List<SysArea> areaList = this.areaService.getStreetList(areaId);
        List<AreaModel> result = this.convertArea2Model(areaList);
        return result;
    }

    public List<AreaModel> getChildByParentId(Long parentId, String name) {
        List<SysArea> sysAreaList = this.areaService.getChildByParentId(parentId, name);
        List<AreaModel> result = this.convertArea2Model(sysAreaList);
        return result;
    }

    private List<AreaModel> convertArea2Model(List<SysArea> cityList) {
        ArrayList<AreaModel> result = new ArrayList<AreaModel>();
        if (CollectionUtils.isNotEmpty(cityList)) {
            cityList.forEach(en -> {
                AreaModel am = new AreaModel();
                BeanUtils.copyProperties((Object)en, (Object)am);
                result.add(am);
            });
        }
        return result;
    }

    public AreaModel getAreaByName(Long parentId, String name) {
        if (name == null) {
            return null;
        }
        SysArea criObj = new SysArea();
        criObj.setParentId(parentId);
        if (parentId != null && parentId.equals(0L)) {
            if (name.equals("\u65b0\u7586")) {
                name = "\u65b0\u7586\u7ef4\u543e\u5c14";
            }
            criObj.setShortName(name);
        } else {
            criObj.setName(name);
        }
        List<SysArea> list = this.commonQuerySysArea(criObj);
        if (list != null && list.size() > 0) {
            SysArea area = list.get(0);
            AreaModel model = new AreaModel();
            BeanUtils.copyProperties((Object)area, (Object)model);
            return model;
        }
        return null;
    }

    public List<SysArea> commonQuerySysArea(SysArea queryObj) {
        Example example = new Example(SysArea.class);
        Example.Criteria cri = example.createCriteria();
        queryObj.setIsValid(true);
        cri.andEqualTo((Object)queryObj);
        example.orderBy("orderBy");
        return this.areaService.selectByExample(example);
    }
}

