/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider;

import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.entity.platform.CompanyPlatform;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.model.CompanyListModel;
import cn.smarthse.modules.datacentre.model.CompanyRegInfoModel;
import cn.smarthse.modules.datacentre.model.platform.CompanyPlatformModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.datacentre.service.ICompanyPlatformService;
import cn.smarthse.modules.datacentre.service.ICompanyService;
import cn.smarthse.modules.datacentre.service.childtable.IAddData2ChildTableService;
import cn.smarthse.modules.datacentre.service.childtable.ICommonChildTableAddDataService;
import cn.smarthse.modules.datacentre.util.CompanyPlatformModelUtil;
import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import com.alibaba.dubbo.config.annotation.Service;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.Objects;
import javax.platform.exception.ServiceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Service(version="1.0.0")
@Transactional(readOnly=true)
public class CompanyProvideServiceImpl
implements ICompanyProvideService,
IAddData2ChildTableService {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private ICompanyPlatformService companyPlatformService;
    @Autowired
    private CompanyPlatformModelUtil companyPlatformModelUtil;
    @Autowired
    private ICommonChildTableAddDataService commonChildTableAddDataService;

    public CompanyPlatformModel getCompanyBaseInfoById(Long cid) {
        CompanyPlatformModel companyInfo = this.companyPlatformService.getModelByCid(cid);
        return companyInfo;
    }

    @Transactional(readOnly=false)
    public void updateCompanyBaseInfoByPlatform(CompanyPlatformModel baseInfo, Long updateBy) {
        this.logger.info("\u5e73\u53f0\u66f4\u65b0\u4f01\u4e1a\u4fe1\u606f\uff1a {}", (Object)baseInfo);
        Company company = (Company)this.companyService.getById(baseInfo.getCid());
        company.setName(baseInfo.getName());
        company.setCompanyContactTel(baseInfo.getCompanyContactTel());
        company.setAreaId(baseInfo.getAreaDetailId());
        company.setWorkAddress(baseInfo.getWorkAddress());
        company.setRegisterAddress(baseInfo.getRegisterAddress());
        company.setCompanyPostalAdress(baseInfo.getCompanyPostalAdress());
        company.setScale(baseInfo.getScale());
        company.setRegisterType(baseInfo.getRegisterType());
        company.setIndustryCategory(baseInfo.getIndustryCategory());
        company.setLegalName(baseInfo.getLegalName());
        company.setLegalTel(baseInfo.getLegalTel());
        company.setUnifiedSocialCc(baseInfo.getUnifiedSocialCc());
        company.setCorpCcExtend(baseInfo.getCorpCcExtend());
        company.setLogoFileUrl(baseInfo.getLogoFileUrl());
        this.companyService.updateByPrimaryKey(company, updateBy);
        CompanyPlatform cp = this.companyPlatformService.getByCid(baseInfo.getCid());
        cp.setCorpApplyMobile(baseInfo.getCorpApplyMobile());
        cp.setCorpApplyName(baseInfo.getCorpApplyName());
        cp.setLogoFileId(baseInfo.getLogoFileId());
        cp.setCorpFileId(baseInfo.getCorpFileId());
        cp.setCorpFileUrl(baseInfo.getCorpFileUrl());
        this.companyPlatformService.updateByPrimaryKey(cp, updateBy);
    }

    public CompanyPlatformModel getBycompanyName(String name, Long cid) {
        Company company = this.companyService.getCompanyByName(name);
        if (company == null) {
            return null;
        }
        CompanyPlatformModel cpm = this.companyPlatformService.getModelByCid(company.getId());
        return this.companyPlatformModelUtil.company2model(cpm);
    }

    public Boolean checkBycompanyName(String name, Long cid) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new ServiceException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Company company = this.companyService.getCompanyByName(name);
        if (company == null) {
            return true;
        }
        if (company != null && Objects.equals(company.getId(), cid)) {
            return true;
        }
        return false;
    }

    public Boolean checkByUnifiedSocialCc(String unifiedSocialCc, Long cid) {
        Company company = this.companyService.getByCases(unifiedSocialCc, cid, null, null);
        if (company == null) {
            return true;
        }
        return false;
    }

    public Boolean checkByEmail(String email, Long cid) {
        Company company = this.companyService.getByCases(null, cid, null, email);
        if (company == null) {
            return true;
        }
        return false;
    }

    public Long getCidByEmail(String email) {
        Company company = this.companyService.getByCases(null, null, null, email);
        if (company == null) {
            return null;
        }
        return company.getId();
    }

    public CompanyPlatformModel getByEmail(String email, Long cid) {
        Company company = this.companyService.getByCases(null, null, null, email);
        if (company == null) {
            return null;
        }
        CompanyPlatformModel cpm = this.companyPlatformService.getModelByCid(company.getId());
        return this.companyPlatformModelUtil.company2model(cpm);
    }

    @Transactional(readOnly=false)
    public void updateCompanyEmail(Long cid, String email, Integer emailCheck, Long userId) {
        CompanyPlatform cp = this.companyPlatformService.getByCid(cid);
        if (cp == null) {
            throw new ServiceException("\u5e73\u53f0\u4f01\u4e1a\u4fe1\u606f\u9519\u8bef!");
        }
        if (emailCheck != null && emailCheck > 0) {
            cp.setCorpEmailCheck(emailCheck);
        }
        this.companyPlatformService.updateByPrimaryKey(cp, userId);
        Company company = (Company)this.companyService.getById(cid);
        if (StringUtils.isNotEmpty((String)email)) {
            company.setCompanyContactEmail(email);
        }
        this.companyService.updateByPrimaryKey(company, userId);
    }

    @Transactional(readOnly=false)
    public CompanyPlatformModel createCompanyByPlatform(CompanyRegInfoModel regInfo) {
        if (!this.checkBycompanyName(regInfo.getFullname(), null).booleanValue()) {
            throw new ServiceException("\u4f01\u4e1a\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Company company = new Company();
        company.setName(regInfo.getFullname());
        company.setUnifiedSocialCc(regInfo.getCorpCc());
        company.setIndustryCategory(regInfo.getCorpType());
        company.setAreaId(regInfo.getCorpAreaId());
        company.setRegisterAddress(regInfo.getCorpAddress());
        company.setWorkAddress(regInfo.getCorpAddress());
        company.setCompanyPostalAdress(regInfo.getCorpAddress());
        company.setCompanyContactEmail(regInfo.getCorpEmail());
        String corpCcExtend = this.companyService.getCorpCcExtend(regInfo.getCorpCc());
        company.setCorpCcExtend(corpCcExtend);
        company.setDataSource(CompanyDataSourceEnum.PLATFORM.getValue());
        company = (Company)this.companyService.add(company, 0L);
        CompanyPlatform cp = new CompanyPlatform();
        cp.setRegType(regInfo.getRegType());
        cp.setCorpApplyName(regInfo.getCorpApplyName());
        cp.setCorpApplyMobile(regInfo.getCorpApplyMobile());
        cp.setCorpFileId(regInfo.getCorpFileId());
        cp.setCorpFileUrl(regInfo.getCorpFileUrl());
        cp.setCid(company.getId());
        this.companyPlatformService.add(cp, 0L);
        this.commonChildTableAddDataService.addChildTableData(company, 0L);
        CompanyPlatformModel cpm = this.companyPlatformService.getModelByCid(company.getId());
        return this.companyPlatformModelUtil.company2model(cpm);
    }

    public String getFullnameBycid(Long cid) {
        Company company = (Company)this.companyService.getById(cid);
        if (company == null) {
            return null;
        }
        return company.getName();
    }

    public List<CompanyListModel> searchList(String searchKey) {
        PageHelper.startPage((int)1, (int)100);
        List<CompanyListModel> companyList = this.companyService.searchList(searchKey);
        return companyList;
    }

    @Override
    public boolean enable() {
        return true;
    }

    @Override
    @Transactional(readOnly=false)
    public void addData(Company company, Long loginStaffId) {
        CompanyPlatform cp;
        if (this.enable() && (cp = this.companyPlatformService.getByCid(company.getId())) == null) {
            cp = new CompanyPlatform();
            cp.setCid(company.getId());
            this.companyPlatformService.add(cp, loginStaffId);
        }
    }
}

