/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider;

import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.entity.supervise.CompanySupervise;
import cn.smarthse.modules.datacentre.enums.CompanyDataSourceEnum;
import cn.smarthse.modules.datacentre.model.CompanySearchModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.service.ICompanyService;
import cn.smarthse.modules.datacentre.service.ICompanySuperviseService;
import cn.smarthse.modules.datacentre.service.childtable.ICommonChildTableAddDataService;
import cn.smarthse.modules.datacentre.util.CompanySuperviseModelUtil;
import cn.smarthse.modules.platform.core.framework.jqgrid.JqGridParam;
import com.alibaba.dubbo.config.annotation.Service;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Service(version="1.0.0")
@Transactional(readOnly=true)
public class CompanyProvideBySuperviseServiceImpl
implements ICompanyProvideBySuperviseService {
    @Autowired
    private ICompanySuperviseService companySuperviseService;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private ICommonChildTableAddDataService commonChildTableAddDataService;
    @Autowired
    private CompanySuperviseModelUtil superviseModelUtil;

    public PageInfo<CompanySuperviseModel> pageCompanyInfo(CompanySuperviseSearchModel companySearchVo, boolean getBaseInfo, int pageNum, int pageSize) {
        JqGridParam param = new JqGridParam();
        param.setPage(pageNum);
        param.setRows(pageSize);
        return this.companySuperviseService.pageCompanyInfo(param, companySearchVo, getBaseInfo);
    }

    public List<CompanySuperviseModel> listCompanyInfo(CompanySuperviseSearchModel companySearchVo, boolean getBaseInfo) {
        return this.companySuperviseService.listCompanyInfo(companySearchVo, getBaseInfo);
    }

    public CompanySuperviseModel getCompanyInfoById(Long id) {
        if (id == null) {
            return null;
        }
        Company company = (Company)this.companyService.getById(id);
        CompanySuperviseModel companyBaseInfoModel = this.superviseModelUtil.company2model(company);
        return companyBaseInfoModel;
    }

    @Transactional(readOnly=true)
    public List<CompanySuperviseModel> listCompanyByName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Collections.emptyList();
        }
        CompanySearchModel searchModel = new CompanySearchModel();
        searchModel.setFullname(name);
        List<Company> companyList = this.companyService.getCompanyList(searchModel);
        if (companyList != null && !companyList.isEmpty()) {
            ArrayList<CompanySuperviseModel> companyModelList = new ArrayList<CompanySuperviseModel>();
            for (Company company : companyList) {
                CompanySuperviseModel companyBaseInfoModel = this.superviseModelUtil.company2model(company);
                companyModelList.add(companyBaseInfoModel);
            }
            return companyModelList;
        }
        return Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(readOnly=false)
    public CompanySuperviseModel saveImportCompany(CompanySuperviseModel company, Long loginStaffId) {
        Company c = new Company();
        BeanUtils.copyProperties((Object)company, (Object)c);
        if (c.getId() != null) {
            Company dbCompany = (Company)this.companyService.getById(c.getId());
            if (dbCompany == null || dbCompany.getAreaId() == null || !dbCompany.getAreaId().equals(c.getAreaId()) || dbCompany.getUnifiedSocialCc() == null || !dbCompany.getUnifiedSocialCc().equals(c.getUnifiedSocialCc()) || dbCompany.getName() == null || !dbCompany.getName().equals(c.getName())) throw new RuntimeException("\u8bf7\u786e\u8ba4\u4f01\u4e1a\u3010" + c.getName() + "\u3011\u7684\u540d\u79f0\u3001\u6240\u5728\u884c\u653f\u533a\u5212\u3001\u4fe1\u7528\u4ee3\u7801");
            CompanySupervise supervise = new CompanySupervise();
            supervise.setSuperviseIsDel(false);
            supervise.setUpdateDate(new Date());
            supervise.setUpdateBy(loginStaffId);
            this.companySuperviseService.updateSuperViseByCid(supervise, c.getId());
            this.companyService.update(c, loginStaffId);
            return this.superviseModelUtil.company2model(c);
        } else {
            List<CompanySuperviseModel> companyList = this.listCompanyByName(c.getName());
            if (companyList != null && !companyList.isEmpty()) throw new RuntimeException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u4f01\u4e1a\u540d\u79f0");
            c.setDataSource(CompanyDataSourceEnum.SUPERVISE.getValue());
            this.companyService.add(c, loginStaffId);
            this.commonChildTableAddDataService.addChildTableData(c, loginStaffId);
        }
        return this.superviseModelUtil.company2model(c);
    }

    @Transactional(readOnly=false)
    public CompanySuperviseModel updateCompany(CompanySuperviseModel c, Long loginStaffId) {
        Company dbcompany;
        if (c != null && c.getId() != null && (dbcompany = (Company)this.companyService.getById(c.getId())) != null) {
            dbcompany.setName(c.getName());
            dbcompany.setAreaId(c.getAreaId());
            dbcompany.setIndustryCategory(c.getIndustryCategory());
            dbcompany.setCompanyContactTel(c.getCompanyContactTel());
            dbcompany.setRegisterAddress(c.getRegisterAddress());
            dbcompany.setWorkAddress(c.getWorkAddress());
            dbcompany.setUnifiedSocialCc(c.getUnifiedSocialCc());
            dbcompany.setRegisterType(c.getRegisterType());
            dbcompany.setScale(c.getScale());
            dbcompany.setLegalName(c.getLegalName());
            dbcompany.setLegalTel(c.getLegalTel());
            if (c.getIsBest() == null) {
                c.setIsBest(Boolean.valueOf(false));
            }
            CompanySupervise supervise = new CompanySupervise();
            supervise.setIsBest(c.getIsBest());
            if (c.getIsBest().booleanValue()) {
                supervise.setBestUpdateTime(new Date());
            }
            supervise.setUpdateDate(new Date());
            supervise.setUpdateBy(loginStaffId);
            this.companySuperviseService.updateSuperViseByCid(supervise, c.getId());
            this.companyService.updateByPrimaryKey(dbcompany, loginStaffId);
        }
        return c;
    }

    @Transactional(readOnly=false)
    public int delCompanyByIds(String ids) {
        return this.companySuperviseService.delCompanySuperviseByIds(ids);
    }

    @Transactional(readOnly=false)
    public int bestCompanyByIds(String ids, Long loginUser) {
        return this.companySuperviseService.bestCompanyByIds(ids, loginUser);
    }

    @Transactional(readOnly=false)
    public int cancelBestCompany(Long cid, Long loginUser) {
        CompanySupervise c = new CompanySupervise();
        c.setIsBest(false);
        c.setUpdateBy(loginUser);
        c.setUpdateDate(new Date());
        return this.companySuperviseService.updateSuperViseByCid(c, cid);
    }

    public PageInfo<CompanySuperviseModel> pageCompanyByBest(Long areaId, Boolean isBest, int pageNum, int pageSize) {
        CompanySuperviseSearchModel companySearchVo = new CompanySuperviseSearchModel();
        companySearchVo.setAreaId(areaId);
        companySearchVo.setIsBest(isBest);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<CompanySuperviseModel> companyBaseInfoModels = this.listCompanyInfo(companySearchVo, false);
        PageInfo page = new PageInfo(companyBaseInfoModels);
        return page;
    }
}

