/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider;

import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.service.ICompanyService;
import cn.smarthse.modules.datacentre.service.ICompanySuperviseService;
import cn.smarthse.modules.datacentre.service.childtable.IAddData2ChildTableService;
import cn.smarthse.modules.datacentre.util.CompanyBaseInfoModelUtil;
import com.alibaba.dubbo.config.annotation.Service;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Service(version="1.0.0")
@Transactional(readOnly=true)
public class CompanyProvideByHSEServiceImpl
implements ICompanyProvideByHSEService,
IAddData2ChildTableService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private ICompanySuperviseService superviseService;
    @Autowired
    private CompanyBaseInfoModelUtil companyBaseInfoModelUtil;

    @Transactional(readOnly=true)
    public CompanyBaseInfoModel getCompanyById(Long id) {
        if (id == null) {
            return new CompanyBaseInfoModel();
        }
        Company company = (Company)this.companyService.getById(id);
        if (company != null) {
            CompanyBaseInfoModel companyBaseInfoModel = this.companyBaseInfoModelUtil.company2model(company);
            return companyBaseInfoModel;
        }
        return new CompanyBaseInfoModel();
    }

    @Transactional(readOnly=true)
    public String getCompanyNameById(Long id) {
        if (id == null) {
            return "";
        }
        Company company = (Company)this.companyService.getById(id);
        if (company != null) {
            return company.getName();
        }
        return "";
    }

    @Transactional(readOnly=false)
    public CompanyBaseInfoModel saveOrUpdateCompany(CompanyBaseInfoModel companyModel, Long loginStaffId, Long cid) throws Exception {
        if (companyModel == null) {
            throw new Exception("companyModel \u4e0d\u80fd\u4e3a\u7a7a");
        }
        Company company = (Company)this.companyService.getById(companyModel.getCid());
        company.setId(companyModel.getCid());
        company.setName(companyModel.getName());
        company.setShortName(companyModel.getShortName());
        company.setFatherDept(companyModel.getFatherDept());
        company.setSettingTime(companyModel.getSettingTime());
        company.setUnifiedSocialCc(companyModel.getUnifiedSocialCc());
        company.setCompanyContactTel(companyModel.getCompanyContactTel());
        company.setCompanyContactEmail(companyModel.getCompanyContactEmail());
        company.setCompanyContactFax(companyModel.getCompanyContactFax());
        company.setAreaId(companyModel.getAreaId());
        company.setRegisterAddress(companyModel.getRegisterAddress());
        company.setRegisterPost(companyModel.getRegisterPost());
        company.setCompanyPostalAdress(companyModel.getCompanyPostalAdress());
        company.setWorkAddress(companyModel.getWorkAddress());
        company.setRegisterType(companyModel.getRegisterType());
        company.setIndustryCategory(companyModel.getIndustryCategory());
        company.setOccupationalRiskClassify(companyModel.getOccupationalRiskClassify());
        company.setStaffCount(companyModel.getStaffCount());
        company.setPickupCount(companyModel.getPickupCount());
        company.setMainOperaIncome(companyModel.getMainOperaIncome());
        company.setRegisterCapital(companyModel.getRegisterCapital());
        company.setScale(companyModel.getScale());
        company.setYearAssets(companyModel.getYearAssets());
        company.setTotalAssets(companyModel.getTotalAssets());
        company.setLegalName(companyModel.getLegalName());
        company.setLegalTel(companyModel.getLegalTel());
        company.setChemicalEmergencyPhone(companyModel.getChemicalEmergencyPhone());
        company.setOccLeaderSid(companyModel.getOccLeaderSid());
        company.setOccLeaderTel(companyModel.getOccLeaderTel());
        if (company.getId() != null) {
            this.companyService.update(company, loginStaffId);
        } else {
            company.setIsValid(true);
            Company dbc = (Company)this.companyService.add(company, loginStaffId);
            companyModel.setCid(dbc.getId());
        }
        return companyModel;
    }

    public List<CompanySuperviseModel> listSuperviseCompanyData() {
        return this.superviseService.listSuperviseCompanyData();
    }

    public Integer countSuperviseCompanyData() {
        return this.superviseService.countSuperviseCompanyData();
    }

    public List<CompanySuperviseModel> listSuperviseCompanyData(int page, int pageSize) {
        return this.superviseService.listSuperviseCompanyData(page, pageSize);
    }

    @Override
    public boolean enable() {
        return true;
    }

    @Override
    @Transactional(readOnly=false)
    public void addData(Company company, Long loginStaffId) {
        this.logger.debug("Hse \u5b50\u8868\u6dfb\u52a0\u6570\u636e.....");
    }
}

