/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider;

import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.entity.CompanyGovern;
import cn.smarthse.modules.datacentre.entity.platform.CompanyPlatform;
import cn.smarthse.modules.datacentre.entity.platformAdmin.CompanyPlatformAdmin;
import cn.smarthse.modules.datacentre.entity.supervise.CompanySupervise;
import cn.smarthse.modules.datacentre.entity.system.SysArea;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.CompanySearchModel;
import cn.smarthse.modules.datacentre.model.platformAdmin.CompanyModel;
import cn.smarthse.modules.datacentre.model.platformAdmin.CompanyPlatformAdminModel;
import cn.smarthse.modules.datacentre.model.platformAdmin.search.CompanyPlatformAdminListModel;
import cn.smarthse.modules.datacentre.model.platformAdmin.search.CompanyPlatformAdminSearchModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByAdminService;
import cn.smarthse.modules.datacentre.service.ICompanyGovernService;
import cn.smarthse.modules.datacentre.service.ICompanyPlatformAdminService;
import cn.smarthse.modules.datacentre.service.ICompanyPlatformService;
import cn.smarthse.modules.datacentre.service.ICompanyService;
import cn.smarthse.modules.datacentre.service.ICompanySuperviseService;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.datacentre.util.CompanyBaseInfoModelUtil;
import cn.smarthse.modules.datacentre.util.CompanyPlatformAdminModelUtil;
import com.alibaba.dubbo.config.annotation.Service;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.smarthse.exception.ServiceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Service(version="1.0.0")
@Transactional(readOnly=true)
public class CompanyProvideByAdminServiceImpl
implements ICompanyProvideByAdminService {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private ICompanyGovernService companyGovernService;
    @Autowired
    private ICompanyPlatformService companyPlatformService;
    @Autowired
    private ICompanyPlatformAdminService companyPlatformAdminService;
    @Autowired
    private ICompanySuperviseService companySuperviseService;
    @Autowired
    private CompanyBaseInfoModelUtil companyBaseInfoModelUtil;
    @Autowired
    private ISysAreaService areaService;

    public PageInfo<CompanyBaseInfoModel> getCorpInfoListByGridParam(CompanySearchModel searchModel) {
        this.logger.info("searchModel = {}", (Object)searchModel);
        PageHelper.startPage((int)searchModel.getPageNum(), (int)searchModel.getPageSize());
        List<Company> list = this.companyService.getCompanyList(searchModel);
        PageInfo info = new PageInfo(list);
        ArrayList data = new ArrayList();
        list.forEach(company -> {
            CompanyBaseInfoModel companyModel = this.companyBaseInfoModelUtil.company2model((Company)company);
            data.add(companyModel);
        });
        PageInfo page = new PageInfo(data);
        page.setPageNum(info.getPageNum());
        page.setPages(info.getPages());
        page.setPageSize(info.getPages());
        page.setSize(info.getSize());
        page.setTotal(info.getTotal());
        return page;
    }

    public CompanyBaseInfoModel getCompanyBaseInfoById(Long cid) {
        Company company = (Company)this.companyService.getById(cid);
        CompanyBaseInfoModel companyInfo = this.companyBaseInfoModelUtil.company2model(company);
        return companyInfo;
    }

    public CompanyModel getCompanyPlatformAdminModelById(Long cid) {
        CompanyModel companyModel = this.companyPlatformAdminService.getCompanyPlatformAdminModel(cid);
        return companyModel;
    }

    public List<CompanyBaseInfoModel> getCorpInfoListBySearch(CompanySearchModel searchModel) {
        List<Company> list = this.companyService.getCompanyList(searchModel);
        ArrayList<CompanyBaseInfoModel> data = new ArrayList<CompanyBaseInfoModel>();
        list.forEach(company -> {
            CompanyBaseInfoModel companyModel = this.companyBaseInfoModelUtil.company2model((Company)company);
            data.add(companyModel);
        });
        return data;
    }

    public List<CompanyPlatformAdminListModel> getCompanyList(CompanyPlatformAdminSearchModel searchModel) {
        List<CompanyPlatformAdminListModel> list = this.companyPlatformAdminService.getCompanyList(searchModel);
        return list;
    }

    public PageInfo<CompanyPlatformAdminListModel> getCompanyListByGridParam(CompanyPlatformAdminSearchModel searchModel) {
        if (searchModel.getAreaId() != null) {
            SysArea area = this.areaService.getAreaById(searchModel.getAreaId());
            searchModel.setLevel(area != null ? Integer.valueOf(2 * area.getLevel()) : null);
        }
        PageHelper.startPage((int)searchModel.getPageNum(), (int)searchModel.getPageSize());
        List<CompanyPlatformAdminListModel> list = this.getCompanyList(searchModel);
        PageInfo page = new PageInfo(list);
        return page;
    }

    @Transactional(readOnly=false)
    public void saveCompanyPlatformAdmin(CompanyModel companyModel, Long updateBy) {
        if (companyModel == null) {
            return;
        }
        CompanyModel record = this.getCompanyPlatformAdminModelById(companyModel.getCompanyBaseModel().getId());
        Company company = CompanyPlatformAdminModelUtil.transformToCompany(companyModel.getCompanyBaseModel());
        CompanyGovern companyGovern = CompanyPlatformAdminModelUtil.transformToCompanyGovern(companyModel.getCompanyGovernModel());
        CompanyPlatform companyPlatform = CompanyPlatformAdminModelUtil.transformToCompanyPlatform(companyModel.getCompanyPlatformModel());
        CompanyPlatformAdmin companyPlatformAdmin = CompanyPlatformAdminModelUtil.transformToCompanyPlatformAdmin(companyModel.getCompanyPlatformAdminModel());
        CompanySupervise companySupervise = CompanyPlatformAdminModelUtil.transformToCompanySupervise(companyModel.getCompanySuperviseModel());
        if (company != null && company.getId() != null) {
            this.companyService.update(company, updateBy);
        }
        if (record.getCompanyGovernModel() != null) {
            if (companyGovern != null && companyGovern.getId() == null) {
                throw new ServiceException("\u4f01\u4e1a\u653f\u5e9c\u4fe1\u606fid\u4e3a\u7a7a\uff01");
            }
            if (companyGovern != null && companyGovern.getId() != null) {
                companyGovern.setCid(null);
                this.companyGovernService.update(companyGovern, updateBy);
            }
        } else {
            this.companyGovernService.add(companyGovern, updateBy);
        }
        if (record.getCompanyPlatformModel() != null) {
            if (companyPlatform != null && companyPlatform.getId() == null) {
                throw new ServiceException("\u4f01\u4e1a\u5e73\u53f0\u4fe1\u606fid\u4e3a\u7a7a\uff01");
            }
            if (companyPlatform != null && companyPlatform.getId() != null) {
                companyPlatform.setCid(null);
                this.companyPlatformService.update(companyPlatform, updateBy);
            }
        } else {
            this.companyPlatformService.add(companyPlatform, updateBy);
        }
        if (record.getCompanyPlatformAdminModel() != null) {
            if (companyPlatformAdmin != null && companyPlatformAdmin.getId() == null) {
                throw new ServiceException("\u4f01\u4e1a\u8fd0\u8425\u540e\u53f0\u4fe1\u606fid\u4e3a\u7a7a\uff01");
            }
            if (companyPlatformAdmin != null && companyPlatformAdmin.getId() != null) {
                companyPlatformAdmin.setCid(null);
                this.companyPlatformAdminService.update(companyPlatformAdmin, updateBy);
            }
        } else {
            this.companyPlatformAdminService.add(companyPlatformAdmin, updateBy);
        }
        if (record.getCompanySuperviseModel() != null) {
            if (companySupervise != null && companySupervise.getId() == null) {
                throw new ServiceException("\u4f01\u4e1a\u804c\u4e1a\u5065\u5eb7\u4fe1\u606fid\u4e3a\u7a7a\uff01");
            }
            if (companySupervise != null && companySupervise.getId() != null) {
                companySupervise.setCid(null);
                this.companySuperviseService.update(companySupervise, updateBy);
            }
        } else {
            this.companySuperviseService.add(companySupervise, updateBy);
        }
    }

    @Transactional(readOnly=false)
    public void save(CompanyPlatformAdminModel companyPlatformAdminModel, Long updateBy) {
        if (companyPlatformAdminModel == null) {
            return;
        }
        CompanyPlatformAdmin companyPlatformAdmin = CompanyPlatformAdminModelUtil.transformToCompanyPlatformAdmin(companyPlatformAdminModel);
        if (companyPlatformAdmin == null) {
            return;
        }
        if (companyPlatformAdmin.getId() != null) {
            this.companyPlatformAdminService.update(companyPlatformAdmin, updateBy);
        }
    }

    @Transactional(readOnly=false)
    public void saveRemark(CompanyPlatformAdminModel companyPlatformAdminModel, Long updateBy) {
        if (companyPlatformAdminModel == null) {
            throw new ServiceException("\u6570\u636e\u5f02\u5e38\uff01");
        }
        if (companyPlatformAdminModel.getIdArr() == null || companyPlatformAdminModel.getIdArr().length <= 0) {
            throw new ServiceException("\u52fe\u9009\u7684\u4f01\u4e1aidArr\u4e3a\u7a7a\uff01");
        }
        Long[] idArr = companyPlatformAdminModel.getIdArr();
        if (idArr.length >= 0) {
            int i = 0;
            while (i < idArr.length) {
                try {
                    companyPlatformAdminModel.setId(idArr[i]);
                    this.save(companyPlatformAdminModel, updateBy);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    @Transactional(readOnly=false)
    public void saveIsAdminAdd(CompanyPlatformAdminModel companyPlatformAdminModel, Long updateBy) {
        if (companyPlatformAdminModel == null) {
            throw new ServiceException("\u6570\u636e\u5f02\u5e38\uff01");
        }
        if (companyPlatformAdminModel.getIdArr() == null || companyPlatformAdminModel.getIdArr().length <= 0) {
            throw new ServiceException("\u52fe\u9009\u7684\u4f01\u4e1aidArr\u4e3a\u7a7a\uff01");
        }
        Long[] idArr = companyPlatformAdminModel.getIdArr();
        if (idArr.length >= 0) {
            int i = 0;
            while (i < idArr.length) {
                try {
                    companyPlatformAdminModel.setId(idArr[i]);
                    this.save(companyPlatformAdminModel, updateBy);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++i;
            }
        }
    }
}

