/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.provider;

import cn.smarthse.modules.datacentre.entity.CompanyGovern;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.datacentre.enums.GovernIndustryCategoryParentCodeEnum;
import cn.smarthse.modules.datacentre.model.CompanyGovernModel;
import cn.smarthse.modules.datacentre.model.platform.CompanyPlatformModel;
import cn.smarthse.modules.datacentre.provider.ICompanyGovernProvideService;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideService;
import cn.smarthse.modules.datacentre.service.ICompanyGovernService;
import cn.smarthse.modules.datacentre.service.system.ISysAreaService;
import cn.smarthse.modules.datacentre.service.system.ISysParamService;
import cn.smarthse.modules.platform.core.framework.utils.NumberUtil;
import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import com.alibaba.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Service(version="1.0.0")
@Transactional(readOnly=true)
public class CompanyGovernProvideServiceImpl
implements ICompanyGovernProvideService {
    @Autowired
    private ICompanyProvideService companyProvideService;
    @Autowired
    private ICompanyGovernService companyGovernService;
    @Autowired
    private ISysParamService sysParamService;
    @Autowired
    private ISysAreaService areaService;

    public CompanyGovernModel getCompanyGovern(Long cid, Integer governYear) {
        CompanyGovern govern = this.companyGovernService.getGovern(cid, governYear);
        CompanyGovernModel governModel = new CompanyGovernModel();
        if (govern != null) {
            governModel.setCid(govern.getCid());
            governModel.setGovernYear(govern.getGovernYear());
            governModel.setName(govern.getName());
            governModel.setProvinceId(govern.getProvinceId());
            governModel.setProvinceName(this.areaService.getNameById(govern.getProvinceId()));
            governModel.setCityId(govern.getCityId());
            governModel.setCityName(this.areaService.getNameById(govern.getCityId()));
            governModel.setAreaId(govern.getAreaId());
            governModel.setAreaName(this.areaService.getNameById(govern.getAreaId()));
            governModel.setStreetId(govern.getStreetId());
            governModel.setStreetName(this.areaService.getNameById(govern.getStreetId()));
            governModel.setWorkAddress(govern.getWorkAddress());
            governModel.setScale(govern.getScale());
            if (StringUtils.isNotEmpty((String)govern.getScale()) && NumberUtil.isNumber((String)govern.getScale())) {
                Integer scale = NumberUtil.toInt((String)govern.getScale());
                String scaleName = CompanySizeEnum.getName((Integer)scale);
                governModel.setScaleName(scaleName);
            }
            governModel.setRegisterType(govern.getRegisterType());
            governModel.setRegisterTypeName(this.sysParamService.getParamValue(govern.getRegisterType()));
            governModel.setIndustryCategory(govern.getIndustryCategory());
            governModel.setIndustryCategoryCode(govern.getIndustryCategoryCode());
            governModel.setIndustryCategoryName(this.sysParamService.getParamValue(govern.getIndustryCategory()));
            governModel.setIsIndustryCategoryB(govern.getIsIndustryCategoryB());
            governModel.setStaffCount(govern.getStaffCount());
            governModel.setDustHarmsCount(govern.getDustHarmsCount());
            governModel.setIsOdiDeclareReport(govern.getIsOdiDeclareReport());
            governModel.setIsOdiDeclareCheck(govern.getIsOdiDeclareCheck());
            governModel.setDustFcHarmsCount(govern.getDustFcHarmsCount());
            governModel.setIsHrManager(govern.getIsHrManager());
            governModel.setIsHrStaff(govern.getIsHrStaff());
            governModel.setIsHrWorker(govern.getIsHrWorker());
            governModel.setReportName(govern.getReportName());
            governModel.setReportMobile(govern.getReportMobile());
        } else {
            CompanyPlatformModel companyModel = this.companyProvideService.getCompanyBaseInfoById(cid);
            governModel = new CompanyGovernModel();
            governModel.setName(companyModel.getName());
            governModel.setProvinceId(companyModel.getProvinceId());
            governModel.setProvinceName(companyModel.getProvinceName());
            governModel.setCityId(companyModel.getCityId());
            governModel.setCityName(companyModel.getCityName());
            governModel.setAreaId(companyModel.getAreaId());
            governModel.setAreaName(companyModel.getAreaName());
            governModel.setStreetId(companyModel.getStreetId());
            governModel.setStreetName(companyModel.getStreetName());
            governModel.setWorkAddress(companyModel.getWorkAddress());
            governModel.setScale(companyModel.getScale());
            if (StringUtils.isNotEmpty((String)companyModel.getScale()) && NumberUtil.isNumber((String)companyModel.getScale())) {
                Integer scale = NumberUtil.toInt((String)companyModel.getScale());
                String scaleName = CompanySizeEnum.getName((Integer)scale);
                governModel.setScaleName(scaleName);
            }
            governModel.setRegisterType(companyModel.getRegisterType());
            governModel.setRegisterTypeName(companyModel.getRegisterTypeName());
            governModel.setIndustryCategory(companyModel.getIndustryCategory());
            governModel.setIndustryCategoryName(companyModel.getIndustryCategoryName());
            governModel.setStaffCount(companyModel.getStaffCount());
        }
        return governModel;
    }

    @Transactional(readOnly=false)
    public void replaceCompanyGovern(CompanyGovernModel governModel, Long updateBy) {
        CompanyGovern govern = this.companyGovernService.getGovern(governModel.getCid(), governModel.getGovernYear());
        if (govern == null) {
            govern = new CompanyGovern();
            govern.setCid(governModel.getCid());
            govern.setGovernYear(governModel.getGovernYear());
            govern.setDustFcHarmsCount(governModel.getDustFcHarmsCount());
            govern.setDustHarmsCount(governModel.getDustHarmsCount());
            govern.setIsHrManager(governModel.getIsHrManager());
            govern.setIsHrStaff(governModel.getIsHrStaff());
            govern.setIsHrWorker(governModel.getIsHrWorker());
            govern.setIsOdiDeclareCheck(governModel.getIsOdiDeclareCheck());
            govern.setIsOdiDeclareReport(governModel.getIsOdiDeclareReport());
            govern.setReportMobile(governModel.getReportMobile());
            govern.setReportName(governModel.getReportName());
            govern.setName(governModel.getName());
            govern.setProvinceId(governModel.getProvinceId());
            govern.setCityId(governModel.getCityId());
            govern.setAreaId(governModel.getAreaId());
            govern.setStreetId(governModel.getStreetId());
            govern.setWorkAddress(governModel.getWorkAddress());
            govern.setScale(governModel.getScale());
            govern.setRegisterType(governModel.getRegisterType());
            String registerTypeCode = this.sysParamService.getCodeById(governModel.getRegisterType());
            govern.setRegisterTypeCode(registerTypeCode);
            govern.setIndustryCategory(governModel.getIndustryCategory());
            String industryCategoryCode = this.sysParamService.getCodeById(governModel.getIndustryCategory());
            govern.setIsIndustryCategoryB(governModel.getIsIndustryCategoryB());
            govern.setIndustryCategoryCode(industryCategoryCode);
            String industryCategoryParentCode = GovernIndustryCategoryParentCodeEnum.getIndustryCategoryParentCode((String)industryCategoryCode, (Boolean)governModel.getIsIndustryCategoryB());
            govern.setIndustryCategoryParentCode(industryCategoryParentCode);
            govern.setStaffCount(governModel.getStaffCount());
            this.companyGovernService.add(govern, updateBy);
        } else {
            govern.setDustFcHarmsCount(governModel.getDustFcHarmsCount());
            govern.setDustHarmsCount(governModel.getDustHarmsCount());
            govern.setIsHrManager(governModel.getIsHrManager());
            govern.setIsHrStaff(governModel.getIsHrStaff());
            govern.setIsHrWorker(governModel.getIsHrWorker());
            govern.setIsOdiDeclareCheck(governModel.getIsOdiDeclareCheck());
            govern.setIsOdiDeclareReport(governModel.getIsOdiDeclareReport());
            govern.setReportMobile(governModel.getReportMobile());
            govern.setReportName(governModel.getReportName());
            govern.setName(governModel.getName());
            govern.setProvinceId(governModel.getProvinceId());
            govern.setCityId(governModel.getCityId());
            govern.setAreaId(governModel.getAreaId());
            govern.setStreetId(governModel.getStreetId());
            govern.setWorkAddress(governModel.getWorkAddress());
            govern.setScale(governModel.getScale());
            govern.setRegisterType(governModel.getRegisterType());
            String registerTypeCode = this.sysParamService.getCodeById(governModel.getRegisterType());
            govern.setRegisterTypeCode(registerTypeCode);
            govern.setIndustryCategory(governModel.getIndustryCategory());
            String industryCategoryCode = this.sysParamService.getCodeById(governModel.getIndustryCategory());
            govern.setIsIndustryCategoryB(governModel.getIsIndustryCategoryB());
            govern.setIndustryCategoryCode(industryCategoryCode);
            String industryCategoryParentCode = GovernIndustryCategoryParentCodeEnum.getIndustryCategoryParentCode((String)industryCategoryCode, (Boolean)governModel.getIsIndustryCategoryB());
            govern.setIndustryCategoryParentCode(industryCategoryParentCode);
            govern.setStaffCount(governModel.getStaffCount());
            this.companyGovernService.updateByPrimaryKey(govern, updateBy);
        }
    }
}

