/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.bootstrap;

import cn.smarthse.modules.datacentre.bootstrap.properties.CacheProperties;
import cn.smarthse.modules.platform.core.framework.bootstrap.BaseConfiguration;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableCaching
@EnableConfigurationProperties(value={CacheProperties.class})
public class EhcacheConfig
extends BaseConfiguration {
    @Autowired
    private CacheProperties cacheProperties;

    @Bean(name={"ADMINCacheManager"})
    public CacheManager cacheManager() {
        this.logger.info("ADMINCacheManager Init");
        CacheConfiguration defaultCacheConfiguration = new CacheConfiguration();
        defaultCacheConfiguration.setMemoryStoreEvictionPolicy("LRU");
        defaultCacheConfiguration.setMaxEntriesLocalHeap(1000L);
        this.logger.info("ADMINCacheManager Init  Add Cache : {}", (Object)this.cacheProperties.getSysparamCache());
        CacheConfiguration sysParamCache = new CacheConfiguration();
        sysParamCache.setName(this.cacheProperties.getSysparamCache());
        sysParamCache.setMemoryStoreEvictionPolicy("LRU");
        sysParamCache.setMaxEntriesLocalHeap(1000L);
        sysParamCache.setTimeToIdleSeconds((long)this.cacheProperties.getSysparamCacheTimeToIdleSeconds().intValue());
        this.logger.info("ADMINCacheManager Init  Add Cache : {}", (Object)this.cacheProperties.getSysareaCache());
        CacheConfiguration sysAreaCache = new CacheConfiguration();
        sysAreaCache.setName(this.cacheProperties.getSysareaCache());
        sysAreaCache.setMemoryStoreEvictionPolicy("LRU");
        sysAreaCache.setMaxEntriesLocalHeap(1000L);
        sysAreaCache.setTimeToIdleSeconds((long)this.cacheProperties.getSysareaCacheTimeToIdleSeconds().intValue());
        net.sf.ehcache.config.Configuration config = new net.sf.ehcache.config.Configuration();
        config.setDefaultCacheConfiguration(defaultCacheConfiguration);
        config.addCache(sysParamCache);
        config.addCache(sysAreaCache);
        return CacheManager.newInstance((net.sf.ehcache.config.Configuration)config);
    }
}

