/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.bootstrap;

import cn.smarthse.modules.datacentre.bootstrap.properties.DubboProperties;
import cn.smarthse.modules.platform.core.framework.bootstrap.BaseConfiguration;
import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ConsumerConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.spring.context.annotation.DubboComponentScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@DubboComponentScan(value={"cn.smarthse.modules.datacentre.provider"})
@EnableConfigurationProperties(value={DubboProperties.class})
public class DubboProviderConfiguration
extends BaseConfiguration {
    @Autowired
    private DubboProperties properties;

    @Bean(value={"dubbo-annotation-provider"})
    public ApplicationConfig applicationConfig() {
        this.logger.info("\u914d\u7f6e ApplicationConfig {}", (Object)this.properties.getApplication_name());
        ApplicationConfig applicationConfig = new ApplicationConfig();
        applicationConfig.setName(this.properties.getApplication_name());
        return applicationConfig;
    }

    @Bean(value={"local_zookeeper"})
    public RegistryConfig registryConfig() {
        this.logger.info("\u914d\u7f6e \u5e73\u53f0\u672c\u5730\u670d\u52a1RegistryConfig:local_zookeeper {}", (Object)this.properties.getLocal_zookeeper_address());
        RegistryConfig registryConfig = new RegistryConfig();
        registryConfig.setProtocol("zookeeper");
        registryConfig.setAddress(this.properties.getLocal_zookeeper_address());
        StringBuffer file = new StringBuffer("output/").append(this.properties.getApplication_name()).append("_local.cache");
        registryConfig.setFile(file.toString());
        registryConfig.setDefault(Boolean.valueOf(true));
        return registryConfig;
    }

    @Bean(value={"dubbo"})
    public ProtocolConfig protocolConfig() {
        this.logger.info("\u914d\u7f6e ProtocolConfig port: {} ", (Object)this.properties.getZookeeper_application_protocol_port());
        ProtocolConfig protocolConfig = new ProtocolConfig();
        protocolConfig.setName(this.properties.getZookeeper_application_protocol_name());
        protocolConfig.setPort(Integer.valueOf(this.properties.getZookeeper_application_protocol_port()));
        protocolConfig.setPayload(Integer.valueOf(188388608));
        if (StringUtils.isNotEmpty((String)this.properties.getZookeeper_application_protocol_host())) {
            protocolConfig.setHost(this.properties.getZookeeper_application_protocol_host());
        }
        return protocolConfig;
    }

    @Bean
    public ConsumerConfig consumerConfig() {
        this.logger.info("\u914d\u7f6e ConsumerConfig");
        ConsumerConfig consumerConfig = new ConsumerConfig();
        consumerConfig.setCheck(Boolean.valueOf(this.properties.isConsumer_Check()));
        consumerConfig.setTimeout(Integer.valueOf(this.properties.getConsumer_Timeout()));
        return consumerConfig;
    }
}

