/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.bootstrap;

import cn.smarthse.modules.datacentre.bootstrap.properties.DatabaseProperties;
import cn.smarthse.modules.platform.core.framework.bootstrap.BaseConfiguration;
import com.alibaba.druid.pool.DruidDataSource;
import java.io.IOException;
import javax.sql.DataSource;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@EnableConfigurationProperties(value={DatabaseProperties.class})
public class DatabaseConfiguration
extends BaseConfiguration {
    @Autowired
    private DatabaseProperties dbproperties;

    @Bean(value={"dataSource"})
    public DruidDataSource getDruidDataSource() {
        this.logger.info("\u914d\u7f6e  dataSource jdbc_url={}", (Object)this.dbproperties.getUrl());
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setDriverClassName(this.dbproperties.getDriverClassName());
        dataSource.setUrl(this.dbproperties.getUrl());
        dataSource.setUsername(this.dbproperties.getUsername());
        dataSource.setPassword(this.dbproperties.getPassword());
        dataSource.setInitialSize(this.dbproperties.getPool_init());
        dataSource.setMinIdle(this.dbproperties.getPool_minIdle());
        dataSource.setMaxActive(this.dbproperties.getPool_maxActive());
        dataSource.setMaxWait(60000L);
        dataSource.setTimeBetweenEvictionRunsMillis(60000L);
        dataSource.setMinEvictableIdleTimeMillis(300000L);
        dataSource.setPoolPreparedStatements(true);
        dataSource.setMaxPoolPreparedStatementPerConnectionSize(20);
        return dataSource;
    }

    @Bean(value={"sqlSessionFactory"})
    public SqlSessionFactoryBean getSqlSessionFactory(@Qualifier(value="dataSource") DataSource dataSource) throws IOException {
        this.logger.info("\u914d\u7f6e SqlSessionFactoryBean");
        SqlSessionFactoryBean sqlSessionFactory = new SqlSessionFactoryBean();
        sqlSessionFactory.setConfigLocation((Resource)new ClassPathResource("mybatis/sqlMapConfig.xml"));
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        sqlSessionFactory.setMapperLocations(resolver.getResources("mybatis_mapper/mapper/**/*Mapper.xml"));
        sqlSessionFactory.setDataSource(dataSource);
        sqlSessionFactory.setTypeAliasesPackage("cn.smarthse.modules.datacentre.model.*");
        return sqlSessionFactory;
    }

    @Bean(value={"transactionManager"})
    public DataSourceTransactionManager getDataSourceTransactionManager(@Qualifier(value="dataSource") DataSource dataSource) {
        this.logger.info("\u914d\u7f6e  \u5b9a\u4e49\u4e8b\u52a1");
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager();
        transactionManager.setDataSource(dataSource);
        return transactionManager;
    }
}

