/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.datacentre.bootstrap;

import cn.smarthse.modules.datacentre.bootstrap.properties.EmailProperties;
import cn.smarthse.modules.datacentre.bootstrap.properties.OssClientProperties;
import cn.smarthse.modules.datacentre.bootstrap.properties.SmtProperties;
import cn.smarthse.modules.datacentre.bootstrap.properties.SysconfigProperties;
import cn.smarthse.modules.datacentre.bootstrap.properties.TaskExecutorProperties;
import cn.smarthse.modules.datacentre.bootstrap.properties.WeixinTemplateProperties;
import cn.smarthse.modules.platform.core.framework.bean.OssClientBean;
import cn.smarthse.modules.platform.core.framework.bootstrap.BaseConfiguration;
import cn.smarthse.modules.platform.core.framework.mail.FreemarkerEmailServiceImpl;
import cn.smarthse.modules.platform.core.framework.utils.SpringContextHolder;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.ui.freemarker.FreeMarkerConfigurationFactoryBean;

@Configuration
@EnableAsync
@EnableScheduling
@ComponentScan(basePackages={"cn.smarthse.modules.datacentre"})
@EnableConfigurationProperties(value={OssClientProperties.class, TaskExecutorProperties.class, EmailProperties.class, WeixinTemplateProperties.class, SmtProperties.class, SysconfigProperties.class})
public class ContentConfiguration
extends BaseConfiguration {
    @Autowired
    private OssClientProperties ossClientProperties;
    @Autowired
    private TaskExecutorProperties taskExecutorProperties;
    @Autowired
    private EmailProperties emailProperties;

    @Bean(name={"ossclient"})
    public OssClientBean getOssClientBean() {
        this.logger.info("\u914d\u7f6eOssClientBean {}", (Object)this.ossClientProperties.getOss_bucketname());
        OssClientBean ossClientBean = new OssClientBean();
        ossClientBean.setEndpoint(this.ossClientProperties.getOss_endpoint());
        ossClientBean.setAccessKeyId(this.ossClientProperties.getOss_accesskey());
        ossClientBean.setAccessKeySecret(this.ossClientProperties.getOss_accesssecret());
        ossClientBean.setBucketName(this.ossClientProperties.getOss_bucketname());
        ossClientBean.setAsynch(this.ossClientProperties.isOss_asynch());
        return ossClientBean;
    }

    @Bean(value={"emailTemplate"})
    public JavaMailSenderImpl getJavaMailSenderImpl() {
        this.logger.info("\u914d\u7f6e JavaMailSenderImpl {}", (Object)this.emailProperties);
        JavaMailSenderImpl emailTemplate = new JavaMailSenderImpl();
        emailTemplate.setDefaultEncoding(this.emailProperties.getDefaultEncoding());
        emailTemplate.setHost(this.emailProperties.getHost());
        emailTemplate.setPort(this.emailProperties.getPort());
        emailTemplate.setUsername(this.emailProperties.getUsername());
        emailTemplate.setPassword(this.emailProperties.getPassword());
        Properties javaMailProperties = new Properties();
        javaMailProperties.setProperty("mail.smtp.auth", "true");
        javaMailProperties.setProperty("mail.smtp.timeout", "25000");
        javaMailProperties.put("mail.smtp.starttls.enable", (Object)true);
        javaMailProperties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        emailTemplate.setJavaMailProperties(javaMailProperties);
        return emailTemplate;
    }

    @Bean
    public AsyncTaskExecutor taskExecutor() {
        this.logger.info("\u914d\u7f6eAsyncTaskExecutor");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("PlatformService-Executor");
        executor.setCorePoolSize(this.taskExecutorProperties.getCore_pool_size());
        executor.setMaxPoolSize(this.taskExecutorProperties.getMax_pool_size());
        executor.setQueueCapacity(this.taskExecutorProperties.getQueue_capacity());
        executor.setKeepAliveSeconds(this.taskExecutorProperties.getKeep_alive_seconds());
        executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            }
        });
        executor.initialize();
        return executor;
    }

    @Bean(value={"freeMarkerConfiguration"})
    public FreeMarkerConfigurationFactoryBean getFreeMarkerConfiguration() {
        this.logger.info("\u914d\u7f6e FreeMarkerConfigurationFactoryBean ");
        FreeMarkerConfigurationFactoryBean freeMarkerConfiguration = new FreeMarkerConfigurationFactoryBean();
        freeMarkerConfiguration.setPreferFileSystemAccess(false);
        freeMarkerConfiguration.setDefaultEncoding("UTF-8");
        freeMarkerConfiguration.setTemplateLoaderPath("classpath:templates/email");
        Properties freemarkerSettings = new Properties();
        freemarkerSettings.setProperty("localized_lookup", "false");
        freemarkerSettings.setProperty("template_update_delay", "5");
        freemarkerSettings.setProperty("cache_storage", "strong:20, soft:20");
        freemarkerSettings.setProperty("url_escaping_charset", "UTF-8");
        freemarkerSettings.setProperty("output_encoding", "UTF-8");
        return freeMarkerConfiguration;
    }

    @Bean
    public FreemarkerEmailServiceImpl getFreemarkerEmailServiceImpl() {
        this.logger.info("\u914d\u7f6eEmail FreemarkerEmailServiceImpl ");
        FreemarkerEmailServiceImpl emailService = new FreemarkerEmailServiceImpl();
        return emailService;
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }
}

