/*后台管理系统用户表 邓力宾 2020-03-16*/
drop table if exists `admin_user`;
CREATE TABLE admin_user(
  id INT auto_increment primary key comment 'id 自增',
  username varchar(64)  not null comment '账号',
  password varchar(64) not null comment '密码',
  name varchar(128) not null default '-' comment '姓名',
  role int not null default 2 comment  '角色 1：管理员 2：普通用户',
  contact varchar(64) not null default '-' comment  '联系方式',
  create_date datetime not null default now() comment '创建时间',
  create_by int not null default 0 comment '创建人id',
  update_date datetime not null default now() comment '更新时间',
  update_by int not null default  0 comment '更新人id',
  is_valid  bool not null default  true comment '是否可用'
)ENGINE=INNODB AUTO_INCREMENT=1 DEFAULT CHARSET utf8 comment '后台管理系统-用户表';

/*查询系统操作日志表*/
drop table if exists `query_log`;
CREATE TABLE `query_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(200) DEFAULT NULL COMMENT '日志标题',
  `remote_ip` varchar(45) DEFAULT NULL COMMENT '请求IP地址',
  `user_agent` varchar(500) DEFAULT NULL COMMENT '用户代理信息',
  `request_uri` varchar(255) DEFAULT NULL COMMENT '请求URI',
  `request_method` varchar(100) DEFAULT NULL COMMENT '操作方式、post/get等resetful',
  `is_valid` bit(1) DEFAULT b'1' COMMENT '是否有效（0-无效，1-有效）',
  `type` tinyint(4) DEFAULT '2' COMMENT '类型(1-点击日志,2-操作日志）',
  `params` text COMMENT '操作提交的数据内容(json)或者异常信息',
  `create_by` bigint(20) unsigned DEFAULT NULL COMMENT '创建人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) unsigned DEFAULT NULL COMMENT '最后修改人ID',
  `update_date` datetime DEFAULT NULL COMMENT '最后修改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=905 DEFAULT CHARSET=utf8mb4 COMMENT='记录企业操作记录（登录、修改或者新增企业业务记录）';

/*后台日志表*/
drop table if exists `admin_log`;
create table admin_log
(
  id  bigint unsigned primary key auto_increment comment 'ID',
  type   int not null default 2  comment '1：登录日志 2：操作日志',
  username varchar(64) not null default '-' comment '账号',
  name varchar(128) not null default '-' comment '姓名',
  remote_ip      varchar(45)  default  null comment '请求IP地址',
  todo_target int not null default 1 comment '操作目标 1：账号 2：物质',
  target_id bigint not null default 0 comment  '目标id（账号id或物质id）',
  todo_type int not null  default 3 comment '操作类型: 1:登录 2：新增 3：编辑 4：删除',
  content varchar(1024) not null default '-' comment '操作内容',
  create_by      bigint unsigned    not null default 0 comment '创建人',
  create_date    datetime            not null default now() comment '创建时间',
  update_by      bigint unsigned     not null default 0 comment '最后修改人ID',
  update_date    datetime            not null default now() comment '最后修改时间',
  is_valid bool not null default 1 comment '是否有效'
)
  comment '后台操作日志';

/*化学毒物修改日志表*/
drop table if exists `chemical_edit_log`;
CREATE TABLE `chemical_edit_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `chemical_id` bigint(20) DEFAULT NULL COMMENT '毒物id',
  `params` text COMMENT '操作提交的数据内容(json)或者异常信息',
  `is_valid` bit(1) DEFAULT b'1' COMMENT '是否有效（0-无效，1-有效）',
  `create_by` bigint(20) unsigned DEFAULT NULL COMMENT '创建人',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` bigint(20) unsigned DEFAULT NULL COMMENT '最后修改人ID',
  `update_date` datetime DEFAULT NULL COMMENT '最后修改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=634 DEFAULT CHARSET=utf8mb4 COMMENT='化学毒物更新记录';

/*添加角色*/
alter table admin_user  MODIFY COLUMN role int NOT NULL default 2 COMMENT '角色 0:超级管理员 1：管理员 2：普通用户';
/*添加一个超级管理员 密码123123*/
insert into admin_user(id, username, password, name, role) values(100, 'superuser', '$2a$10$p6C1V0jT6iJ.7j.0xBcQS.zUJOiy3U0ZbsZbXEwdzlApxXwx5NcLm', '超级管理员',0);

alter table chemical_nature modify id bigint auto_increment ;
alter table potection_first_aid modify id bigint auto_increment ;
