/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.chemical.facade.model;

import cn.smarthse.chemical.facade.enums.StatusCodeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="\u63a5\u53e3\u7edf\u4e00\u8fd4\u56de\u5bf9\u8c61")
public class ResponseData<T> {
    @ApiModelProperty(value="\u7ed3\u679c\u7801", required=true, example="1")
    private Integer code;
    @ApiModelProperty(value="\u63d0\u793a\u4fe1\u606f", required=false)
    private String msg;
    @ApiModelProperty(value="\u7ed3\u679c\u6570\u636e", required=false)
    private T data;

    private ResponseData(StatusCodeEnum codeEnum, T data) {
        this.code = codeEnum.getCode();
        this.msg = codeEnum.getMsg();
        this.data = data;
    }

    private ResponseData(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static <W> ResponseData<W> success(W data) {
        return new ResponseData<W>(StatusCodeEnum.SUCCESS, data);
    }

    public static <T> ResponseData<T> fail(String msg) {
        return new ResponseData<Object>(StatusCodeEnum.FAIL.getCode(), msg, null);
    }

    public static ResponseData<Object> serverError() {
        return new ResponseData<Object>(StatusCodeEnum.SERVER_ERROR, null);
    }

    public static ResponseData<Object> requestError() {
        return new ResponseData<Object>(StatusCodeEnum.REQUEST_ERROR, null);
    }

    public static <T> ResponseData<T> requestError(String msg) {
        return new ResponseData<Object>(StatusCodeEnum.REQUEST_ERROR.getCode(), msg, null);
    }

    public static ResponseData<Object> forbiddenError() {
        return new ResponseData<Object>(StatusCodeEnum.FORBIDDEN_ERROR, null);
    }

    public static ResponseData<Object> forceOffline() {
        return new ResponseData<Object>(StatusCodeEnum.FORCE_OFFLINE, null);
    }

    public static ResponseData<Object> invalidSession() {
        return new ResponseData<Object>(StatusCodeEnum.INVALID_SESSION, null);
    }

    public static ResponseData<Object> loginFail() {
        return new ResponseData<Object>(StatusCodeEnum.FAIL.getCode(), "\u767b\u9646\u5931\u8d25\u8bf7\u68c0\u67e5\u7528\u6237\u540d\u5bc6\u7801", null);
    }

    public static ResponseData<Object> verCodeError() {
        return new ResponseData<Object>(StatusCodeEnum.FAIL.getCode(), "\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u5df2\u5931\u6548", null);
    }

    public static ResponseData<Object> noLogin() {
        return new ResponseData<Object>(StatusCodeEnum.NO_LOGIN, null);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseData)) {
            return false;
        }
        ResponseData other = (ResponseData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseData(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

