/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.chemical.common.util;

import cn.smarthse.chemical.common.util.StringUtils;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;

public class PinyinUtil {
    public static String getFirstSpellCnOrEnStr(String str) {
        if (StringUtils.isBlank((String)str)) {
            return "";
        }
        char[] cl_chars = str.trim().toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        try {
            char[] cArray = cl_chars;
            int n = cl_chars.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                String firstStr = String.valueOf(c);
                if (firstStr.matches("[\u4e00-\u9fa5]+")) {
                    return PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)defaultFormat)[0].substring(0, 1);
                }
                if (firstStr.matches("[a-zA-Z]+")) {
                    return firstStr.toUpperCase();
                }
                ++n2;
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void main(String[] args) {
        System.out.println(PinyinUtil.getFirstSpellCnOrEnStr("\u6d4b\u8bd5"));
        System.out.println(PinyinUtil.getFirstSpellCnOrEnStr("\u8bd5"));
        System.out.println(PinyinUtil.getFirstSpellCnOrEnStr("111\u8bd5\u9519"));
        System.out.println(PinyinUtil.getFirstSpellCnOrEnStr("aaa\u8bd5"));
        System.out.println(PinyinUtil.getFirstSpellCnOrEnStr("111"));
        System.out.println(PinyinUtil.getFirstSpellCnOrEnStr("111bb"));
        System.out.println(PinyinUtil.getFirstSpellCnOrEnStr("aaa"));
        System.out.println(PinyinUtil.getFirstSpellCnOrEnStr("11@1&*1p\u7684"));
        System.out.println(PinyinUtil.getFirstSpellCnOrEnStr("111bab"));
        System.out.println(PinyinUtil.getFirstSpellCnOrEnStr("\u4e00aaa"));
    }
}

