/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.chemical.common.util;

public class HashUtils {
    private static final int R1_32 = 15;
    private static final int R2_32 = 13;
    private static final int M_32 = 5;
    private static final int N_32 = -430675100;
    private static final int C1_32 = -862048943;
    private static final int C2_32 = 461845907;
    private static final int DEFAULT_SEED = 0;

    public static int additiveHash(String key, int prime) {
        int hash = key.length();
        int i = 0;
        while (i < key.length()) {
            hash += key.charAt(i);
            ++i;
        }
        return hash % prime;
    }

    public static int rotatingHash(String key, int prime) {
        int hash = key.length();
        int i = 0;
        while (i < key.length()) {
            hash = hash << 4 ^ hash >> 28 ^ key.charAt(i);
            ++i;
        }
        return hash % prime;
    }

    public static int oneByOneHash(String key) {
        int hash = 0;
        int i = 0;
        while (i < key.length()) {
            hash += key.charAt(i);
            hash += hash << 10;
            hash ^= hash >> 6;
            ++i;
        }
        hash += hash << 3;
        hash ^= hash >> 11;
        hash += hash << 15;
        return hash;
    }

    public static int bernstein(String key) {
        int hash = 0;
        int i = 0;
        while (i < key.length()) {
            hash = 33 * hash + key.charAt(i);
            ++i;
        }
        return hash;
    }

    public static int universal(char[] key, int mask, int[] tab) {
        int hash = key.length;
        int len = key.length;
        int i = 0;
        while (i < len << 3) {
            char k = key[i >> 3];
            if ((k & '\u0001') == 0) {
                hash ^= tab[i + 0];
            }
            if ((k & 2) == 0) {
                hash ^= tab[i + 1];
            }
            if ((k & 4) == 0) {
                hash ^= tab[i + 2];
            }
            if ((k & 8) == 0) {
                hash ^= tab[i + 3];
            }
            if ((k & 0x10) == 0) {
                hash ^= tab[i + 4];
            }
            if ((k & 0x20) == 0) {
                hash ^= tab[i + 5];
            }
            if ((k & 0x40) == 0) {
                hash ^= tab[i + 6];
            }
            if ((k & 0x80) == 0) {
                hash ^= tab[i + 7];
            }
            i += 8;
        }
        return hash & mask;
    }

    public static int zobrist(char[] key, int mask, int[][] tab) {
        int hash = key.length;
        int i = 0;
        while (i < key.length) {
            hash ^= tab[i][key[i]];
            ++i;
        }
        return hash & mask;
    }

    public static int fnvHash(byte[] data) {
        int p = 16777619;
        int hash = -2128831035;
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hash = (hash ^ b) * 16777619;
            ++n2;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        hash += hash << 5;
        return hash;
    }

    public static int fnvHash(String data) {
        int p = 16777619;
        int hash = -2128831035;
        int i = 0;
        while (i < data.length()) {
            hash = (hash ^ data.charAt(i)) * 16777619;
            ++i;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        hash += hash << 5;
        return hash;
    }

    public static int intHash(int key) {
        key += ~(key << 15);
        key ^= key >>> 10;
        key += key << 3;
        key ^= key >>> 6;
        key += ~(key << 11);
        key ^= key >>> 16;
        return key;
    }

    public static int rsHash(String str) {
        int b = 378551;
        int a = 63689;
        int hash = 0;
        int i = 0;
        while (i < str.length()) {
            hash = hash * a + str.charAt(i);
            a *= b;
            ++i;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int jsHash(String str) {
        int hash = 1315423911;
        int i = 0;
        while (i < str.length()) {
            hash ^= (hash << 5) + str.charAt(i) + (hash >> 2);
            ++i;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int pjwHash(String str) {
        int bitsInUnsignedInt = 32;
        int threeQuarters = bitsInUnsignedInt * 3 / 4;
        int oneEighth = bitsInUnsignedInt / 8;
        int highBits = -1 << bitsInUnsignedInt - oneEighth;
        int hash = 0;
        int test = 0;
        int i = 0;
        while (i < str.length()) {
            test = (hash = (hash << oneEighth) + str.charAt(i)) & highBits;
            if (test != 0) {
                hash = (hash ^ test >> threeQuarters) & ~highBits;
            }
            ++i;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int elfHash(String str) {
        int hash = 0;
        int x = 0;
        int i = 0;
        while (i < str.length()) {
            x = (int)((long)(hash = (hash << 4) + str.charAt(i)) & 0xF0000000L);
            if (x != 0) {
                hash ^= x >> 24;
                hash &= ~x;
            }
            ++i;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int bkdrHash(String str) {
        int seed = 131;
        int hash = 0;
        int i = 0;
        while (i < str.length()) {
            hash = hash * seed + str.charAt(i);
            ++i;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int sdbmHash(String str) {
        int hash = 0;
        int i = 0;
        while (i < str.length()) {
            hash = str.charAt(i) + (hash << 6) + (hash << 16) - hash;
            ++i;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int djbHash(String str) {
        int hash = 5381;
        int i = 0;
        while (i < str.length()) {
            hash = (hash << 5) + hash + str.charAt(i);
            ++i;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int dekHash(String str) {
        int hash = str.length();
        int i = 0;
        while (i < str.length()) {
            hash = hash << 5 ^ hash >> 27 ^ str.charAt(i);
            ++i;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int apHash(String str) {
        int hash = 0;
        int i = 0;
        while (i < str.length()) {
            hash ^= (i & 1) == 0 ? hash << 7 ^ str.charAt(i) ^ hash >> 3 : ~(hash << 11 ^ str.charAt(i) ^ hash >> 5);
            ++i;
        }
        return hash;
    }

    public static long tianlHash(String str) {
        long hash = 0L;
        int iLength = str.length();
        if (iLength == 0) {
            return 0L;
        }
        hash = iLength <= 256 ? 0x1000000L * (long)(iLength - 1) : 0xFF000000L;
        if (iLength <= 96) {
            int i = 1;
            while (i <= iLength) {
                char ucChar = str.charAt(i - 1);
                if (ucChar <= 'Z' && ucChar >= 'A') {
                    ucChar = (char)(ucChar + 32);
                }
                hash += (long)((3 * i * ucChar * ucChar + 5 * i * ucChar + 7 * i + 11 * ucChar) % 0x1000000);
                ++i;
            }
        } else {
            int i = 1;
            while (i <= 96) {
                char ucChar = str.charAt(i + iLength - 96 - 1);
                if (ucChar <= 'Z' && ucChar >= 'A') {
                    ucChar = (char)(ucChar + 32);
                }
                hash += (long)((3 * i * ucChar * ucChar + 5 * i * ucChar + 7 * i + 11 * ucChar) % 0x1000000);
                ++i;
            }
        }
        if (hash < 0L) {
            hash *= -1L;
        }
        return hash;
    }

    public static int javaDefaultHash(String str) {
        int h = 0;
        int off = 0;
        int len = str.length();
        int i = 0;
        while (i < len) {
            h = 31 * h + str.charAt(off++);
            ++i;
        }
        return h;
    }

    public static long mixHash(String str) {
        long hash = str.hashCode();
        hash <<= 32;
        return hash |= (long)HashUtils.fnvHash(str);
    }

    public static int identityHashCode(Object obj) {
        return System.identityHashCode(obj);
    }

    public static int murmur32(byte[] data) {
        int length = data.length;
        int hash = 0;
        int nblocks = length >> 2;
        int i = 0;
        while (i < nblocks) {
            int i_4 = i << 2;
            int k = data[i_4] & 0xFF | (data[i_4 + 1] & 0xFF) << 8 | (data[i_4 + 2] & 0xFF) << 16 | (data[i_4 + 3] & 0xFF) << 24;
            k *= -862048943;
            k = Integer.rotateLeft(k, 15);
            hash ^= (k *= 461845907);
            hash = Integer.rotateLeft(hash, 13) * 5 + -430675100;
            ++i;
        }
        int idx = nblocks << 2;
        int k1 = 0;
        switch (length - idx) {
            case 3: {
                k1 ^= data[idx + 2] << 16;
            }
            case 2: {
                k1 ^= data[idx + 1] << 8;
            }
            case 1: {
                k1 ^= data[idx];
                k1 *= -862048943;
                k1 = Integer.rotateLeft(k1, 15);
                hash ^= (k1 *= 461845907);
            }
        }
        hash ^= length;
        hash ^= hash >>> 16;
        hash *= -2048144789;
        hash ^= hash >>> 13;
        hash *= -1028477387;
        hash ^= hash >>> 16;
        return hash;
    }

    public static long murmur64(byte[] data) {
        return HashUtils.hash64(data);
    }

    private static long hash64(byte[] data) {
        return 0L;
    }

    public static long[] murmur128(byte[] data) {
        return HashUtils.hash128(data);
    }

    private static long[] hash128(byte[] data) {
        return new long[0];
    }
}

