/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.busilog.interceptor;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.smarthse.busilog.interceptor.SqlTools;
import cn.smarthse.modules.busilog.RecordOperationLog;
import cn.smarthse.modules.busilog.RecordOperationTypeEnum;
import com.alibaba.dubbo.rpc.RpcContext;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class sensitiveDataInterceptorV2
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(sensitiveDataInterceptorV2.class);
    private String env;
    private boolean enable;
    private JdbcTemplate jdbcTemplate;
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private String catalog;
    private String dcCataLogName;
    private Map<String, Set<String>> interceptTabelFieldsMap = new HashMap<String, Set<String>>();

    public Object intercept(Invocation invocation) throws Throwable {
        if (this.enable) {
            this.doLog(invocation);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String[] keyArray;
        this.enable = Boolean.parseBoolean(properties.getProperty("enable"));
        this.env = properties.getProperty("env");
        String recordKeys = properties.getProperty("recordKeys");
        for (String key : keyArray = StringUtils.splitByWholeSeparator((String)recordKeys, (String)",")) {
            key = key.trim();
            int fieldNameIndex = StringUtils.lastIndexOf((CharSequence)key, (CharSequence)".");
            String table = key.substring(0, fieldNameIndex);
            String field = key.substring(fieldNameIndex + 1);
            this.interceptTabelFieldsMap.computeIfAbsent(table, v -> new HashSet()).add(field);
        }
    }

    public Set<String> getInterceptFields(String tableName) {
        if (MapUtils.isEmpty(this.interceptTabelFieldsMap)) {
            return null;
        }
        if (this.interceptTabelFieldsMap.containsKey(tableName)) {
            return this.interceptTabelFieldsMap.get(tableName);
        }
        if (!tableName.contains(".") && this.interceptTabelFieldsMap.containsKey(this.catalog + "." + tableName)) {
            return this.interceptTabelFieldsMap.get(this.catalog + "." + tableName);
        }
        return null;
    }

    public void handUpdate(Update update, List<RecordOperationLog> logList) {
        Table table = update.getTable();
        String tableName = table.getFullyQualifiedName();
        HashSet<String> updateEntryList = new HashSet<String>();
        HashMap<String, String> updateColumnMap = new HashMap<String, String>();
        for (UpdateSet updateSet : update.getUpdateSets()) {
            ArrayList columnList = updateSet.getColumns();
            ArrayList expressionList = updateSet.getExpressions();
            for (int i = 0; i < columnList.size(); ++i) {
                String key = ((Column)columnList.get(i)).getColumnName();
                updateEntryList.add(key);
                updateColumnMap.put(key, String.valueOf(expressionList.get(i)));
            }
        }
        Expression where = update.getWhere();
        Set<String> fields = this.getInterceptFields(tableName);
        if (CollUtil.isEmpty(fields)) {
            return;
        }
        updateEntryList.add("id");
        if (!Objects.equals("company", tableName)) {
            updateEntryList.add("cid");
        }
        Set entrySet = updateEntryList.stream().filter(fields::contains).collect(Collectors.toSet());
        if (CollUtil.isNotEmpty(entrySet)) {
            boolean irsChange = Boolean.TRUE.equals(Convert.toBool(RpcContext.getContext().getAttachments().get("irs_lead_to_change_business_state")));
            PlainSelect selectBefore = new PlainSelect();
            ArrayList<SelectExpressionItem> selectItemList = new ArrayList<SelectExpressionItem>();
            selectItemList.add(new SelectExpressionItem((Expression)new Column("*")));
            selectBefore.setSelectItems(selectItemList);
            selectBefore.setFromItem((FromItem)table);
            selectBefore.setWhere(update.getWhere());
            long current = System.currentTimeMillis();
            List beforeMapList = this.jdbcTemplate.queryForList(selectBefore.toString());
            for (Map beforeMap : beforeMapList) {
                for (String column : entrySet) {
                    String after;
                    String beforeStr = String.valueOf(beforeMap.getOrDefault(column, "-")).trim();
                    String afterStr = String.valueOf(updateColumnMap.getOrDefault(column, "-")).trim();
                    String before = beforeStr.replace("'", "").replace("\"", "");
                    if (Objects.equals(before, after = afterStr.replace("'", "").replace("\"", "")) || "null".equalsIgnoreCase(before) && "null".equalsIgnoreCase(after)) continue;
                    long cid = "company".equals(table.getName()) ? Convert.toLong(beforeMap.get("id"), (Long)Convert.toLong(beforeMap.get("ID"))) : Convert.toLong(beforeMap.get("cid"), (Long)Convert.toLong(beforeMap.get("CID")));
                    log.info("\u654f\u611f\u65e5\u5fd7\u62e6\u622a\uff0c\u8bb0\u5f55\u64cd\u4f5c\u53d8\u66f4\u4fe1\u606f::{}::{}::{}::{}->{}", new Object[]{tableName, cid, column, before, after});
                    String ip = (String)RpcContext.getContext().getAttachments().get("ip_addr");
                    String op = (String)RpcContext.getContext().getAttachments().get("operator_id");
                    String opName = (String)RpcContext.getContext().getAttachments().get("operator_name");
                    String sup = (String)RpcContext.getContext().getAttachments().get("sup_id");
                    String supName = (String)RpcContext.getContext().getAttachments().get("sup_name");
                    ip = Objects.equals(ip, "null") ? null : ip;
                    opName = Objects.equals(opName, "null") ? null : opName;
                    supName = Objects.equals(supName, "null") ? null : supName;
                    RecordOperationLog log = new RecordOperationLog();
                    log.setId(Long.valueOf(IdWorker.getId()));
                    log.setTableName(tableName);
                    log.setCompanyId(Long.valueOf(cid));
                    log.setChangeField(column);
                    log.setLogType(Integer.valueOf(1));
                    Byte busiType = Arrays.stream(RecordOperationTypeEnum.values()).filter(enu -> enu.getColumn().equalsIgnoreCase(column)).map(RecordOperationTypeEnum::getKey).findFirst().orElse(null);
                    log.setBusiType(busiType);
                    boolean businessStateChange = Objects.equals(busiType, RecordOperationTypeEnum.BUSI_TYPE_CHANGE.getKey());
                    boolean out = Objects.equals(after, "0");
                    if (businessStateChange && irsChange && out) {
                        log.setLogTitle("\u7531 " + before + " \u53d8\u66f4\u4e3a " + after + "\uff08\u5e02\u573a\u76d1\u7ba1\u6570\u636e\u4e2d\u8be5\u4f01\u4e1a\u5df2\u6ce8\u9500\uff09");
                    } else {
                        log.setLogTitle("\u7531 " + before + " \u53d8\u66f4\u4e3a " + after);
                    }
                    log.setBeforeInfo(before);
                    log.setAfterInfo(after);
                    log.setIp(ip);
                    log.setCreateBy(Convert.toLong((Object)op));
                    log.setCreateByName(opName);
                    log.setSupId(Convert.toLong((Object)sup));
                    log.setSupName(supName);
                    log.setTimestamp(Long.valueOf(current));
                    logList.add(log);
                }
            }
        }
    }

    public void handInsert(Insert insert, List<RecordOperationLog> logList, Object parameter) {
        Table table = insert.getTable();
        String tableName = table.getName();
        if (!"company".equalsIgnoreCase(tableName)) {
            return;
        }
        Set<String> fields = this.getInterceptFields(tableName);
        if (CollUtil.isEmpty(fields)) {
            return;
        }
        RpcContext context = RpcContext.getContext();
        String ip = (String)context.getAttachments().get("ip_addr");
        String op = (String)context.getAttachments().get("operator_id");
        String opName = (String)context.getAttachments().get("operator_name");
        String sup = (String)context.getAttachments().get("sup_id");
        String supName = (String)context.getAttachments().get("sup_name");
        ip = Objects.equals(ip, "null") ? null : ip;
        opName = Objects.equals(opName, "null") ? null : opName;
        supName = Objects.equals(supName, "null") ? null : supName;
        ArrayList<Map<String, Object>> insertMapList = new ArrayList<Map<String, Object>>();
        List columnList = insert.getColumns();
        ItemsList itemList = insert.getItemsList();
        ExpressionList expressionListBean = (ExpressionList)itemList;
        if (expressionListBean.isUsingBrackets()) {
            this.buildInsertMapList(insertMapList, columnList, expressionListBean);
        } else {
            expressionListBean.getExpressions().forEach(expression -> this.buildInsertMapList(insertMapList, columnList, ((RowConstructor)expression).getExprList()));
        }
        long current = System.currentTimeMillis();
        Byte busiType = sensitiveDataInterceptorV2.getBusiType(parameter);
        for (Map map : insertMapList) {
            Long cid = Convert.toLong(map.get("id"), (Long)Convert.toLong(map.get("ID")));
            String value = RecordOperationTypeEnum.getValue((Byte)busiType);
            log.info("\u654f\u611f\u65e5\u5fd7\u62e6\u622a\uff0c\u6570\u636e\u8868\u65b0\u589e\u884c::{}::{}::{}", new Object[]{tableName, cid, value});
            RecordOperationLog log = new RecordOperationLog();
            log.setId(Long.valueOf(IdWorker.getId()));
            log.setTableName(tableName);
            log.setCompanyId(cid);
            log.setLogTitle(value);
            log.setLogType(Integer.valueOf(3));
            log.setBusiType(busiType);
            log.setIp(ip);
            log.setCreateBy(Convert.toLong((Object)op));
            log.setCreateByName(opName);
            log.setSupId(Convert.toLong((Object)sup));
            log.setSupName(supName);
            log.setTimestamp(Long.valueOf(current));
            logList.add(log);
        }
    }

    private boolean simpleMatch(String orgiSql) throws JSQLParserException {
        if (StringUtils.contains((CharSequence)orgiSql, (CharSequence)";")) {
            return false;
        }
        Statement statement = CCJSqlParserUtil.parse((String)orgiSql);
        Table table = null;
        if (statement instanceof Update) {
            table = ((Update)statement).getTable();
        } else if (statement instanceof Insert) {
            table = ((Insert)statement).getTable();
        } else if (statement instanceof Delete) {
            table = ((Delete)statement).getTable();
        }
        if (table == null) {
            return false;
        }
        String orgiTableName = table.getFullyQualifiedName();
        boolean simpleMatch = this.interceptTabelFieldsMap.keySet().stream().anyMatch(tableName -> {
            if (StringUtils.equals((CharSequence)orgiTableName, (CharSequence)tableName)) {
                return true;
            }
            if (tableName.contains(".")) {
                return StringUtils.equals((CharSequence)orgiTableName, (CharSequence)tableName.split("\\.")[1]);
            }
            return false;
        });
        return simpleMatch;
    }

    private void doLog(Invocation invocation) throws SQLException {
        boolean skip = "true".equals(RpcContext.getContext().getAttachments().get("skip_sensitive_log"));
        if (skip) {
            return;
        }
        if (MapUtils.isEmpty(this.interceptTabelFieldsMap)) {
            return;
        }
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Configuration configuration = ms.getConfiguration();
        Properties variables = configuration.getVariables();
        if (StringUtils.isBlank((CharSequence)this.dcCataLogName)) {
            this.dcCataLogName = (String)variables.get("dcschema");
        }
        Object parameter = args[1];
        BoundSql boundSql = ms.getBoundSql(parameter);
        String orgiSql = boundSql.getSql();
        try {
            boolean b = this.simpleMatch(orgiSql);
            if (!b) {
                return;
            }
        }
        catch (JSQLParserException e) {
            log.error("binlog sql\u89e3\u6790\u5931\u8d25,{}", (Object)orgiSql);
        }
        if (this.jdbcTemplate == null) {
            DataSource dataSource = configuration.getEnvironment().getDataSource();
            this.jdbcTemplate = new JdbcTemplate(dataSource);
            this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
            this.catalog = dataSource.getConnection().getCatalog();
        }
        String sql = SqlTools.showSql(configuration, boundSql);
        ArrayList<RecordOperationLog> logList = new ArrayList<RecordOperationLog>();
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            if (statement instanceof Insert) {
                this.handInsert((Insert)statement, logList, parameter);
            } else if (statement instanceof Update) {
                this.handUpdate((Update)statement, logList);
            }
            long startTime = System.currentTimeMillis();
            if (CollUtil.isNotEmpty(logList)) {
                logList.forEach(l -> l.setHandleTime(Long.valueOf(System.currentTimeMillis() - startTime)));
                String tName = this.dcCataLogName + "record_operation_log_master";
                String insertSQL = "INSERT INTO " + tName + " (id,table_name,company_id,log_title,change_field,log_type,busi_type,before_info,after_info,ip,create_by,create_by_name,sup_id,sup_name,timestamp) VALUES (:id, :tableName,:companyId,:logTitle,:changeField,:logType,:busiType,:beforeInfo,:afterInfo,:ip,:createBy,:createByName,:supId,:supName,:timestamp)";
                ArrayList bsList = new ArrayList();
                logList.forEach(l -> bsList.add(new BeanPropertySqlParameterSource(l)));
                BeanPropertySqlParameterSource[] as = new BeanPropertySqlParameterSource[bsList.size()];
                this.namedParameterJdbcTemplate.batchUpdate(insertSQL, (SqlParameterSource[])bsList.toArray(as));
            }
        }
        catch (Exception e) {
            log.error("\u654f\u611f\u6570\u636e\u76d1\u63a7sql:{}, \u89e3\u6790\u51fa\u9519:{}", (Object)sql, (Object)e);
        }
    }

    public static String extractTableName(String sql) {
        String tableName = null;
        Pattern pattern = Pattern.compile("\\b(?i)(?:insert\\s+into|delete\\s+from|update|merge\\s+into)\\s+((?:\\w+\\.)*\\w+)");
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            tableName = matcher.group(1);
        }
        if (StringUtils.isNotBlank(tableName) && tableName.contains(".")) {
            tableName = tableName.substring(tableName.indexOf(".") + 1);
        }
        return tableName;
    }

    private void buildInsertMapList(List<Map<String, Object>> insertMapList, List<Column> columnList, ExpressionList expressionListBean) {
        List expressionList = expressionListBean.getExpressions();
        HashMap<String, String> insertMap = new HashMap<String, String>();
        for (int i = 0; i < columnList.size(); ++i) {
            Column column = columnList.get(i);
            Expression expression = (Expression)expressionList.get(i);
            insertMap.put(column.getColumnName(), expression.toString());
        }
        insertMapList.add(insertMap);
    }

    private static Byte getBusiType(Object parameter) {
        Object insertCompanyType;
        Byte busiType = null;
        Map parameterMap = BeanUtil.beanToMap((Object)parameter, (String[])new String[0]);
        if (MapUtils.isNotEmpty((Map)parameterMap) && (insertCompanyType = parameterMap.get("insertCompanyType")) != null) {
            if ("1".equals(insertCompanyType.toString())) {
                busiType = RecordOperationTypeEnum.NEW_USER.getKey();
            }
            if ("2".equals(insertCompanyType.toString())) {
                busiType = RecordOperationTypeEnum.IMPORT_USER.getKey();
            }
            if ("3".equals(insertCompanyType.toString())) {
                busiType = RecordOperationTypeEnum.COMPANY_IN_STORAGE.getKey();
            }
        }
        return busiType;
    }
}

