/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.busilog.interceptor;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTools {
    private static final Logger log = LoggerFactory.getLogger(SqlTools.class);

    private SqlTools() {
    }

    public static String showSql(Configuration configuration, BoundSql boundSql) {
        boolean hasParams;
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappingList = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        boolean bl = hasParams = parameterObject != null && CollectionUtils.isNotEmpty((Collection)parameterMappingList);
        if (hasParams) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(SqlTools.getParameterValue(parameterObject)));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappingList) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(SqlTools.getParameterValue(obj)));
                        continue;
                    }
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        obj = boundSql.getAdditionalParameter(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(SqlTools.getParameterValue(obj)));
                        continue;
                    }
                    sql = sql.replaceFirst("\\?", "\u7f3a\u5931");
                }
            }
        }
        return sql;
    }

    private static String getParameterValue(Object obj) {
        String value;
        if (obj instanceof String) {
            String string = obj.toString();
            if (string.contains("'")) {
                string = string.replace("'", "\\'");
            }
            value = "'" + string + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(new Date()) + "'";
        } else {
            value = String.valueOf(obj);
        }
        return value;
    }

    public static void main(String[] args) {
        String ajdkfd1 = SqlTools.getParameterValue("ajdkfd1''");
        System.out.println(ajdkfd1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractDbaseName(Configuration configuration) {
        String schema = "";
        Environment environment = configuration.getEnvironment();
        DataSource dataSource = environment.getDataSource();
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            schema = connection.getCatalog();
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error("SqlTools::\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38:", (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    log.error("SqlTools::\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38:", (Throwable)e);
                }
            }
        }
        return schema;
    }

    public static List<String> splitMutilSQL(String sqlString) {
        ArrayList<String> sqlStatements = new ArrayList<String>();
        StringBuilder currentStatement = new StringBuilder();
        int openQuotes = 0;
        for (int i = 0; i < sqlString.length(); ++i) {
            char c = sqlString.charAt(i);
            currentStatement.append(c);
            if (c == '\'') {
                ++openQuotes;
            }
            if (c != ';' || openQuotes % 2 != 0) continue;
            String statement = currentStatement.toString().trim();
            if (!statement.isEmpty()) {
                sqlStatements.add(statement);
            }
            currentStatement.setLength(0);
        }
        String lastStatement = currentStatement.toString().trim();
        if (!lastStatement.isEmpty()) {
            sqlStatements.add(lastStatement);
        }
        return sqlStatements;
    }
}

