/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.busilog.interceptor;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.smarthse.busilog.interceptor.SqlTools;
import cn.smarthse.modules.busilog.RecordOperationLog;
import cn.smarthse.modules.busilog.RecordOperationTypeEnum;
import com.alibaba.dubbo.rpc.RpcContext;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.apache.commons.collections.MapUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
@Deprecated
public class SensitiveDataInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(SensitiveDataInterceptor.class);
    private static final String PROD = "prod";
    private static final String COMPANY = "company";
    private static final String LOG_SCHEMA_TABLE = "test3_bigdata.record_operation_log_master";
    private static final String LOG_SCHEMA_TABLE_PROD = "db_bigdata_center.record_operation_log_master";
    private static final Map<String, String> DEV_PROD_DB_MAP;
    private static final String DEV_URL = "jdbc:mysql://smarthse.51vip.biz:3306/test3_bigdata?useUnicode=true&characterEncoding=utf8&serverTimezone=GMT%2B8&rewriteBatchedStatements=true&zeroDateTimeBehavior=CONVERT_TO_NULL";
    private static final String DEV_USERNAME = "ehs-root2";
    private static final String DEV_PASSWORD = "test1234567";
    private static final String PROD_URL = "jdbc:mysql://c9dv54sl9wauss9c8aym-rw4rm.maxscale.rds.internet.cloud-inner.zj.gov.cn:3306/db_bigdata_center?serverTimezone=Asia/Shanghai";
    private static final String PROD_USERNAME = "admin_ra";
    private static final String PROD_PASSWORD = "yA%GRe5r$Ux5B^QK";
    private String env;
    private boolean enable;
    private Set<String> recordKeySet;
    private Set<String> recordTableSet;
    private JdbcTemplate jdbcTemplate;

    public Object intercept(Invocation invocation) throws Throwable {
        if (this.enable) {
            this.doLog(invocation);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.enable = Boolean.parseBoolean(properties.getProperty("enable"));
        this.env = properties.getProperty("env");
        this.recordKeySet = this.getRecordKeySet(properties.getProperty("recordKeys"));
        this.recordTableSet = this.getRecordTableSet(this.recordKeySet);
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setUrl(DEV_URL);
        dataSource.setUsername(DEV_USERNAME);
        dataSource.setPassword(DEV_PASSWORD);
        if (StringUtils.isNotBlank((CharSequence)this.env) && PROD.equals(this.env)) {
            dataSource.setUrl(PROD_URL);
            dataSource.setUsername(PROD_USERNAME);
            dataSource.setPassword(PROD_PASSWORD);
        }
        this.jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
    }

    private void doLog(Invocation invocation) {
        boolean skip = "true".equals(RpcContext.getContext().getAttachments().get("skip_sensitive_log"));
        if (skip) {
            return;
        }
        long startTime = System.currentTimeMillis();
        Object[] args = invocation.getArgs();
        Object parameter = args.length > 1 ? args[1] : null;
        MappedStatement mappedStatement = (MappedStatement)args[0];
        Configuration configuration = mappedStatement.getConfiguration();
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        try {
            String tName = SensitiveDataInterceptor.extractTableName(boundSql.getSql());
            boolean pass = this.recordTableSet.contains(tName);
            if (pass) {
                List<Column> columnList;
                String sql = SqlTools.showSql(configuration, boundSql);
                Statement statement = CCJSqlParserUtil.parse((String)sql);
                ArrayList<RecordOperationLog> logList = new ArrayList<RecordOperationLog>();
                if (statement instanceof Update) {
                    Update update = (Update)statement;
                    ArrayList<String> updateEntryList = new ArrayList<String>();
                    HashMap<String, String> updateColumnMap = new HashMap<String, String>();
                    for (UpdateSet updateSet : update.getUpdateSets()) {
                        columnList = updateSet.getColumns();
                        ArrayList expressionList = updateSet.getExpressions();
                        for (int i = 0; i < columnList.size(); ++i) {
                            String key = tName + "." + ((Column)columnList.get(i)).getColumnName();
                            updateEntryList.add(key);
                            updateColumnMap.put(key, String.valueOf(expressionList.get(i)));
                        }
                    }
                    Set entrySet = updateEntryList.stream().filter(this.recordKeySet::contains).collect(Collectors.toSet());
                    if (CollUtil.isNotEmpty(entrySet)) {
                        boolean irsChange = Boolean.TRUE.equals(Convert.toBool(RpcContext.getContext().getAttachments().get("irs_lead_to_change_business_state")));
                        PlainSelect selectBefore = new PlainSelect();
                        ArrayList<SelectExpressionItem> selectItemList = new ArrayList<SelectExpressionItem>();
                        selectItemList.add(new SelectExpressionItem((Expression)new Column("*")));
                        selectBefore.setSelectItems(selectItemList);
                        String dName = "company_report_info".equalsIgnoreCase(tName) ? (PROD.equals(this.env) ? "db_hse" : "test2") : (PROD.equals(this.env) ? "db_bigdata_center" : "test3_bigdata");
                        Table t = new Table(dName, tName);
                        selectBefore.setFromItem((FromItem)t);
                        selectBefore.setWhere(update.getWhere());
                        long current = System.currentTimeMillis();
                        List beforeMapList = this.jdbcTemplate.queryForList(selectBefore.toString());
                        for (Map beforeMap : beforeMapList) {
                            for (String entry : entrySet) {
                                String after;
                                String column = entry.split("\\.")[1];
                                String beforeStr = String.valueOf(beforeMap.get(column)).trim();
                                String afterStr = String.valueOf(updateColumnMap.get(entry)).trim();
                                String before = beforeStr.replace("'", "").replace("\"", "");
                                if (Objects.equals(before, after = afterStr.replace("'", "").replace("\"", ""))) continue;
                                long cid = COMPANY.equals(tName) ? Convert.toLong(beforeMap.get("id"), (Long)Convert.toLong(beforeMap.get("ID"))) : Convert.toLong(beforeMap.get("cid"), (Long)Convert.toLong(beforeMap.get("CID")));
                                log.info("\u654f\u611f\u65e5\u5fd7\u62e6\u622a\uff0c\u8bb0\u5f55\u64cd\u4f5c\u53d8\u66f4\u4fe1\u606f::{}::{}::{}::{}->{}", new Object[]{tName, cid, column, before, after});
                                String ip = (String)RpcContext.getContext().getAttachments().get("ip_addr");
                                String op = (String)RpcContext.getContext().getAttachments().get("operator_id");
                                RecordOperationLog log = new RecordOperationLog();
                                log.setId(Long.valueOf(IdWorker.getId()));
                                log.setTableName(tName);
                                log.setCompanyId(Long.valueOf(cid));
                                log.setChangeField(column);
                                log.setLogType(Integer.valueOf(1));
                                Byte busiType = Arrays.stream(RecordOperationTypeEnum.values()).filter(enu -> enu.getColumn().equalsIgnoreCase(column)).map(RecordOperationTypeEnum::getKey).findFirst().orElse(null);
                                log.setBusiType(busiType);
                                boolean businessStateChange = Objects.equals(busiType, RecordOperationTypeEnum.BUSI_TYPE_CHANGE.getKey());
                                boolean out = Objects.equals(after, "0");
                                if (businessStateChange && irsChange && out) {
                                    log.setLogTitle("\u7531 " + before + " \u53d8\u66f4\u4e3a " + after + "\uff08\u5e02\u573a\u76d1\u7ba1\u6570\u636e\u4e2d\u8be5\u4f01\u4e1a\u5df2\u6ce8\u9500\uff09");
                                } else {
                                    log.setLogTitle("\u7531 " + before + " \u53d8\u66f4\u4e3a " + after);
                                }
                                log.setBeforeInfo(before);
                                log.setAfterInfo(after);
                                log.setIp(ip);
                                log.setCreateBy(Convert.toLong((Object)op));
                                log.setTimestamp(Long.valueOf(current));
                                logList.add(log);
                            }
                        }
                    }
                }
                if (statement instanceof Insert) {
                    Insert insert = (Insert)statement;
                    if (COMPANY.equals(tName)) {
                        RpcContext context = RpcContext.getContext();
                        String ip = (String)context.getAttachments().get("ip_addr");
                        String op = (String)context.getAttachments().get("operator_id");
                        ArrayList<Map<String, Object>> insertMapList = new ArrayList<Map<String, Object>>();
                        columnList = insert.getColumns();
                        ItemsList itemList = insert.getItemsList();
                        ExpressionList expressionListBean = (ExpressionList)itemList;
                        if (expressionListBean.isUsingBrackets()) {
                            this.buildInsertMapList(insertMapList, columnList, expressionListBean);
                        } else {
                            expressionListBean.getExpressions().forEach(expression -> this.buildInsertMapList(insertMapList, columnList, ((RowConstructor)expression).getExprList()));
                        }
                        long current = System.currentTimeMillis();
                        Byte busiType = SensitiveDataInterceptor.getBusiType(parameter);
                        for (Map map : insertMapList) {
                            Long cid = Convert.toLong(map.get("id"), (Long)Convert.toLong(map.get("ID")));
                            String value = RecordOperationTypeEnum.getValue((Byte)busiType);
                            log.info("\u654f\u611f\u65e5\u5fd7\u62e6\u622a\uff0c\u6570\u636e\u8868\u65b0\u589e\u884c::{}::{}::{}", new Object[]{tName, cid, value});
                            RecordOperationLog log = new RecordOperationLog();
                            log.setId(Long.valueOf(IdWorker.getId()));
                            log.setTableName(tName);
                            log.setCompanyId(cid);
                            log.setLogTitle(value);
                            log.setLogType(Integer.valueOf(3));
                            log.setBusiType(busiType);
                            log.setIp(ip);
                            log.setCreateBy(Convert.toLong((Object)op));
                            log.setTimestamp(Long.valueOf(current));
                            logList.add(log);
                        }
                    }
                }
                if (CollUtil.isNotEmpty(logList)) {
                    logList.forEach(l -> l.setHandleTime(Long.valueOf(System.currentTimeMillis() - startTime)));
                    List<String> insertSqlList = SensitiveDataInterceptor.buildInsertSql(logList, PROD.equals(this.env) ? LOG_SCHEMA_TABLE_PROD : LOG_SCHEMA_TABLE);
                    this.jdbcTemplate.batchUpdate(insertSqlList.toArray(new String[0]));
                }
            }
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u654f\u611f\u65e5\u5fd7\u5f02\u5e38::", (Throwable)e);
        }
    }

    private Set<String> getRecordKeySet(String recordKeys) {
        HashSet<String> keySet = new HashSet<String>();
        String[] keyArray = recordKeys.split("\\s*,\\s*");
        Map dbMap = PROD.equals(this.env) ? DEV_PROD_DB_MAP : MapUtil.reverse(DEV_PROD_DB_MAP);
        for (String key : keyArray) {
            String[] partArray = key.split("\\.");
            String db1 = partArray[0];
            String db2 = dbMap.getOrDefault(db1, db1);
            StringBuilder newKey = new StringBuilder(db2);
            for (int i = 1; i < partArray.length; ++i) {
                newKey.append(".").append(partArray[i]);
            }
            keySet.add(newKey.toString());
        }
        return keySet.stream().map(t -> t.substring(t.indexOf(".") + 1).toLowerCase()).collect(Collectors.toSet());
    }

    private Set<String> getRecordTableSet(Set<String> recordKeySet) {
        return CollUtil.isEmpty(recordKeySet) ? Collections.emptySet() : recordKeySet.stream().map(t -> t.substring(0, t.indexOf("."))).collect(Collectors.toSet());
    }

    public static String extractTableName(String sql) {
        String tableName = null;
        Pattern pattern = Pattern.compile("\\b(?i)(?:insert\\s+into|delete\\s+from|update|merge\\s+into)\\s+((?:\\w+\\.)*\\w+)");
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            tableName = matcher.group(1);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(tableName) && tableName.contains(".")) {
            tableName = tableName.substring(tableName.indexOf(".") + 1);
        }
        return tableName;
    }

    private void buildInsertMapList(List<Map<String, Object>> insertMapList, List<Column> columnList, ExpressionList expressionListBean) {
        List expressionList = expressionListBean.getExpressions();
        HashMap<String, String> insertMap = new HashMap<String, String>();
        for (int i = 0; i < columnList.size(); ++i) {
            Column column = columnList.get(i);
            Expression expression = (Expression)expressionList.get(i);
            insertMap.put(column.getColumnName(), expression.toString());
        }
        insertMapList.add(insertMap);
    }

    private static Byte getBusiType(Object parameter) {
        Object insertCompanyType;
        Byte busiType = null;
        Map parameterMap = BeanUtil.beanToMap((Object)parameter, (String[])new String[0]);
        if (MapUtils.isNotEmpty((Map)parameterMap) && (insertCompanyType = parameterMap.get("insertCompanyType")) != null) {
            if ("1".equals(insertCompanyType.toString())) {
                busiType = RecordOperationTypeEnum.NEW_USER.getKey();
            }
            if ("2".equals(insertCompanyType.toString())) {
                busiType = RecordOperationTypeEnum.IMPORT_USER.getKey();
            }
        }
        return busiType;
    }

    public static List<String> buildInsertSql(List<RecordOperationLog> logList, String tName) {
        ArrayList<String> sqlList = new ArrayList<String>();
        try {
            Table table = new Table();
            table.setName(tName);
            for (RecordOperationLog log : logList) {
                Insert insert = new Insert();
                insert.setTable(table);
                List<Column> columns = Arrays.asList(new Column("id"), new Column("table_name"), new Column("company_id"), new Column("log_title"), new Column("change_field"), new Column("log_type"), new Column("busi_type"), new Column("before_info"), new Column("after_info"), new Column("ip"), new Column("create_by"), new Column("timestamp"));
                insert.addColumns(columns);
                ExpressionList expressionListBean = new ExpressionList();
                ArrayList<Object> expressionList = new ArrayList<Object>();
                expressionList.add(new LongValue(log.getId().longValue()));
                expressionList.add(log.getTableName() == null ? null : new StringValue(log.getTableName()));
                expressionList.add(log.getCompanyId() == null ? null : new LongValue(log.getCompanyId().longValue()));
                expressionList.add(log.getLogTitle() == null ? null : new StringValue(log.getLogTitle()));
                expressionList.add(log.getChangeField() == null ? null : new StringValue(log.getChangeField()));
                expressionList.add(log.getLogType() == null ? null : new LongValue((long)log.getLogType().intValue()));
                expressionList.add(log.getBusiType() == null ? null : new LongValue((long)log.getBusiType().byteValue()));
                expressionList.add(log.getBeforeInfo() == null ? null : new StringValue(log.getBeforeInfo()));
                expressionList.add(log.getAfterInfo() == null ? null : new StringValue(log.getAfterInfo()));
                expressionList.add(log.getIp() == null ? null : new StringValue(log.getIp()));
                expressionList.add(log.getCreateBy() == null ? null : new LongValue(log.getCreateBy().longValue()));
                expressionList.add(new LongValue(log.getTimestamp().longValue()));
                expressionListBean.setExpressions(expressionList);
                insert.setItemsList((ItemsList)expressionListBean);
                sqlList.add(String.valueOf(insert));
            }
        }
        catch (Exception e) {
            log.error("\u6784\u5efaINSERT\u8bed\u53e5\u5931\u8d25", (Throwable)e);
        }
        return sqlList;
    }

    static {
        HashMap<String, String> dbMap = new HashMap<String, String>();
        dbMap.put("test3_bigdata", "db_bigdata_center");
        dbMap.put("test2", "db_hse");
        DEV_PROD_DB_MAP = dbMap;
    }
}

