/*
 * Decompiled with CFR 0.152.
 */
package cn.shuibo.advice;

import cn.shuibo.annotation.Encrypt;
import cn.shuibo.config.SecretKeyConfig;
import cn.shuibo.util.Base64Util;
import cn.shuibo.util.RSAUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class EncryptResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean encrypt;
    @Autowired
    private SecretKeyConfig secretKeyConfig;
    private static ThreadLocal<Boolean> encryptLocal = new ThreadLocal();

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        this.encrypt = false;
        if (returnType.getMethod().isAnnotationPresent(Encrypt.class) && !this.secretKeyConfig.isDebug()) {
            this.encrypt = true;
        }
        return this.encrypt;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        Boolean status = encryptLocal.get();
        if (null != status && !status.booleanValue()) {
            encryptLocal.remove();
            return body;
        }
        if (this.encrypt) {
            String publicKey = this.secretKeyConfig.getPublicKey();
            try {
                String content = JSON.toJSONString((Object)body);
                if (!StringUtils.hasText((String)publicKey)) {
                    throw new NullPointerException("Please configure rsa.encrypt.privatekeyc parameter!");
                }
                byte[] data = content.getBytes();
                byte[] encodedData = RSAUtil.encrypt(data, publicKey);
                String result = Base64Util.encode(encodedData);
                this.log.info("Pre-encrypted data\uff1a{}\uff0cAfter encryption\uff1a{}", (Object)content, (Object)result);
                return result;
            }
            catch (Exception e) {
                this.log.error("Encrypted data exception", (Throwable)e);
            }
        }
        return body;
    }
}

