/*
 * Decompiled with CFR 0.152.
 */
package cn.shuibo.advice;

import cn.shuibo.util.Base64Util;
import cn.shuibo.util.RSAUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;

public class DecryptHttpInputMessage
implements HttpInputMessage {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private HttpHeaders headers;
    private InputStream body;

    public DecryptHttpInputMessage(HttpInputMessage inputMessage, String privateKey, String charset) throws Exception {
        String decryptBody;
        if (StringUtils.isEmpty((CharSequence)privateKey)) {
            throw new IllegalArgumentException("privateKey is null");
        }
        this.headers = inputMessage.getHeaders();
        String content = new BufferedReader(new InputStreamReader(inputMessage.getBody())).lines().collect(Collectors.joining(System.lineSeparator()));
        if (content.startsWith("{")) {
            this.log.info("Unencrypted without decryption:{}", (Object)content);
            decryptBody = content;
        } else {
            StringBuilder json = new StringBuilder();
            if (!StringUtils.isEmpty((CharSequence)(content = content.replaceAll(" ", "+")))) {
                String[] contents;
                for (String value : contents = content.split("\\|")) {
                    value = new String(RSAUtil.decrypt(Base64Util.decode(value), privateKey), charset);
                    json.append(value);
                }
            }
            decryptBody = json.toString();
            this.log.info("Encrypted data received\uff1a{},After decryption\uff1a{}", (Object)content, (Object)decryptBody);
        }
        this.body = new ByteArrayInputStream(decryptBody.getBytes());
    }

    public InputStream getBody() {
        return this.body;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }
}

