/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.user.block;

import io.rong.RongCloud;
import io.rong.models.Result;
import io.rong.models.response.BlockUserResult;
import io.rong.models.response.ResponseResult;
import io.rong.models.user.UserModel;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class Block {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "user/block";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public Block(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public Result add(UserModel user) throws Exception {
        String message = CommonUtil.checkFiled(user, PATH, "add");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(user.getId().toString(), UTF8));
        sb.append("&minute=").append(URLEncoder.encode(user.getMinute().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/user/block.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "add", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public ResponseResult remove(String userId) throws Exception {
        String message = CommonUtil.checkParam("id", userId, PATH, "remove");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(userId.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/user/unblock.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "remove", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public Result getList() throws Exception {
        StringBuilder sb = new StringBuilder();
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/user/block/query.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (BlockUserResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "getList", HttpUtil.returnResult(conn)), BlockUserResult.class);
    }
}

