/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.user;

import io.rong.RongCloud;
import io.rong.methods.user.blacklist.Blacklist;
import io.rong.methods.user.block.Block;
import io.rong.methods.user.onlinestatus.OnlineStatus;
import io.rong.models.Result;
import io.rong.models.response.ResponseResult;
import io.rong.models.response.TokenResult;
import io.rong.models.user.UserModel;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class User {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "user";
    private String appKey;
    private String appSecret;
    public Block block;
    public Blacklist blackList;
    public OnlineStatus onlineStatus;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
        this.block.setRongCloud(rongCloud);
        this.blackList.setRongCloud(rongCloud);
        this.onlineStatus.setRongCloud(rongCloud);
    }

    public User(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.block = new Block(appKey, appSecret);
        this.blackList = new Blacklist(appKey, appSecret);
        this.onlineStatus = new OnlineStatus(appKey, appSecret);
    }

    public TokenResult register(UserModel user) throws Exception {
        String message = CommonUtil.checkFiled(user, PATH, "register");
        if (null != message) {
            return (TokenResult)GsonUtil.fromJson(message, TokenResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(user.id.toString(), UTF8));
        sb.append("&name=").append(URLEncoder.encode(user.name.toString(), UTF8));
        sb.append("&portraitUri=").append(URLEncoder.encode(user.portrait.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/user/getToken.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (TokenResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "register", HttpUtil.returnResult(conn)), TokenResult.class);
    }

    public Result update(UserModel user) throws Exception {
        String body;
        String message = CommonUtil.checkFiled(user, PATH, "update");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(user.id.toString(), UTF8));
        if (user.name != null) {
            sb.append("&name=").append(URLEncoder.encode(user.name.toString(), UTF8));
        }
        if (user.portrait != null) {
            sb.append("&portraitUri=").append(URLEncoder.encode(user.portrait.toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/user/refresh.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "update", HttpUtil.returnResult(conn)), ResponseResult.class);
    }
}

