/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.group;

import io.rong.RongCloud;
import io.rong.exception.ParamException;
import io.rong.methods.group.gag.Gag;
import io.rong.models.CommonConstrants;
import io.rong.models.Result;
import io.rong.models.group.GroupMember;
import io.rong.models.group.GroupModel;
import io.rong.models.group.UserGroup;
import io.rong.models.response.GroupUserQueryResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class Group {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "group";
    private String appKey;
    private String appSecret;
    public Gag gag;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
        this.gag.setRongCloud(rongCloud);
    }

    public Group(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.gag = new Gag(appKey, appSecret);
        this.gag.setRongCloud(this.rongCloud);
    }

    public Result create(GroupModel group) throws Exception {
        GroupMember[] members;
        String message = CommonUtil.checkFiled(group, PATH, "create");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (GroupMember member : members = group.getMembers()) {
            sb.append("&userId=").append(URLEncoder.encode(member.getId().toString(), UTF8));
        }
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        sb.append("&groupName=").append(URLEncoder.encode(group.getName().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/group/create.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "create", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public Result sync(UserGroup user) throws Exception {
        if (user == null) {
            throw new ParamException(CommonConstrants.RCLOUD_PARAM_NULL, "/group/sync", "Paramer 'user' is required");
        }
        String message = CommonUtil.checkFiled(user, PATH, "sync");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(user.getId(), UTF8));
        for (int i = 0; i < user.getGroups().length; ++i) {
            GroupModel child = user.getGroups()[i];
            if (child.getName() == null) {
                throw new ParamException(CommonConstrants.RCLOUD_PARAM_NULL, "/group/sync", "Paramer 'group.name' is required");
            }
            if (child.getId() == null) {
                throw new ParamException(CommonConstrants.RCLOUD_PARAM_NULL, "/group/sync", "Paramer 'group.id' is required");
            }
            sb.append("&group[" + child.getId() + "]=").append(URLEncoder.encode(child.getName(), UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/group/sync.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "sync", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public Result update(GroupModel group) throws Exception {
        String message = CommonUtil.checkFiled(group, PATH, "update");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        sb.append("&groupName=").append(URLEncoder.encode(group.getName().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/group/refresh.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "update", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public Result invite(GroupModel group) throws Exception {
        GroupMember[] members;
        String message = CommonUtil.checkFiled(group, PATH, "invite");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (GroupMember member : members = group.getMembers()) {
            sb.append("&userId=").append(URLEncoder.encode(member.getId().toString(), UTF8));
        }
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        sb.append("&groupName=").append(URLEncoder.encode(group.getName().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/group/join.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "invite", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public Result join(GroupModel group) throws Exception {
        GroupMember[] members;
        String message = CommonUtil.checkFiled(group, PATH, "join");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (GroupMember member : members = group.getMembers()) {
            sb.append("&userId=").append(URLEncoder.encode(member.getId().toString(), UTF8));
        }
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        sb.append("&groupName=").append(URLEncoder.encode(group.getName().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/group/join.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "join", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public GroupUserQueryResult get(GroupModel group) throws Exception {
        String errMsg = CommonUtil.checkFiled(group, PATH, "get");
        if (null != errMsg) {
            return (GroupUserQueryResult)GsonUtil.fromJson(errMsg, GroupUserQueryResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/group/user/query.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (GroupUserQueryResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "get", HttpUtil.returnResult(conn)), GroupUserQueryResult.class);
    }

    public Result quit(GroupModel group) throws Exception {
        GroupMember[] members;
        String message = CommonUtil.checkFiled(group, PATH, "quit");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (GroupMember member : members = group.getMembers()) {
            sb.append("&userId=").append(URLEncoder.encode(member.getId().toString(), UTF8));
        }
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/group/quit.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "quit", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public Result dismiss(GroupModel group) throws Exception {
        String message = CommonUtil.checkFiled(group, PATH, "dismiss");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        GroupMember member = group.getMembers()[0];
        sb.append("&userId=").append(URLEncoder.encode(member.getId().toString(), UTF8));
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/group/dismiss.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "dismiss", HttpUtil.returnResult(conn)), ResponseResult.class);
    }
}

