/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.chatroom.ban;

import io.rong.RongCloud;
import io.rong.exception.ParamException;
import io.rong.models.CommonConstrants;
import io.rong.models.chatroom.ChatroomMember;
import io.rong.models.chatroom.ChatroomModel;
import io.rong.models.response.ListGagChatroomUserResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class Ban {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "chatroom/global-gag";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public Ban(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public ResponseResult add(ChatroomModel chatroom) throws Exception {
        ChatroomMember[] members;
        String errMsg = CommonUtil.checkFiled(chatroom, PATH, "add");
        if (null != errMsg) {
            return (ResponseResult)GsonUtil.fromJson(errMsg, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (ChatroomMember member : members = chatroom.getMembers()) {
            sb.append("&userId=").append(URLEncoder.encode(member.getId(), UTF8));
        }
        sb.append("&minute=").append(URLEncoder.encode(chatroom.getMinute().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/chatroom/user/ban/add.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "add", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public ListGagChatroomUserResult getList() throws Exception {
        StringBuilder sb = new StringBuilder();
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/chatroom/user/ban/query.json", "application/x-www-form-urlencoded");
        return (ListGagChatroomUserResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "getList", HttpUtil.returnResult(conn)), ListGagChatroomUserResult.class);
    }

    public ResponseResult remove(ChatroomModel chatroom) throws Exception {
        ChatroomMember[] members;
        if (chatroom == null) {
            throw new ParamException(CommonConstrants.RCLOUD_PARAM_NULL, "/chatroom/user/ban/remove", "Paramer 'chatroom' is required");
        }
        String errMsg = CommonUtil.checkFiled(chatroom, PATH, "remove");
        if (null != errMsg) {
            return (ResponseResult)GsonUtil.fromJson(errMsg, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (ChatroomMember member : members = chatroom.getMembers()) {
            sb.append("&userId=").append(URLEncoder.encode(member.getId(), UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/chatroom/user/ban/remove.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "remove", HttpUtil.returnResult(conn)), ResponseResult.class);
    }
}

