/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.write.handler;

import cn.idev.excel.enums.CellDataTypeEnum;
import cn.idev.excel.metadata.Head;
import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.write.handler.CellWriteHandler;
import cn.idev.excel.write.metadata.holder.WriteSheetHolder;
import cn.idev.excel.write.metadata.holder.WriteTableHolder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.streaming.SXSSFCell;

public class EscapeHexCellWriteHandler
implements CellWriteHandler {
    private static final boolean[] HEX_TABLE;

    @Override
    public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, WriteCellData<?> cellData, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        String originalString;
        if (cellData != null && cell instanceof SXSSFCell && CellDataTypeEnum.STRING.equals((Object)cellData.getType()) && (originalString = cellData.getStringValue()) != null) {
            String escapedString = this.escapeHex(originalString);
            cellData.setStringValue(escapedString);
        }
    }

    private String escapeHex(String originalString) {
        int patternIndex;
        int length = originalString.length();
        if (length < 7) {
            return originalString;
        }
        int searchStart = 0;
        while ((patternIndex = originalString.indexOf("_x", searchStart)) != -1 && patternIndex + 6 < length) {
            if (originalString.charAt(patternIndex + 6) == '_' && EscapeHexCellWriteHandler.isValidHexFast(originalString, patternIndex + 2)) {
                return this.processWithPatterns(originalString, patternIndex);
            }
            searchStart = patternIndex + 2;
        }
        return originalString;
    }

    private String processWithPatterns(String originalString, int firstPatternIndex) {
        int patternIndex;
        int length = originalString.length();
        StringBuilder result = new StringBuilder(length + 64);
        result.append(originalString, 0, firstPatternIndex);
        result.append("_x005F_x");
        result.append(originalString, firstPatternIndex + 2, firstPatternIndex + 6);
        result.append('_');
        int lastEnd = firstPatternIndex + 7;
        int searchStart = firstPatternIndex + 7;
        while ((patternIndex = originalString.indexOf("_x", searchStart)) != -1 && patternIndex + 6 < length) {
            if (originalString.charAt(patternIndex + 6) == '_' && EscapeHexCellWriteHandler.isValidHexFast(originalString, patternIndex + 2)) {
                result.append(originalString, lastEnd, patternIndex);
                result.append("_x005F_x");
                result.append(originalString, patternIndex + 2, patternIndex + 6);
                result.append('_');
                lastEnd = patternIndex + 7;
                searchStart = patternIndex + 7;
                continue;
            }
            searchStart = patternIndex + 2;
        }
        if (lastEnd < length) {
            result.append(originalString, lastEnd, length);
        }
        return result.toString();
    }

    private static boolean isValidHexFast(String str, int startIndex) {
        for (int i = 0; i < 4; ++i) {
            char c = str.charAt(startIndex + i);
            if (c < '\u0080' && HEX_TABLE[c]) continue;
            return false;
        }
        return true;
    }

    static {
        int c;
        HEX_TABLE = new boolean[128];
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            EscapeHexCellWriteHandler.HEX_TABLE[c] = true;
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            EscapeHexCellWriteHandler.HEX_TABLE[c] = true;
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            EscapeHexCellWriteHandler.HEX_TABLE[c] = true;
        }
    }
}

