/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.util;

import cn.idev.excel.metadata.NullObject;
import cn.idev.excel.support.cglib.beans.BeanMap;
import cn.idev.excel.util.ClassUtils;
import cn.idev.excel.util.MemberUtils;
import cn.idev.excel.util.StringUtils;
import cn.idev.excel.util.Validate;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;

public class FieldUtils {
    public static Class<?> nullObjectClass = NullObject.class;
    private static final int START_RESOLVE_FIELD_LENGTH = 2;

    public static Class<?> getFieldClass(Map dataMap, String fieldName, Object value) {
        Class fieldClass;
        if (dataMap instanceof BeanMap && (fieldClass = ((BeanMap)dataMap).getPropertyType(fieldName)) != null) {
            return fieldClass;
        }
        return FieldUtils.getFieldClass(value);
    }

    public static Class<?> getFieldClass(Object value) {
        if (value != null) {
            return value.getClass();
        }
        return nullObjectClass;
    }

    public static String resolveCglibFieldName(Field field) {
        if (field == null) {
            return null;
        }
        String fieldName = field.getName();
        if (StringUtils.isBlank(fieldName) || fieldName.length() < 2) {
            return fieldName;
        }
        char firstChar = fieldName.charAt(0);
        char secondChar = fieldName.charAt(1);
        if (Character.isUpperCase(firstChar) == Character.isUpperCase(secondChar)) {
            return fieldName;
        }
        if (Character.isUpperCase(firstChar)) {
            return FieldUtils.buildFieldName(Character.toLowerCase(firstChar), fieldName);
        }
        return FieldUtils.buildFieldName(Character.toUpperCase(firstChar), fieldName);
    }

    private static String buildFieldName(char firstChar, String fieldName) {
        return firstChar + fieldName.substring(1);
    }

    public static Field getField(Class<?> cls, String fieldName) {
        Field field = FieldUtils.getField(cls, fieldName, false);
        MemberUtils.setAccessibleWorkaround(field);
        return field;
    }

    public static Field getField(Class<?> cls, String fieldName, boolean forceAccess) {
        Validate.isTrue(cls != null, "The class must not be null", new Object[0]);
        Validate.isTrue(StringUtils.isNotBlank(fieldName), "The field name must not be blank/empty", new Object[0]);
        for (Class<?> acls = cls; acls != null; acls = acls.getSuperclass()) {
            try {
                Field field = acls.getDeclaredField(fieldName);
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (!forceAccess) continue;
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        Field match = null;
        for (Class<?> class1 : ClassUtils.getAllInterfaces(cls)) {
            try {
                Field test = class1.getField(fieldName);
                Validate.isTrue(match == null, "Reference to field %s is ambiguous relative to %s; a matching field exists on two or more implemented interfaces.", fieldName, cls);
                match = test;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return match;
    }
}

