/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.fileconvertor.v07;

import cn.idev.excel.fileconvertor.BaseExcelConverter;
import cn.idev.excel.fileconvertor.Excel2PdfUtils;
import cn.idev.excel.fileconvertor.FileConverterContext;
import cn.idev.excel.fileconvertor.v07.XlsxImageTableRenderer;
import cn.idev.excel.util.StringUtils;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.DashedBorder;
import com.itextpdf.layout.borders.DottedBorder;
import com.itextpdf.layout.borders.DoubleBorder;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.renderer.IRenderer;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class XlsxConverter
extends BaseExcelConverter {
    private static final String DEFAULT_FONT_PATH = System.getProperty("user.dir") + "/doc/font/SimHei.TTF";

    public XlsxConverter(FileConverterContext context) {
        super(context);
    }

    @Override
    public void addPicsToTable(Table table, Sheet sheet) {
        XSSFDrawing drawing = (XSSFDrawing)sheet.createDrawingPatriarch();
        if (drawing != null) {
            ArrayList<XSSFPicture> pictures = new ArrayList<XSSFPicture>();
            for (XSSFShape shape : drawing.getShapes()) {
                if (!(shape instanceof XSSFPicture)) continue;
                pictures.add((XSSFPicture)shape);
            }
            table.setNextRenderer((IRenderer)new XlsxImageTableRenderer(table, pictures, (XSSFSheet)sheet));
        }
    }

    @Override
    public Cell convertCell(org.apache.poi.ss.usermodel.Cell cell, int rowspan, int colspan, float maxWidth, String fontPath) throws IOException {
        String value = Excel2PdfUtils.getValue(cell);
        Cell pdfCell = this.createPdfCell(rowspan, colspan, cell, value, maxWidth, fontPath);
        return pdfCell;
    }

    public static void transformBorder(XSSFCell cell, Cell pdfCell) {
        XSSFCellStyle cellStyle = cell.getCellStyle();
        BorderStyle borderBottom = cellStyle.getBorderBottom();
        pdfCell.setBorderBottom(XlsxConverter.getBorder(borderBottom, cellStyle.getBottomBorderXSSFColor()));
        BorderStyle borderLeft = cellStyle.getBorderLeft();
        pdfCell.setBorderLeft(XlsxConverter.getBorder(borderLeft, cellStyle.getLeftBorderXSSFColor()));
        BorderStyle borderRight = cellStyle.getBorderRight();
        pdfCell.setBorderRight(XlsxConverter.getBorder(borderRight, cellStyle.getRightBorderXSSFColor()));
        BorderStyle borderTop = cellStyle.getBorderTop();
        pdfCell.setBorderTop(XlsxConverter.getBorder(borderTop, cellStyle.getTopBorderXSSFColor()));
    }

    private Cell createPdfCell(int rowspan, int colspan, org.apache.poi.ss.usermodel.Cell cell, String value, float maxWidth, String fontPath) throws IOException {
        Cell pdfCell = (Cell)((Cell)new Cell(rowspan, colspan).setHeight(cell.getRow().getHeightInPoints() * 1.2f)).setPadding(0.0f);
        Text text = new Text(value);
        this.setPdfCellFont((XSSFCell)cell, text, fontPath);
        Paragraph paragraph = (Paragraph)((Paragraph)new Paragraph(text).setPadding(0.0f)).setMargin(0.0f);
        XSSFCellStyle cellStyle = ((XSSFCell)cell).getCellStyle();
        if (cellStyle.getWrapText()) {
            paragraph.setMaxWidth(maxWidth);
        }
        pdfCell.add((IBlockElement)paragraph);
        this.setCellStyles((XSSFCell)cell, pdfCell);
        return pdfCell;
    }

    private void setCellStyles(XSSFCell cell, Cell pdfCell) throws IOException {
        XSSFCellStyle cellStyle = cell.getCellStyle();
        ((Cell)pdfCell.setVerticalAlignment(XlsxConverter.getVerticalAlignment(cellStyle.getVerticalAlignment()))).setTextAlignment(XlsxConverter.getTextAlignment(cellStyle.getAlignment(), cell.getCellType()));
        this.setBorders(pdfCell, cellStyle);
        this.setBackgroundColor(pdfCell, cellStyle);
    }

    private void setBorders(Cell pdfCell, XSSFCellStyle cellStyle) {
        pdfCell.setBorderBottom(XlsxConverter.getBorder(cellStyle.getBorderBottom(), cellStyle.getBottomBorderXSSFColor()));
        pdfCell.setBorderLeft(XlsxConverter.getBorder(cellStyle.getBorderLeft(), cellStyle.getLeftBorderXSSFColor()));
        pdfCell.setBorderRight(XlsxConverter.getBorder(cellStyle.getBorderRight(), cellStyle.getRightBorderXSSFColor()));
        pdfCell.setBorderTop(XlsxConverter.getBorder(cellStyle.getBorderTop(), cellStyle.getTopBorderXSSFColor()));
    }

    private void setBackgroundColor(Cell pdfCell, XSSFCellStyle cellStyle) {
        byte[] rgb;
        XSSFColor fillColor = cellStyle.getFillForegroundXSSFColor();
        if (fillColor != null && (rgb = fillColor.getRGB()) != null) {
            pdfCell.setBackgroundColor((Color)new DeviceRgb(Byte.toUnsignedInt(rgb[0]), Byte.toUnsignedInt(rgb[1]), Byte.toUnsignedInt(rgb[2])));
        }
    }

    private void setPdfCellFont(XSSFCell cell, Text text, String fontPath) throws IOException {
        XSSFCellStyle cellStyle = cell.getCellStyle();
        short fontHeight = cellStyle.getFont().getFontHeightInPoints();
        cellStyle.getFont().getFontName();
        text.setFont(StringUtils.isEmpty(fontPath) ? PdfFontFactory.createFont() : PdfFontFactory.createFont((String)fontPath, (String)"Identity-H"));
        text.setFontSize((float)fontHeight);
        this.setFontColor(cellStyle.getFont(), text);
        this.setFontStyles(cell.getCellStyle().getFont(), text);
    }

    private void setFontColor(XSSFFont font, Text text) {
        byte[] rgb;
        XSSFColor xssfColor = font.getXSSFColor();
        if (xssfColor != null && xssfColor.getIndex() != 64 && (rgb = xssfColor.getRGB()) != null) {
            text.setFontColor((Color)new DeviceRgb(Byte.toUnsignedInt(rgb[0]), Byte.toUnsignedInt(rgb[1]), Byte.toUnsignedInt(rgb[2])));
        }
    }

    private void setFontStyles(XSSFFont font, Text text) {
        if (font.getBold()) {
            text.setBold();
        }
        if (font.getItalic()) {
            text.setItalic();
        }
        if (font.getUnderline() == 1) {
            text.setUnderline(0.5f, -1.0f);
        }
    }

    public static Border getBorder(BorderStyle borderStyle, XSSFColor xSSFColor) {
        byte[] rgb;
        DeviceRgb defaultColor = new DeviceRgb(0, 0, 0);
        if (xSSFColor != null && (rgb = xSSFColor.getRGB()) != null) {
            defaultColor = new DeviceRgb(Byte.toUnsignedInt(rgb[0]), Byte.toUnsignedInt(rgb[1]), Byte.toUnsignedInt(rgb[2]));
        }
        switch (borderStyle) {
            case THIN: {
                return new SolidBorder((Color)defaultColor, 0.3f);
            }
            case MEDIUM: {
                return new SolidBorder((Color)defaultColor, 0.5f);
            }
            case DASHED: {
                return new DashedBorder((Color)defaultColor, 0.3f);
            }
            case DOTTED: {
                return new DottedBorder((Color)defaultColor, 0.3f);
            }
            case THICK: {
                return new SolidBorder((Color)defaultColor, 1.0f);
            }
            case DOUBLE: {
                return new DoubleBorder((Color)defaultColor, 0.3f);
            }
            case MEDIUM_DASHED: {
                return new DashedBorder((Color)defaultColor, 0.5f);
            }
        }
        return Border.NO_BORDER;
    }
}

