/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.fileconvertor.v03;

import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFSheet;

public class XlsImageTableRenderer
extends TableRenderer {
    private List<HSSFPicture> hSSFPictures;
    private HSSFSheet sheet;

    public XlsImageTableRenderer(Table modelElement, List<HSSFPicture> hSSFPictures, HSSFSheet sheet) {
        super(modelElement);
        this.hSSFPictures = hSSFPictures;
        this.sheet = sheet;
    }

    public void drawChildren(DrawContext drawContext) {
        super.drawChildren(drawContext);
        this.drawExcelImages(drawContext);
    }

    private void drawExcelImages(DrawContext drawContext) {
        for (HSSFPicture picture : this.hSSFPictures) {
            HSSFClientAnchor clientAnchor = picture.getClientAnchor();
            Rectangle imageRect = this.calculateImageRectangle(clientAnchor);
            ImageData imageData = ImageDataFactory.create((byte[])picture.getPictureData().getData());
            drawContext.getCanvas().addImage(imageData, imageRect.getWidth(), 0.0f, 0.0f, imageRect.getHeight(), imageRect.getLeft(), imageRect.getTop());
        }
    }

    private Rectangle calculateImageRectangle(HSSFClientAnchor clientAnchor) {
        CellRenderer cellRenderer1 = ((CellRenderer[])this.rows.get(clientAnchor.getRow1()))[clientAnchor.getCol1()];
        Rectangle rect1 = cellRenderer1.getOccupiedAreaBBox();
        CellRenderer cellRenderer2 = ((CellRenderer[])this.rows.get(clientAnchor.getRow2()))[clientAnchor.getCol2()];
        Rectangle rect2 = cellRenderer2.getOccupiedAreaBBox();
        float widthRate = this.calculateWidthRate(rect2);
        float heightRate = this.calculateHeightRate(rect2);
        float width = this.calculateImageWidth(clientAnchor, widthRate);
        float height = this.calculateImageHeight(clientAnchor, heightRate);
        float x = rect1.getLeft() + (float)clientAnchor.getDx1() * widthRate;
        float y = rect1.getTop() - height - (float)clientAnchor.getDy1() * heightRate;
        return new Rectangle(x, y, width, height);
    }

    private float calculateWidthRate(Rectangle rect2) {
        return (super.getOccupiedAreaBBox().getWidth() + rect2.getWidth()) / this.getExcelWidth(this.sheet);
    }

    private float calculateHeightRate(Rectangle rect2) {
        return (super.getOccupiedAreaBBox().getHeight() - rect2.getHeight()) / this.getExcelHeight(this.sheet);
    }

    private float calculateImageWidth(HSSFClientAnchor clientAnchor, float widthRate) {
        float width = 0.0f;
        for (int j = clientAnchor.getCol1(); j < clientAnchor.getCol2(); ++j) {
            width += (float)this.sheet.getColumnWidth(j);
        }
        return Math.abs(width - (float)clientAnchor.getDx1() + (float)clientAnchor.getDx2()) * widthRate;
    }

    private float calculateImageHeight(HSSFClientAnchor clientAnchor, float heightRate) {
        float height = 0.0f;
        for (int j = clientAnchor.getRow1(); j < clientAnchor.getRow2(); ++j) {
            height += (float)this.sheet.getRow(j).getHeight();
        }
        return Math.abs(height - (float)clientAnchor.getDy1() + (float)clientAnchor.getDy2()) * heightRate;
    }

    private float getExcelHeight(HSSFSheet sheet) {
        int physicalNumberOfRows = sheet.getPhysicalNumberOfRows();
        float result = 0.0f;
        for (int i = 0; i < physicalNumberOfRows; ++i) {
            result += (float)sheet.getRow(i).getHeight();
        }
        return result;
    }

    private float getExcelWidth(HSSFSheet sheet) {
        int lastCellNum = sheet.getRow(0).getLastCellNum();
        float result = 0.0f;
        for (int i = 0; i < lastCellNum; ++i) {
            result += (float)sheet.getColumnWidth(i);
        }
        return result;
    }

    public IRenderer getNextRenderer() {
        return new XlsImageTableRenderer((Table)this.modelElement, this.hSSFPictures, this.sheet);
    }
}

