/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.fileconvertor;

import cn.idev.excel.fileconvertor.ExcelConverter;
import cn.idev.excel.fileconvertor.v03.XlsConverter;
import cn.idev.excel.fileconvertor.v07.XlsxConverter;
import cn.idev.excel.read.metadata.ReadWorkbook;
import cn.idev.excel.support.ExcelTypeEnum;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FileConverterContext {
    private File inputFile;
    private File outputFile;
    private String fountPath;
    private Workbook workbook;
    private Document document;
    private int[] sheets;
    private ExcelTypeEnum excelTypeEnum;

    public FileConverterContext(File inputFile, File outputFile, String fountPath, int[] sheets) {
        try {
            this.inputFile = inputFile;
            this.outputFile = outputFile;
            this.fountPath = fountPath;
            ReadWorkbook readWorkbook = new ReadWorkbook();
            readWorkbook.setFile(inputFile);
            this.excelTypeEnum = ExcelTypeEnum.valueOf(readWorkbook);
            if (this.excelTypeEnum == ExcelTypeEnum.XLSX) {
                this.workbook = new XSSFWorkbook(inputFile);
            } else if (this.excelTypeEnum == ExcelTypeEnum.XLS) {
                this.workbook = new HSSFWorkbook((InputStream)new FileInputStream(inputFile));
            } else {
                throw new IllegalArgumentException("Not supported excel type");
            }
            PdfDocument pdfDocument = new PdfDocument(new PdfWriter(outputFile));
            this.document = new Document(pdfDocument, PageSize.A4.rotate());
            if (sheets == null) {
                this.sheets = new int[this.workbook.getNumberOfSheets()];
                for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                    this.sheets[i] = i;
                }
            } else {
                this.sheets = sheets;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException(e);
        }
    }

    public ExcelConverter getExcelConverter() {
        if (this.excelTypeEnum == ExcelTypeEnum.XLSX) {
            return new XlsxConverter(this);
        }
        if (this.excelTypeEnum == ExcelTypeEnum.XLS) {
            return new XlsConverter(this);
        }
        throw new IllegalArgumentException("Not supported excel type");
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public String getFountPath() {
        return this.fountPath;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Document getDocument() {
        return this.document;
    }

    public int[] getSheets() {
        return this.sheets;
    }

    public ExcelTypeEnum getExcelTypeEnum() {
        return this.excelTypeEnum;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setFountPath(String fountPath) {
        this.fountPath = fountPath;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setSheets(int[] sheets) {
        this.sheets = sheets;
    }

    public void setExcelTypeEnum(ExcelTypeEnum excelTypeEnum) {
        this.excelTypeEnum = excelTypeEnum;
    }
}

